<?php

session_start();

if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect($database);

$check_access = check_access($connect);

if ($check_access['user_role'] == 1){

    // Handle unban action
    if (isset($_GET['unban']) && !empty($_GET['unban'])) {
        $ban_id = intval($_GET['unban']);
        $connect->prepare("DELETE FROM banned_ips WHERE ban_id = :id")->execute([':id' => $ban_id]);
        header('Location: ./banned_ips.php?success=unbanned');
        exit;
    }

    // Get all banned IPs
    $banned_ips = $connect->query("SELECT bi.*, u.user_name as banned_by_name 
        FROM banned_ips bi 
        LEFT JOIN users u ON bi.banned_by = u.user_id 
        ORDER BY bi.banned_at DESC")->fetchAll(PDO::FETCH_ASSOC);

    require '../views/header.view.php';
    require '../views/banned_ips.view.php';

}else{
    header('Location:'.SITE_URL);
}

require '../views/footer.view.php';

}else {
    header('Location: ./login.php');		
}

?>
