-- Update SEO Meta Tags for Better Google Search Appearance
-- Run this SQL to improve your store and category SEO

-- ============================================
-- UPDATE STORE SEO TITLES & DESCRIPTIONS
-- ============================================

-- Amazon
UPDATE stores 
SET 
  store_seotitle = 'Amazon Coupons & Promo Codes - Save Up to 80% | Alonedeals',
  store_seodescription = 'Get verified Amazon coupons and promo codes. Save up to 80% on electronics, fashion, home & more. Find exclusive deals and cashback offers. Updated daily!'
WHERE store_slug = 'amazon';

-- Flipkart
UPDATE stores 
SET 
  store_seotitle = 'Flipkart Coupons & Offers - Best Deals & Discounts | Alonedeals',
  store_seodescription = 'Discover Flipkart coupons and promo codes. Save big on mobiles, electronics, fashion, and more. Get exclusive cashback offers and verified discount codes.'
WHERE store_slug = 'flipkart';

-- Myntra
UPDATE stores 
SET 
  store_seotitle = 'Myntra Coupons & Promo Codes - Fashion Deals Up to 70% Off | Alonedeals',
  store_seodescription = 'Shop with Myntra coupons and save up to 70% on fashion, clothing, shoes & accessories. Get verified promo codes, exclusive deals and cashback offers.'
WHERE store_slug = 'myntra';

-- Ajio
UPDATE stores 
SET 
  store_seotitle = 'Ajio Coupons & Offers - Fashion Discounts Up to 60% | Alonedeals',
  store_seodescription = 'Find Ajio coupons and promo codes for fashion, clothing & accessories. Save up to 60% with verified discount codes and exclusive cashback offers.'
WHERE store_slug = 'ajio';

-- Swiggy
UPDATE stores 
SET 
  store_seotitle = 'Swiggy Coupons & Promo Codes - Food Delivery Offers | Alonedeals',
  store_seodescription = 'Get Swiggy coupons and promo codes for food delivery. Save on your orders with verified discount codes, cashback offers and exclusive deals.'
WHERE store_slug = 'swiggy';

-- Zomato
UPDATE stores 
SET 
  store_seotitle = 'Zomato Coupons & Offers - Food Delivery Discounts | Alonedeals',
  store_seodescription = 'Discover Zomato coupons and promo codes. Save on food delivery with verified discount codes, exclusive offers and cashback deals.'
WHERE store_slug = 'zomato';

-- MakeMyTrip
UPDATE stores 
SET 
  store_seotitle = 'MakeMyTrip Coupons & Offers - Travel Deals & Discounts | Alonedeals',
  store_seodescription = 'Book with MakeMyTrip coupons and save on flights, hotels & holidays. Get verified promo codes, exclusive travel deals and cashback offers.'
WHERE store_slug = 'makemytrip' OR store_slug = 'makemytrip-flights';

-- ============================================
-- UPDATE CATEGORY SEO TITLES & DESCRIPTIONS
-- ============================================

-- Fashion
UPDATE categories 
SET 
  category_seotitle = 'Fashion Coupons & Deals - Best Discounts on Clothing | Alonedeals',
  category_seodescription = 'Discover the best fashion coupons and deals. Save on clothing, shoes, accessories from top brands. Get exclusive promo codes and cashback offers.'
WHERE category_slug = 'fashion';

-- Beauty & Health
UPDATE categories 
SET 
  category_seotitle = 'Beauty & Health Coupons - Skincare & Wellness Deals | Alonedeals',
  category_seodescription = 'Find beauty and health coupons for skincare, makeup, wellness products. Save with verified promo codes and exclusive cashback offers.'
WHERE category_slug = 'beauty-health';

-- Food & Dining
UPDATE categories 
SET 
  category_seotitle = 'Food & Dining Coupons - Restaurant & Delivery Deals | Alonedeals',
  category_seodescription = 'Get food delivery and restaurant coupons. Save on orders from Swiggy, Zomato & more. Find verified promo codes and exclusive dining offers.'
WHERE category_slug = 'food-dining';

-- Travel
UPDATE categories 
SET 
  category_seotitle = 'Travel Coupons & Deals - Flight, Hotel & Holiday Offers | Alonedeals',
  category_seodescription = 'Book travel with exclusive coupons. Save on flights, hotels, holidays & more. Get verified promo codes and cashback offers from top travel sites.'
WHERE category_slug = 'travel';

-- Electronics
UPDATE categories 
SET 
  category_seotitle = 'Electronics Coupons & Deals - Best Tech Discounts | Alonedeals',
  category_seodescription = 'Shop electronics with exclusive coupons. Save on mobiles, laptops, TVs & more. Get verified promo codes and cashback offers from top brands.'
WHERE category_slug = 'mobiles-tablets' OR category_slug = 'computers-laptops-gaming';

-- Entertainment
UPDATE categories 
SET 
  category_seotitle = 'Entertainment Coupons & Deals - Movie, Music & Gaming Offers | Alonedeals',
  category_seodescription = 'Find entertainment coupons for movies, music, gaming & more. Save with verified promo codes and exclusive cashback offers.'
WHERE category_slug = 'entertainment';

-- Home & Living
UPDATE categories 
SET 
  category_seotitle = 'Home & Living Coupons - Furniture & Decor Deals | Alonedeals',
  category_seodescription = 'Shop home and living products with exclusive coupons. Save on furniture, decor, appliances & more. Get verified promo codes and cashback offers.'
WHERE category_slug = 'home-furnishing-decorations';

-- Appliances
UPDATE categories 
SET 
  category_seotitle = 'Appliances Coupons & Deals - Best Discounts on Home Appliances | Alonedeals',
  category_seodescription = 'Buy appliances with exclusive coupons. Save on refrigerators, washing machines, ACs & more. Get verified promo codes and cashback offers.'
WHERE category_slug = 'appliances';

-- Sports & Fitness
UPDATE categories 
SET 
  category_seotitle = 'Sports & Fitness Coupons - Gym, Equipment & Apparel Deals | Alonedeals',
  category_seodescription = 'Shop sports and fitness products with exclusive coupons. Save on gym equipment, apparel, supplements & more. Get verified promo codes and offers.'
WHERE category_slug = 'sports-fitness';

-- Kids & Toys
UPDATE categories 
SET 
  category_seotitle = 'Kids & Toys Coupons - Baby Products & Toy Deals | Alonedeals',
  category_seodescription = 'Find kids and toys coupons for baby products, toys, clothing & more. Save with verified promo codes and exclusive cashback offers.'
WHERE category_slug = 'kids-babies-toys';

-- ============================================
-- VERIFY UPDATES
-- ============================================

-- Check updated stores
SELECT store_slug, store_seotitle, store_seodescription 
FROM stores 
WHERE store_seotitle IS NOT NULL 
ORDER BY store_slug;

-- Check updated categories
SELECT category_slug, category_seotitle, category_seodescription 
FROM categories 
WHERE category_seotitle IS NOT NULL 
ORDER BY category_slug;

-- ============================================
-- NOTES
-- ============================================
-- 1. Customize these for your actual store slugs
-- 2. Add more stores as needed
-- 3. Keep titles under 60 characters
-- 4. Keep descriptions under 160 characters
-- 5. After running this, request indexing in Google Search Console
