<?php require'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="ti ti-shopping-bag"></i> <?php echo _ADDITEM; ?> Product</h5>
            </div>
          </div>

          <div class="col-md-12">
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">

                <div class="form-row">
                  <div class="form-group col-md-9">
                    <div class="block col-md-12">

                      <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                      <input type="text" placeholder="Product Title" name="product_title" class="form-control" required="">

                      <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>
                      <textarea type="text" class="form-control" name="product_description" rows="4" placeholder="Product description (optional)"></textarea>

                      <label class="required"><?php echo _TABLEFIELDSTORE; ?></label>
                      <select class="custom-select form-control" name="product_store" required="">
                        <option value="" selected>--- Select Store ---</option>
                        <?php foreach($stores as $item): ?>
                          <option value="<?php echo $item['store_id']; ?>"><?php echo $item['store_title']; ?></option>
                        <?php endforeach; ?>
                      </select>

                      <label><?php echo _TABLEFIELDCATEGORY; ?></label>
                      <select class="custom-select form-control" name="product_category">
                        <option value="">--- Select Category (Optional) ---</option>
                        <?php foreach($categories as $item): ?>
                          <option value="<?php echo $item['category_id']; ?>"><?php echo $item['category_title']; ?></option>
                        <?php endforeach; ?>
                      </select>

                     <div class="row">

                      <div class="col-6">
                        <label>Original Price (₹)</label>
                        <input type="number" step="0.01" placeholder="999.00" name="product_original_price" class="form-control" id="original_price">
                      </div>

                      <div class="col-6">
                        <label>Sale Price (₹)</label>
                        <input type="number" step="0.01" placeholder="799.00" name="product_sale_price" class="form-control" id="sale_price">
                      </div>

                    </div>

                    <div class="row">
                      <div class="col-6">
                        <label>Discount %</label>
                        <input type="text" placeholder="Auto-calculated" name="product_discount_percentage" class="form-control" id="discount_percentage" readonly style="background: #f5f5f5;">
                        <small class="text-muted">Auto-calculated from prices</small>
                      </div>

                      <div class="col-6">
                        <label>Cashback Info</label>
                        <input type="text" placeholder="e.g., Extra 5% cashback" name="product_cashback" class="form-control">
                      </div>
                    </div>

                   <label class="required">Affiliate Link</label>
                   <input type="text" placeholder="https://..." name="product_affiliate_link" class="form-control" required="">
                   <small class="text-muted">The product purchase link</small>

                   <div class="row mt-3">

                    <div class="col-4">
                      <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                      <select class="custom-select form-control" name="product_featured">
                        <option value="0"><?php echo _NOTEXT; ?></option>
                        <option value="1"><?php echo _YESTEXT; ?></option>
                      </select>
                    </div>

                    <div class="col-4">
                      <label class="control-label">Display Order</label>
                      <input type="number" name="product_order" class="form-control" value="0">
                      <small class="text-muted">Lower numbers appear first</small>
                    </div>

                  </div>

                </div>
              </div>
              <div class="form-group col-md-3 sidebar">

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="product_status" required="">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="0"><?php echo _DISABLED; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                <label><?php echo _TABLEFIELDIMAGE; ?></label>

                <div class="new-image" id="image-preview">
                  <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                  <input type="file" name="product_image" id="image-upload" accept="image/*" />
                </div>

                <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>500 x 500</b> </span>
                <br/>
              </div>

              <div class="block col-md-12 mt-3">
                <label>CDN Image URL</label>
                <input type="text" name="product_image_cdn_url" class="form-control" placeholder="https://cdn.example.com/image.jpg">
                <small class="text-muted">Or use external CDN URL</small>
                
                <div class="mt-2">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="product_use_cdn" value="1" style="width: 18px; height: 18px; margin-right: 8px;">
                    <span>Use CDN URL</span>
                  </label>
                  <small class="text-muted">Check to use CDN URL instead of uploaded image</small>
                </div>
              </div>

              <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

            </div>

          </div>
        </form>

      </div>
    </div>
  </div>
</div>
</div>
</div>
</section>

<script>
// Auto-calculate discount percentage
document.getElementById('original_price').addEventListener('input', calculateDiscount);
document.getElementById('sale_price').addEventListener('input', calculateDiscount);

function calculateDiscount() {
  const original = parseFloat(document.getElementById('original_price').value) || 0;
  const sale = parseFloat(document.getElementById('sale_price').value) || 0;
  
  if (original > 0 && sale > 0 && sale < original) {
    const discount = Math.round(((original - sale) / original) * 100);
    document.getElementById('discount_percentage').value = discount + '%';
  } else {
    document.getElementById('discount_percentage').value = '';
  }
}
</script>
