// Animated Placeholder for Search Input
document.addEventListener('DOMContentLoaded', function() {
    const inputs = document.querySelectorAll('.animated-placeholder');
    
    inputs.forEach(input => {
        const placeholders = JSON.parse(input.getAttribute('data-placeholders') || '[]');
        
        if (placeholders.length === 0) return;
        
        let currentIndex = 0;
        let charIndex = 0;
        let isDeleting = false;
        let isPaused = false;
        
        function type() {
            // Don't animate if input has focus or value
            if (document.activeElement === input || input.value.length > 0) {
                setTimeout(type, 100);
                return;
            }
            
            const currentText = placeholders[currentIndex];
            
            if (isPaused) {
                isPaused = false;
                setTimeout(type, 2000); // Pause for 2 seconds before deleting
                return;
            }
            
            if (!isDeleting) {
                // Typing
                input.placeholder = currentText.substring(0, charIndex + 1);
                charIndex++;
                
                if (charIndex === currentText.length) {
                    isPaused = true;
                    isDeleting = true;
                }
                
                setTimeout(type, 100); // Typing speed
            } else {
                // Deleting
                input.placeholder = currentText.substring(0, charIndex - 1);
                charIndex--;
                
                if (charIndex === 0) {
                    isDeleting = false;
                    currentIndex = (currentIndex + 1) % placeholders.length;
                    setTimeout(type, 500); // Pause before next word
                } else {
                    setTimeout(type, 50); // Deleting speed (faster)
                }
            }
        }
        
        // Start the animation
        type();
        
        // Stop animation when input is focused
        input.addEventListener('focus', function() {
            this.placeholder = '';
        });
        
        // Resume animation when input loses focus and is empty
        input.addEventListener('blur', function() {
            if (this.value.length === 0) {
                charIndex = 0;
                isDeleting = false;
                isPaused = false;
                setTimeout(type, 500);
            }
        });
    });
});
