<?php
/**
 * Header JS - All JavaScript files loaded in <head>
 * Centralized location for easy CDN URL management
 */

// Set your CDN base URL here (leave empty to use local files)
$cdn_js_url = ''; // Example: 'https://cdn.example.com/js'

// Helper function to get JS URL
function getHeaderJsUrl($filename) {
    global $cdn_js_url, $urlPath;
    if (!empty($cdn_js_url)) {
        return $cdn_js_url . '/' . $filename;
    }
    return $urlPath->assets_js($filename);
}
?>

<!-- External CDN JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<!-- Core JS Files -->
<script src="<?php echo getHeaderJsUrl('jquery.js'); ?>"></script>>
<script src="https://assets.alonedeals.com/assets/js/uikit.js"></script>
<script src="https://assets.alonedeals.com/assets/js/uikit-icons.js"></script>
<script src="https://assets.alonedeals.com/assets/js/swiper-init.js"></script>
<script src="https://assets.alonedeals.com/assets/js/sticky-header.js"></script>
<script src="https://assets.alonedeals.com/assets/js/scroll-to-top.js"></script>
<script src="https://assets.alonedeals.com/assets/js/ajax-search.js"></script>
<script src="https://assets.alonedeals.com/assets/js/animated-placeholder.js"></script>
<script src="https://assets.alonedeals.com/assets/js/popup-system.js"></script>
<script src="https://assets.alonedeals.com/assets/js/push-notifications.js"></script>
<script src="https://assets.alonedeals.com/assets/js/coupon-filter.js">
