<?php include './sections/page-title.php'; ?>

<!-- BreadcrumbList Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo SITE_URL; ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "<?php echo echoOutput($itemDetails['store_title']); ?>",
      "item": "<?php echo SITE_URL . '/store/' . $itemDetails['store_slug']; ?>"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "<?php echo echoOutput($itemDetails['coupon_title']); ?>",
      "item": "<?php echo SITE_URL . '/coupon/' . $itemDetails['coupon_slug']; ?>"
    }
  ]
}
</script>

<!-- Offer Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Offer",
  "name": "<?php echo echoOutput($itemDetails['coupon_title']); ?>",
  "description": "<?php echo echoOutput($itemDetails['coupon_description']); ?>",
  "url": "<?php echo SITE_URL . '/coupon/' . $itemDetails['coupon_slug']; ?>",
  "image": "<?php echo $urlPath->image($itemDetails['store_image']); ?>",
  "seller": {
    "@type": "Organization",
    "name": "<?php echo echoOutput($itemDetails['store_title']); ?>"
  },
  <?php if(!empty($itemDetails['coupon_code'])): ?>
  "priceSpecification": {
    "@type": "PriceSpecification",
    "priceCurrency": "USD",
    "price": "0"
  },
  "eligibleTransactionVolume": {
    "@type": "PriceSpecification",
    "priceCurrency": "USD",
    "minPrice": "0"
  },
  <?php endif; ?>
  <?php if(!empty($itemDetails['coupon_expire'])): ?>
  "priceValidUntil": "<?php echo date('Y-m-d', strtotime($itemDetails['coupon_expire'])); ?>",
  <?php endif; ?>
  "availability": "https://schema.org/InStock"
}
</script>

<div class="uk-container">

<div uk-grid>

<div class="uk-width-1-1 uk-width-expand@m">

    <div class="uk-card uk-card-default uk-card-body coupon-modal">
        
        <?php if(empty($itemDetails)): ?>
            <p><?php echo echoOutput($translation['tr_37']); ?></p>
        <?php endif; ?>

        <?php if(!empty($itemDetails)): ?>

            <div class="uk-text-center">
                
                <?php if(!empty($itemDetails['coupon_code'])): ?>
                    <div class="coupon-header-wrapper">
                        <img class="image" src="<?php echo $urlPath->image($itemDetails['store_image']); ?>" alt="<?php echo echoOutput($itemDetails['store_title']); ?>">
                        <!-- Collapsible Details Button Badge -->
                        <button class="details-toggle-badge" onclick="toggleCouponDetails()" id="couponDetailsToggleBtn">
                            Details
                        </button>
                    </div>
                    <h2 class="title"><?php echo echoOutput($itemDetails['coupon_title']); ?></h2>
                    <p><?php echo echoOutput($translation['tr_23']); ?> <a href="<?php echo $urlPath->redirect($itemDetails['coupon_id']); ?>" target="_blank"><?php echo echoOutput($itemDetails['store_title']); ?></a></p>

                    <div class="coupon">
                        <div><p class="uk-text-secondary uk-text-bold"><?php echo echoOutput($itemDetails['coupon_code']); ?></p></div>
                        <div><a class="uk-button uk-button-primary uk-border-pill uk-text-bold copy" data-clipboard-text="<?php echo echoOutput($itemDetails['coupon_code']); ?>" data-copy="<?php echo echoOutput($translation['tr_87']); ?>" data-copied="<?php echo echoOutput($translation['tr_119']); ?>"><?php echo echoOutput($translation['tr_87']); ?></a></div>
                    </div>

                    <?php if(isset($isFav)): ?>
                    
                        <?php if($isFav == 0): ?>
                        
                            <div class="uk-grid-small uk-flex uk-flex-middle uk-flex-center likes" uk-grid>

                                <div><p class="uk-text-small"><?php echo echoOutput($translation['tr_204']); ?></p></div>
                                <div>

                                    <a class="deslike coupon_deslike uk-text-secondary" data-item="<?php echo echoOutput($itemDetails['coupon_id']); ?>"><i class="fas fa-thumbs-down"></i> <?php echo echoOutput($translation['tr_206']); ?></a>
                                    <a class="like coupon_like uk-text-secondary" data-item="<?php echo echoOutput($itemDetails['coupon_id']); ?>"><i class="fas fa-thumbs-up"></i> <?php echo echoOutput($translation['tr_205']); ?></a>

                                </div>

                            </div>
                        <?php endif; ?>

                        <p class="uk-text-small thanks uk-hidden"><?php echo echoOutput($translation['tr_207']); ?></p>

                        <?php if($isFav == 1): ?>
                        <p class="uk-text-small"><?php echo echoOutput($translation['tr_207']); ?></p>
                        <?php endif; ?>

                    <?php endif; ?>

                <?php endif; ?>

                <?php if(empty($itemDetails['coupon_code'])): ?>
                    <div class="coupon-header-wrapper">
                        <img class="image" src="<?php echo $urlPath->image($itemDetails['store_image']); ?>" alt="<?php echo echoOutput($itemDetails['store_title']); ?>">
                        <!-- Collapsible Details Button Badge -->
                        <button class="details-toggle-badge" onclick="toggleCouponDetails()" id="couponDetailsToggleBtn">
                            Details
                        </button>
                    </div>
                    <h2 class="title"><?php echo echoOutput($itemDetails['coupon_title']); ?></h2>
                    <p class="uk-margin-remove-top"><?php echo echoOutput($translation['tr_89']); ?></p>
                    <a href="<?php echo $urlPath->redirect($itemDetails['coupon_id']); ?>" target="_blank" class="uk-button uk-button-primary uk-border-pill uk-text-bold">
                        <i class="ti ti-shopping-cart"></i>
                        <?php echo echoOutput($translation['tr_98']); ?>
                    </a>
                <?php endif; ?>

            </div>

            <hr>
            
            <!-- Details Section (Hidden by default) -->
            <div id="couponDetailsSection" class="details-section" style="display: none;">
                <?php if(!empty($itemDetails['coupon_expire'])): ?>
                <p class="uk-margin-remove uk-text-secondary uk-text-small"><?php echo echoOutput($translation['tr_99']); ?></p>
                <p class="uk-margin-remove uk-text-small"><?php echo echoOutput($translation['tr_24']); ?> <?php echo formatDate($itemDetails['coupon_expire']); ?></p>
                <?php endif; ?>
                <p class="uk-margin-small-top uk-text-small"><?php echo echoOutput($itemDetails['coupon_description']); ?></p>
            </div>
            
            <hr>
            
            <?php 
            // Set couponDetails for share view
            $couponDetails = $itemDetails;
            require './sections/views/share.view.php'; 
            ?>

        <?php endif; ?>

    </div>

</div>

</div>

</div>

<script>
function toggleCouponDetails() {
    const detailsSection = document.getElementById('couponDetailsSection');
    const toggleBtn = document.getElementById('couponDetailsToggleBtn');
    const arrow = document.getElementById('couponDetailsArrow');
    
    if (detailsSection.style.display === 'none') {
        detailsSection.style.display = 'block';
        toggleBtn.classList.add('active');
    } else {
        detailsSection.style.display = 'none';
        toggleBtn.classList.remove('active');
    }
}
</script>

<?php require './sections/single-modal.php'; ?>
