<?php 

/*--------------------*/
// Add Social Login Columns Migration
// Run this once to add Google and Facebook login settings
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

    require '../../config.php';
    require '../functions.php';

    $connect = connect($database);

    $check_access = check_access($connect);

    if ($check_access['user_role'] == 1 || $check_access['user_role'] == 2){

        $messages = array();
        $errors = array();

        // Check if st_google_login column exists
        try {
            $check_google = $connect->query("SHOW COLUMNS FROM settings LIKE 'st_google_login'");
            $google_exists = $check_google->rowCount() > 0;
            
            if ($google_exists) {
                $messages[] = "✓ Column 'st_google_login' already exists.";
            } else {
                $connect->exec("ALTER TABLE `settings` ADD COLUMN `st_google_login` TINYINT(1) NOT NULL DEFAULT 0");
                $messages[] = "✓ Successfully added 'st_google_login' column.";
            }
        } catch (Exception $e) {
            $errors[] = "Error with st_google_login: " . $e->getMessage();
        }

        // Check if st_facebook_login column exists
        try {
            $check_facebook = $connect->query("SHOW COLUMNS FROM settings LIKE 'st_facebook_login'");
            $facebook_exists = $check_facebook->rowCount() > 0;
            
            if ($facebook_exists) {
                $messages[] = "✓ Column 'st_facebook_login' already exists.";
            } else {
                $connect->exec("ALTER TABLE `settings` ADD COLUMN `st_facebook_login` TINYINT(1) NOT NULL DEFAULT 0");
                $messages[] = "✓ Successfully added 'st_facebook_login' column.";
            }
        } catch (Exception $e) {
            $errors[] = "Error with st_facebook_login: " . $e->getMessage();
        }

        if (empty($errors)) {
            $messages[] = "";
            $messages[] = "✓ Migration completed successfully!";
            $messages[] = "";
            $messages[] = "Next steps:";
            $messages[] = "1. Go to Admin → Firebase Auth";
            $messages[] = "2. You should now see Google and Facebook login options";
            $messages[] = "3. Enable them and save";
        }

        require '../views/header.view.php';
        ?>

        <!--Page Container--> 
        <section class="page-container">
          <div class="page-content-wrapper">
            <div class="content sm-gutter">
              <div class="container-fluid padding-25 sm-padding-10">
                
                <div class="row">
                  <div class="col-12">
                    <div class="section-title">
                      <h5>Social Login Migration</h5>
                      <p class="text-muted">Add Google and Facebook login columns to settings table</p>
                    </div>
                  </div>
                </div>

                <?php if (!empty($messages)): ?>
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-success">
                      <h6><i class="fa fa-check-circle"></i> Migration Results</h6>
                      <?php foreach($messages as $msg): ?>
                        <p class="mb-1"><?php echo htmlspecialchars($msg); ?></p>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>
                <?php endif; ?>

                <?php if (!empty($errors)): ?>
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-danger">
                      <h6><i class="fa fa-exclamation-triangle"></i> Errors</h6>
                      <?php foreach($errors as $error): ?>
                        <p class="mb-1"><?php echo htmlspecialchars($error); ?></p>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>
                <?php endif; ?>

                <div class="row">
                  <div class="col-12">
                    <div class="card">
                      <div class="card-body">
                        <h6>Quick Links</h6>
                        <a href="./firebase_config.php" class="btn btn-primary">
                          <i class="fa fa-fire"></i> Go to Firebase Auth Settings
                        </a>
                        <a href="./settings.php" class="btn btn-secondary">
                          <i class="fa fa-cog"></i> General Settings
                        </a>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
            </div>
          </div>
        </section>

        <?php
        require '../views/footer.view.php';

    } else {
        header('Location:'.SITE_URL);
    }

} else {
    header('Location: ./login.php');		
}

?>
