<?php
/**
 * Slider with Rounded Pill Corners
 * Modern slider design with smooth rounded edges
 * 
 * Usage:
 * Include this in your homepage or slider sections
 */

function renderRoundedPillSlider($sliders) {
    ?>
    <div class="slider-container slider-container-pill">
        <div class="slider-wrapper" id="mainSlider">
            <?php foreach ($sliders as $index => $slider): 
                $imageUrl = getSliderImageUrl($GLOBALS['connect'], $slider);
            ?>
            <div class="slider-item slider-rounded-pill <?php echo $index === 0 ? 'active' : ''; ?>">
                <a href="<?php echo htmlspecialchars($slider['slider_link']); ?>" 
                   <?php echo !empty($slider['slider_link']) ? '' : 'onclick="return false;"'; ?>>
                    <img src="<?php echo htmlspecialchars($imageUrl); ?>" 
                         alt="<?php echo htmlspecialchars($slider['slider_title'] ?? 'Slider'); ?>"
                         class="slider-image"
                         loading="<?php echo $index === 0 ? 'eager' : 'lazy'; ?>">
                </a>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Slider Navigation -->
        <div class="slider-navigation">
            <button class="slider-prev" onclick="sliderPrev()">
                <i class="fa fa-chevron-left"></i>
            </button>
            <button class="slider-next" onclick="sliderNext()">
                <i class="fa fa-chevron-right"></i>
            </button>
        </div>
        
        <!-- Slider Dots -->
        <div class="slider-dots">
            <?php foreach ($sliders as $index => $slider): ?>
            <span class="slider-dot <?php echo $index === 0 ? 'active' : ''; ?>" 
                  onclick="sliderGoTo(<?php echo $index; ?>)"></span>
            <?php endforeach; ?>
        </div>
    </div>
    
    <style>
    .slider-container {
        position: relative;
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
    }
    
    .slider-wrapper {
        position: relative;
        width: 100%;
        overflow: hidden;
    }
    
    .slider-item {
        display: none;
        width: 100%;
        transition: opacity 0.5s ease-in-out;
    }
    
    .slider-item.active {
        display: block;
        animation: fadeIn 0.5s ease-in-out;
    }
    
    .slider-image {
        width: 100%;
        height: auto;
        display: block;
    }
    
    .slider-navigation button {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: rgba(255, 255, 255, 0.9);
        border: none;
        width: 50px;
        height: 50px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 20px;
        color: #333;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        transition: all 0.3s ease;
        z-index: 10;
    }
    
    .slider-navigation button:hover {
        background: #fff;
        transform: translateY(-50%) scale(1.1);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2);
    }
    
    .slider-prev {
        left: 30px;
    }
    
    .slider-next {
        right: 30px;
    }
    
    .slider-dots {
        text-align: center;
        margin-top: 20px;
    }
    
    .slider-dot {
        display: inline-block;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: #ddd;
        margin: 0 6px;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .slider-dot.active {
        background: #667eea;
        width: 30px;
        border-radius: 6px;
    }
    
    .slider-dot:hover {
        background: #999;
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }
    
    @media (max-width: 768px) {
        .slider-navigation button {
            width: 40px;
            height: 40px;
            font-size: 16px;
        }
        
        .slider-prev {
            left: 10px;
        }
        
        .slider-next {
            right: 10px;
        }
    }
    </style>
    
    <script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slider-item');
    const dots = document.querySelectorAll('.slider-dot');
    const totalSlides = slides.length;
    
    function showSlide(index) {
        slides.forEach(slide => slide.classList.remove('active'));
        dots.forEach(dot => dot.classList.remove('active'));
        
        if (index >= totalSlides) currentSlide = 0;
        if (index < 0) currentSlide = totalSlides - 1;
        
        slides[currentSlide].classList.add('active');
        dots[currentSlide].classList.add('active');
    }
    
    function sliderNext() {
        currentSlide++;
        showSlide(currentSlide);
    }
    
    function sliderPrev() {
        currentSlide--;
        showSlide(currentSlide);
    }
    
    function sliderGoTo(index) {
        currentSlide = index;
        showSlide(currentSlide);
    }
    
    // Auto-advance slider every 5 seconds
    setInterval(() => {
        sliderNext();
    }, 5000);
    </script>
    <?php
}

// Example usage:
/*
<?php
require_once 'cdn_image_helper.php';
$sliders = get_all_sliders($connect);
renderRoundedPillSlider($sliders);
?>
*/
?>
