<?php
/**
 * Debug Page - Check what's breaking the site
 */

// Enable all errors
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h1>Debug Information</h1>";
echo "<hr>";

// Test 1: Check if core.php loads
echo "<h2>Test 1: Loading core.php</h2>";
try {
    require "core.php";
    echo "<span style='color: green;'>✓ core.php loaded successfully</span><br>";
} catch (Exception $e) {
    echo "<span style='color: red;'>✗ Error loading core.php: " . $e->getMessage() . "</span><br>";
    die();
}

// Test 2: Check database connection
echo "<h2>Test 2: Database Connection</h2>";
if (isset($connect)) {
    echo "<span style='color: green;'>✓ Database connected</span><br>";
} else {
    echo "<span style='color: red;'>✗ Database not connected</span><br>";
}

// Test 3: Check if functions exist
echo "<h2>Test 3: Required Functions</h2>";
$functions = ['getFeaturedStores', 'getFeaturedCategories', 'getImageUrl', 'getCssUrl'];
foreach ($functions as $func) {
    if (function_exists($func)) {
        echo "<span style='color: green;'>✓ $func() exists</span><br>";
    } else {
        echo "<span style='color: red;'>✗ $func() missing</span><br>";
    }
}

// Test 4: Try to load header
echo "<h2>Test 4: Loading Header</h2>";
try {
    ob_start();
    include './header.php';
    $header = ob_get_clean();
    echo "<span style='color: green;'>✓ Header loaded (" . strlen($header) . " bytes)</span><br>";
} catch (Exception $e) {
    ob_end_clean();
    echo "<span style='color: red;'>✗ Error loading header: " . $e->getMessage() . "</span><br>";
}

// Test 5: Try to load index view
echo "<h2>Test 5: Loading Index View</h2>";
try {
    ob_start();
    include './views/index.view.php';
    $view = ob_get_clean();
    echo "<span style='color: green;'>✓ Index view loaded (" . strlen($view) . " bytes)</span><br>";
} catch (Exception $e) {
    ob_end_clean();
    echo "<span style='color: red;'>✗ Error loading index view: " . $e->getMessage() . "</span><br>";
}

// Test 6: Try to load footer
echo "<h2>Test 6: Loading Footer</h2>";
try {
    ob_start();
    include './footer.php';
    $footer = ob_get_clean();
    echo "<span style='color: green;'>✓ Footer loaded (" . strlen($footer) . " bytes)</span><br>";
} catch (Exception $e) {
    ob_end_clean();
    echo "<span style='color: red;'>✗ Error loading footer: " . $e->getMessage() . "</span><br>";
}

// Test 7: Check for JavaScript errors
echo "<h2>Test 7: JavaScript Files</h2>";
$js_files = [
    'assets/js/jquery.js',
    'assets/js/main.js',
    'assets/js/uikit.js'
];

foreach ($js_files as $file) {
    if (file_exists($file)) {
        $size = filesize($file);
        echo "<span style='color: green;'>✓ $file exists (" . number_format($size) . " bytes)</span><br>";
    } else {
        echo "<span style='color: red;'>✗ $file missing</span><br>";
    }
}

// Test 8: Check CSS files
echo "<h2>Test 8: CSS Files</h2>";
$css_files = [
    'assets/css/styles.css',
    'assets/css/tabler-icons.min.css'
];

foreach ($css_files as $file) {
    if (file_exists($file)) {
        $size = filesize($file);
        echo "<span style='color: green;'>✓ $file exists (" . number_format($size) . " bytes)</span><br>";
    } else {
        echo "<span style='color: red;'>✗ $file missing</span><br>";
    }
}

echo "<hr>";
echo "<h2>Instructions</h2>";
echo "<ol>";
echo "<li>Check the tests above for any red ✗ marks</li>";
echo "<li>Open browser console (F12) and check for JavaScript errors</li>";
echo "<li>Check Network tab for failed requests (red items)</li>";
echo "<li>If all tests pass, the issue is likely JavaScript/CSS loading</li>";
echo "</ol>";

echo "<p><a href='index.php'>Try Homepage</a></p>";
?>
