<?php

$campaigns = getActiveCampaigns($connect, 6);

if (count($campaigns) > 0):
?>

<section class="campaigns-section">
    <div class="uk-container">
        
        <div class="campaigns-header">
            <h2 class="campaigns-title">
                <span class="flash-icon">🔥</span>
                Flash Sale Offers
            </h2>
            <div class="campaigns-countdown" id="midnightCountdown">
                <span>⏰</span>
                <span id="countdownText">Loading...</span>
            </div>
        </div>

        <div class="swiper campaigns-swiper">
            <div class="swiper-wrapper">
                <?php foreach ($campaigns as $campaign): ?>
                <div class="swiper-slide">
                    <a href="<?php 
                        if ($campaign['campaign_link']) {
                            echo htmlspecialchars($campaign['campaign_link']);
                        } elseif ($campaign['campaign_store']) {
                            echo $urlPath->store($campaign['store_slug']);
                        } else {
                            echo '#';
                        }
                    ?>" 
                       class="campaign-card"
                       <?php if ($campaign['campaign_link']): ?>target="_blank" rel="noopener"<?php endif; ?>>
                        <div class="hot-badge">🔥 HOT</div>
                        <div class="campaign-card-inner">
                            <div class="uk-card-media-top">
                                <img src="<?php echo getImageUrl($campaign['campaign_image_cdn_url'], $campaign['campaign_use_cdn'], $campaign['campaign_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($campaign['campaign_title']); ?>"
                                     class="campaign-image">
                            </div>
                        </div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Navigation buttons -->
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>

    </div>
</section>

<script>
// Midnight Countdown Timer
function updateCountdown() {
    const now = new Date();
    const midnight = new Date();
    midnight.setHours(24, 0, 0, 0);
    
    const diff = midnight - now;
    const hours = Math.floor(diff / (1000 * 60 * 60));
    const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((diff % (1000 * 60)) / 1000);
    
    const countdownText = document.getElementById('countdownText');
    if (countdownText) {
        countdownText.textContent = `Ends in ${hours}h ${minutes}m ${seconds}s`;
    }
}

// Update every second
setInterval(updateCountdown, 1000);
updateCountdown();

// Initialize Swiper
document.addEventListener('DOMContentLoaded', function() {
    if (document.querySelector('.campaigns-swiper')) {
        new Swiper('.campaigns-swiper', {
            slidesPerView: 2,
            spaceBetween: 20,
            loop: true,
            loopAdditionalSlides: 2,
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.campaigns-swiper .swiper-button-next',
                prevEl: '.campaigns-swiper .swiper-button-prev',
            },
            breakpoints: {
                320: {
                    slidesPerView: 1,
                    spaceBetween: 15,
                },
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                960: {
                    slidesPerView: 3,
                    spaceBetween: 24,
                },
                1200: {
                    slidesPerView: 4,
                    spaceBetween: 24,
                }
            }
        });
    }
});
</script>

<?php endif; ?>
