<?php
/**
 * Test CSS CDN Configuration
 * Access this file to verify CDN settings
 */

echo "<h1>CSS CDN Configuration Test</h1>";
echo "<hr>";

// Include the header CSS file to get the configuration
ob_start();
include 'views/includes/header-css.php';
$header_output = ob_get_clean();

echo "<h2>1. CDN URL Configuration</h2>";
echo "<strong>CDN CSS URL:</strong> ";
if (empty($cdn_css_url)) {
    echo "<span style='color: green; font-weight: bold;'>✓ EMPTY (Correct - Using Local Files)</span>";
} else {
    echo "<span style='color: red; font-weight: bold;'>✗ SET TO: " . htmlspecialchars($cdn_css_url) . "</span>";
    echo "<br><strong>WARNING:</strong> CDN is enabled! Set to empty string to use local files.";
}

echo "<h2>2. Function Test</h2>";
echo "<strong>getCssUrl('test.css') returns:</strong> ";
$test_url = getCssUrl('test.css');
echo "<code>" . htmlspecialchars($test_url) . "</code>";

if (strpos($test_url, 'assets.alonedeals.com') !== false) {
    echo "<br><span style='color: red; font-weight: bold;'>✗ USING CDN!</span>";
} else {
    echo "<br><span style='color: green; font-weight: bold;'>✓ Using Local Files</span>";
}

echo "<h2>3. Font Files Check</h2>";
$font_files = [
    'tabler-icons.woff2',
    'tabler-icons.woff',
    'tabler-icons.ttf',
    'tabler-icons.eot'
];

echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
echo "<tr><th>Font File</th><th>Status</th><th>URL</th></tr>";

foreach ($font_files as $font) {
    $font_path = __DIR__ . '/assets/fonts/' . $font;
    $exists = file_exists($font_path);
    $url = '/assets/fonts/' . $font;
    
    echo "<tr>";
    echo "<td>" . htmlspecialchars($font) . "</td>";
    echo "<td>" . ($exists ? "<span style='color: green;'>✓ Exists</span>" : "<span style='color: red;'>✗ Missing</span>") . "</td>";
    echo "<td><a href='" . htmlspecialchars($url) . "' target='_blank'>" . htmlspecialchars($url) . "</a></td>";
    echo "</tr>";
}

echo "</table>";

echo "<h2>4. CSS Files Check</h2>";
$css_files = [
    'tabler-icons.min.css',
    'sidenav-redesign.css',
    'filter-sidebar-redesign.css'
];

echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
echo "<tr><th>CSS File</th><th>Status</th><th>URL</th></tr>";

foreach ($css_files as $css) {
    $css_path = __DIR__ . '/assets/css/' . $css;
    $exists = file_exists($css_path);
    $url = '/assets/css/' . $css;
    
    echo "<tr>";
    echo "<td>" . htmlspecialchars($css) . "</td>";
    echo "<td>" . ($exists ? "<span style='color: green;'>✓ Exists</span>" : "<span style='color: red;'>✗ Missing</span>") . "</td>";
    echo "<td><a href='" . htmlspecialchars($url) . "' target='_blank'>" . htmlspecialchars($url) . "</a></td>";
    echo "</tr>";
}

echo "</table>";

echo "<h2>5. Cache Busting</h2>";
echo "<strong>Current Timestamp:</strong> " . time();
echo "<br><strong>This changes on every page load to force cache refresh</strong>";

echo "<h2>6. Next Steps</h2>";
echo "<ol>";
echo "<li><strong>Clear Browser Cache:</strong> Ctrl+Shift+Delete → Clear All</li>";
echo "<li><strong>Clear Server Cache:</strong> <a href='clear_server_cache.php'>Run clear_server_cache.php</a></li>";
echo "<li><strong>Hard Refresh:</strong> Ctrl+F5 or Ctrl+Shift+R</li>";
echo "<li><strong>Test in Incognito:</strong> Ctrl+Shift+N (Chrome) or Ctrl+Shift+P (Firefox)</li>";
echo "</ol>";

echo "<h2>7. Expected Results</h2>";
echo "<ul>";
echo "<li>✓ CDN CSS URL should be EMPTY</li>";
echo "<li>✓ getCssUrl() should return local path (starting with /assets/)</li>";
echo "<li>✓ All font files should exist</li>";
echo "<li>✓ All CSS files should exist</li>";
echo "<li>✓ No CORS errors in browser console</li>";
echo "</ul>";

echo "<hr>";
echo "<p><a href='index.php'>← Back to Homepage</a></p>";
?>
