<!DOCTYPE html>
<html>
<head>
    <title>Simple Test Page</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
        }
        .box {
            background: white;
            padding: 20px;
            margin: 10px 0;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .success { border-left: 4px solid #28a745; }
        .error { border-left: 4px solid #dc3545; }
        .warning { border-left: 4px solid #ffc107; }
    </style>
</head>
<body>
    <h1>Simple Test Page</h1>
    
    <div class="box success">
        <h2>✓ HTML is Working</h2>
        <p>If you can see this, basic HTML is rendering correctly.</p>
    </div>

    <div class="box warning">
        <h2>Testing JavaScript</h2>
        <p id="js-test">JavaScript is NOT working</p>
        <script>
            document.getElementById('js-test').innerHTML = '✓ JavaScript is working!';
            document.getElementById('js-test').style.color = 'green';
        </script>
    </div>

    <div class="box warning">
        <h2>Testing jQuery</h2>
        <p id="jquery-test">jQuery is NOT loaded</p>
        <script src="/assets/js/jquery.js"></script>
        <script>
            if (typeof jQuery !== 'undefined') {
                $('#jquery-test').html('✓ jQuery is loaded!').css('color', 'green');
            }
        </script>
    </div>

    <div class="box warning">
        <h2>Testing PHP</h2>
        <?php
        echo "<p style='color: green;'>✓ PHP is working! Version: " . phpversion() . "</p>";
        ?>
    </div>

    <div class="box warning">
        <h2>Testing File Access</h2>
        <?php
        $files_to_check = [
            'assets/js/jquery.js',
            'assets/js/main.js',
            'assets/css/styles.css',
            'assets/fonts/tabler-icons.woff2'
        ];
        
        echo "<ul>";
        foreach ($files_to_check as $file) {
            if (file_exists($file)) {
                echo "<li style='color: green;'>✓ $file exists</li>";
            } else {
                echo "<li style='color: red;'>✗ $file missing</li>";
            }
        }
        echo "</ul>";
        ?>
    </div>

    <div class="box">
        <h2>Next Steps</h2>
        <ol>
            <li>If all tests above are green, the problem is in your main site files</li>
            <li>Check browser console (F12) for JavaScript errors</li>
            <li>Check Network tab for failed requests (red items)</li>
            <li>Try accessing: <a href="debug_page.php">debug_page.php</a></li>
            <li>Try accessing: <a href="index.php">index.php</a></li>
        </ol>
    </div>

    <div class="box">
        <h2>Browser Console Check</h2>
        <p>Open browser console (F12) and you should see this message:</p>
        <script>
            console.log('%c✓ Console is working!', 'color: green; font-size: 16px; font-weight: bold;');
            console.log('If you see this message, JavaScript console is working.');
        </script>
        <p><em>Press F12 and check the Console tab</em></p>
    </div>

</body>
</html>
