
<?php 
// Set canonical URL for SEO
$canonicalUrl = SITE_URL . '/store/' . $itemDetails['store_slug'];
require './sections/header.php'; 
?>

<!-- BreadcrumbList Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo SITE_URL; ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Stores",
      "item": "<?php echo SITE_URL; ?>/stores"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "<?php echo echoOutput($itemDetails['store_title']); ?>",
      "item": "<?php echo SITE_URL . '/store/' . $itemDetails['store_slug']; ?>"
    }
  ]
}
</script>

<!-- Store Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Store",
  "name": "<?php echo echoOutput($itemDetails['store_title']); ?>",
  "image": "<?php echo $urlPath->image($itemDetails['store_image']); ?>",
  "description": "<?php echo echoOutput($itemDetails['store_description']); ?>",
  <?php if(!empty($itemDetails['rating']) && $itemDetails['total_reviews'] > 0): ?>
  "aggregateRating": {
    "@type": "AggregateRating",
    "ratingValue": "<?php echo number_format($itemDetails['rating'], 1); ?>",
    "reviewCount": "<?php echo $itemDetails['total_reviews']; ?>",
    "bestRating": "5",
    "worstRating": "1"
  },
  <?php endif; ?>
  "url": "<?php echo SITE_URL . '/store/' . $itemDetails['store_slug']; ?>"
}
</script>

<?php if (count($storeCampaigns) > 0): ?>
<div class="uk-container uk-margin-medium-top">
    <div class="uk-grid uk-grid-small uk-child-width-1-2@s uk-child-width-1-3@m" uk-grid>
        <?php foreach ($storeCampaigns as $campaign): ?>
        <div>
            <a href="<?php echo $campaign['campaign_link'] ? htmlspecialchars($campaign['campaign_link']) : '#'; ?>" 
               class="campaign-card"
               <?php if ($campaign['campaign_link']): ?>target="_blank" rel="noopener"<?php endif; ?>>
                <div class="uk-card uk-card-default uk-card-hover">
                    <div class="uk-card-media-top">
                        <img src="<?php echo getImageUrl($campaign['campaign_image_cdn_url'], $campaign['campaign_use_cdn'], $campaign['campaign_image']); ?>" 
                             alt="<?php echo htmlspecialchars($campaign['campaign_title']); ?>">
                    </div>
                </div>
            </a>
        </div>
        <?php endforeach; ?>
    </div>
</div>
<?php endif; ?>

<div class="tas_singlecategory uk-container uk-margin-medium-top">

<div uk-grid>

    <div class="uk-width-1-1 uk-width-1-4@m">

    <!-- Store Info Card -->
    <div class="uk-card uk-card-default uk-card-body uk-border-rounded store-info-card">
        <!-- Logo centered at top -->
        <div class="uk-text-center uk-margin-bottom">
            <div class="logo-cover uk-border-rounded uk-display-inline-block">
                <img src="<?php echo getImageUrl($itemDetails['store_image_cdn_url'], $itemDetails['store_use_cdn'], $itemDetails['store_image']); ?>" alt="<?php echo echoOutput($itemDetails['store_title']); ?>">
            </div>
        </div>

        <!-- Store name below logo -->
        <h2 class="uk-text-center uk-margin-small-bottom uk-text-bold"><?php echo echoOutput($itemDetails['store_title']); ?></h2>

        <?php if(!empty($itemDetails['store_description'])): ?>
        <p class="uk-text-center uk-margin-small store-description"><?php echo echoOutput($itemDetails['store_description']); ?></p>
        <?php endif; ?>

        <!-- Follow Store Button -->
        <div class="store-header-follow uk-text-center">
            <button class="follow-store-btn" 
                    data-store-id="<?php echo echoOutput($itemDetails['store_id']); ?>"
                    data-store-name="<?php echo echoOutput($itemDetails['store_title']); ?>"
                    title="Get notified of new deals">
                <i class="far fa-bell"></i> Follow
            </button>
        </div>

        <hr class="uk-margin-small">

        <div class="uk-text-center">
            <h3 class="widget-title uk-margin-small-bottom"><?php echo echoOutput($translation['tr_115']); ?></h3>

            <form class="uk-form" method="post" id="formRating">
                <input value="<?php echo echoOutput($itemDetails['store_id']); ?>" name="item" type="text" hidden>
                <select id="rating-form" name="rating" data-current="<?php echo echoOutput(!$itemDetails['rating'] ? 5 : $itemDetails['rating']); ?>">
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                    <option value="5">5</option>
                </select>

                <p class="uk-text-muted uk-text-small uk-margin-small-top"><?php echo echoOutput($itemDetails['total_reviews']); ?> <?php echo echoOutput($translation['tr_117']); ?> · <?php echo echoOutput(number_format($itemDetails['rating'], 1)); ?> <?php echo echoOutput($translation['tr_118']); ?></p>

                <div id="showReviewresults"></div>
            </form>
        </div>
    </div>
        
    </div>

    <div class="uk-width-1-1 uk-width-expand@m">

    <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>
            <div class="uk-width-expand">
                <h3 class="uk-heading-line uk-text-left uk-text-bold"><span><?php echo echoOutput($itemDetails['store_title']); ?> Best Coupons and Offers</span></h3>
            </div>
            <div class="uk-width-auto">
                <a href="<?php echo $urlPath->search(['store' => $itemDetails['store_slug']]); ?>" class="uk-button uk-button-default uk-border-pill uk-flex uk-flex-middle">
                    <?php echo echoOutput($translation['tr_21']); ?> 
                    <i class="ti ti-chevron-right uk-text-primary"></i>
                </a>
            </div>
        </div>

    <?php if(!empty($items)): ?>
                <!-- Coupon Filter Tabs -->
                <div class="coupon-filter-tabs">
                    <button class="coupon-filter-tab active" data-filter="all">
                        All <span class="count">(<?php echo count($items); ?>)</span>
                    </button>
                    <button class="coupon-filter-tab" data-filter="coupon">
                        Coupons <span class="count">(0)</span>
                    </button>
                    <button class="coupon-filter-tab" data-filter="cashback">
                        Cashback <span class="count">(0)</span>
                    </button>
                    <button class="coupon-filter-tab" data-filter="deal">
                        Deals <span class="count">(0)</span>
                    </button>
                </div>

                <div class="uk-grid-medium uk-child-width-1-1" uk-grid>

                <?php foreach($items as $item): 
                    // Determine coupon type
                    $couponType = 'deal'; // default
                    if (!empty($item['coupon_code'])) {
                        $couponType = 'coupon';
                    }
                    // You can add cashback detection logic here if you have a cashback field
                    // For now, we'll use deals without codes as potential cashback
                ?>

<div class="tas_card_5 coupon-item" data-coupon-type="<?php echo $couponType; ?>">
<div class="uk-grid-collapse uk-margin card uk-flex uk-flex-middle" uk-grid>
<div class="left uk-width-auto">

<div class="uk-cover-container">
<?php if($item['store_image']): ?>
<img src="<?php echo getImageUrl($item['store_image_cdn_url'], $item['store_use_cdn'], $item['store_image']); ?>" alt="<?php echo echoOutput($item['coupon_title']); ?>" uk-cover>
<canvas width="60" height="60"></canvas>
<?php endif; ?>
<?php if(!$item['store_image']): ?>
<div class="no-image"><i class="ti ti-percentage"></i></div>
<?php endif; ?>

</div>

</div>
<div class="body uk-width-expand">
<div class="uk-grid-small" uk-grid>

<div class="uk-width-1-1 uk-width-expand@s">
    <?php if(timeLeft(echoOutput($item['coupon_expire']))): ?>
    <p class="tas_time"><i class="ti ti-clock"></i> <span><?php echo timeLeft(echoOutput($item['coupon_expire'])); ?></span></p>
    <?php endif; ?>
    <h3 class="title"><?php echo echoOutput($item['coupon_title']); ?></h3>
<?php if(!empty($item['coupon_tagline'])): ?>
    <p class="tagline"><?php echo echoOutput($item['coupon_tagline']); ?></p>
<?php endif; ?>
</div>
<div class="uk-width-1-1 uk-width-auto@s">
    <a class="uk-width-1-1@s uk-button btn c-open" data-id="<?php echo echoOutput($item['coupon_id']); ?>" data-redirect="<?php echo echoOutput($item['coupon_link']); ?>">
    <?php if(!empty($item['coupon_code'])): ?>
        <i class="fas fa-cut"></i> Show Coupon
    <?php else: ?>
        <i class="fas fa-tag"></i> Get Deal
    <?php endif; ?>
    </a>
</div>

</div>

</div>

<div class="uk-width-1-1 info">

<div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>

<div class="uk-width-expand uk-text-left">
<ul class="uk-subnav" uk-margin>
    <?php if(!empty(echoOutput($item['coupon_expire']))): ?>
    <li><span><?php echo echoOutput($translation['tr_24']); ?> <?php echo formatDate($item['coupon_expire']); ?></span></li>
    <?php endif; ?>
    <?php if(isVerified(echoOutput($item['coupon_verify']))): ?>
    <li><span><div class="verified"><i class="ti ti-check"></i> <?php echo echoOutput($translation['tr_26']); ?></div></span></li>
    <?php endif; ?>
    <?php if(isExclusive(echoOutput($item['coupon_exclusive']))): ?>
    <li><span><div class="exclusive"><i class="ti ti-crown"></i> <?php echo echoOutput($translation['tr_16']); ?></div></span></li>
    <?php endif; ?>
</ul>
</div>

<div class="uk-width-auto uk-text-right">
<button class="details-collapse-btn" onclick="toggleStoreDetails(<?php echo echoOutput($item['coupon_id']); ?>)" id="detailsBtn_<?php echo echoOutput($item['coupon_id']); ?>">
    <?php echo echoOutput($translation['tr_99']); ?> <i class="ti ti-chevron-down" id="detailsArrow_<?php echo echoOutput($item['coupon_id']); ?>"></i>
</button>
</div>

</div>

<div class="uk-width-1-1 details-collapse-section" id="toggle_<?php echo echoOutput($item['coupon_id']); ?>" style="display: none;">
                <p class="details"><?php echo echoOutput($item['coupon_description']); ?></p>
                <hr class="uk-margin-small">
                
                <!-- Like/Dislike Voting Buttons -->
                <div class="likes uk-flex uk-flex-center uk-margin-small">
                    <?php 
                    $isLike = isLike($connect, $item['coupon_id']);
                    if($isLike === false || $isLike == 0): 
                    ?>
                    <div>
                        <a class="like" data-item="<?php echo echoOutput($item['coupon_id']); ?>">
                            <i class="fas fa-thumbs-up"></i> 
                            <span><?php echo echoOutput($item['total_likes']); ?></span>
                        </a>
                    </div>
                    <div>
                        <a class="deslike" data-item="<?php echo echoOutput($item['coupon_id']); ?>">
                            <i class="fas fa-thumbs-down"></i> 
                            <span><?php echo echoOutput($item['total_deslikes']); ?></span>
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="thanks">
                        <?php echo echoOutput($translation['tr_27']); ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

</div>
</div>
</div>

<?php endforeach; ?>

                </div>

                <?php endif; ?>

                <?php if(empty($items)): ?>
                    <div class="uk-width-1-1 uk-flex uk-flex-center uk-text-center uk-margin-large-top">
                    <div class="uk-width-1-1 uk-width-1-2@s">
                    <h4 class="uk-margin-small"><?php echo echoOutput($translation['tr_109']); ?></h4>
                    </div>
                    </div>
                <?php endif; ?>

    </div>
    </div>
    </div>

</div>

<?php
// Display affiliate products for this store
$storeProducts = getProductsByStore($connect, $itemDetails['store_id'], 12);
if (!empty($storeProducts)) {
    require './sections/views/store-products.view.php';
}
?>

<?php require './sections/footer.php'; ?>

<script>
function toggleStoreDetails(couponId) {
    const detailsSection = document.getElementById('toggle_' + couponId);
    const toggleBtn = document.getElementById('detailsBtn_' + couponId);
    const arrow = document.getElementById('detailsArrow_' + couponId);
    
    if (detailsSection.style.display === 'none') {
        detailsSection.style.display = 'block';
        toggleBtn.classList.add('active');
    } else {
        detailsSection.style.display = 'none';
        toggleBtn.classList.remove('active');
    }
}
</script>