<?php

if( !$GLOBALS['me']->is_admin ) die;

switch( $_GET['action'] ) {

/** ADD SLIDE */

case 'add':

echo '<div class="title">

<h2>' . t( 'slider_add_title', "Add New Slide" ) . '</h2>

<div style="float:right; margin: 0 2px 0 0;">
<a href="?route=slider.php&amp;action=list" class="btn">' . t( 'slider_view', "View Slides" ) . '</a>
</div>';

$subtitle = t( 'slider_add_subtitle', "Add a new slide to the homepage slider" );

if( !empty( $subtitle ) ) {
    echo '<span>' . $subtitle . '</span>';
}

echo '</div>';

do_action( array( 'after_title_inner_page', 'after_title_slider_page', 'after_title_add_slider_page' ) );

if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'slider_csrf' ) ) {

    if( isset( $_POST['image_url'] ) && isset( $_POST['link'] ) )
    if( admin\actions::add_slider_slide(
    array(
    'image_url'     => ( isset( $_POST['image_url'] ) ? trim( $_POST['image_url'] ) : '' ),
    'image'         => ( isset( $_FILES['image'] ) ? $_FILES['image'] : array() ),
    'link'          => ( isset( $_POST['link'] ) ? trim( $_POST['link'] ) : '' ),
    'order'         => ( isset( $_POST['order'] ) ? (int) $_POST['order'] : 0 )
    ) ) ) {

    echo '<div class="a-success">' . t( 'msg_added', "Added!" ) . '</div>';

    } else
    echo '<div class="a-error">' . t( 'msg_error', "Error!" ) . '</div>';

}

$csrf = $_SESSION['slider_csrf'] = \site\utils::str_random(10);

echo '<div class="form-table">

<form action="#" method="POST" enctype="multipart/form-data" autocomplete="off">';

echo '<div class="row"><span>' . t( 'slider_image_url', "Image URL" ) . ':</span><div><input type="text" name="image_url" value="" placeholder="https://example.com/image.jpg" /><span class="info"><span>' . t( 'slider_image_url_info', "Paste a full image URL here if you host the image externally. Leave empty if uploading from computer." ) . '</span></span></div></div>';

echo '<div class="row image-upload"><span>' . t( 'slider_image_upload', "Or Upload Image" ) . ':</span><div><input type="file" name="image" accept="image/*" /></div></div>';

echo '<div class="row"><span>' . t( 'slider_link', "Target URL" ) . ':</span><div><input type="text" name="link" value="" placeholder="https://example.com or /coupons" /></div></div>';

echo '<div class="row"><span>' . t( 'slider_order', "Display Order" ) . ':</span><div><input type="number" name="order" value="0" min="0" /><span class="info"><span>' . t( 'slider_order_info', "Lower numbers appear first. Use 0 for default order." ) . '</span></span></div></div>';

echo '<input type="hidden" name="csrf" value="' . $csrf . '" />

<div class="twocols">
    <div>
        <button class="btn btn-important">' . t( 'slider_add_button', "Add Slide" ) . '</button>
    </div>
</div>

</form>

</div>';

break;

/** EDIT SLIDE */

case 'edit':

$csrf = \site\utils::str_random(10);

echo '<div class="title">

<h2>' . t( 'slider_edit_title', "Edit Slide" ) . '</h2>

<div style="float:right; margin: 0 2px 0 0;">';

$slides = admin\actions::get_slider_slides();
$slide_id = isset( $_GET['id'] ) ? (int) $_GET['id'] : 0;

if( isset( $slides[$slide_id] ) ) {

$slide = $slides[$slide_id];

echo '<div class="options">
<a href="#" class="btn">' . t( 'options', "Options" ) . '</a>
<ul>';
echo '<li><a href="?route=slider.php&amp;action=delete&amp;id=' . $slide_id . '&amp;token=' . $csrf . '" data-delete-msg="' . t( 'delete_msg', "Are you sure that you want to delete this?" ) . '">' . t( 'delete', "Delete" ) . '</a></li>';
echo '</ul>
</div>';

}

echo '<a href="?route=slider.php&amp;action=list" class="btn">' . t( 'slider_view', "View Slides" ) . '</a>
</div>';

$subtitle = t( 'slider_edit_subtitle', "Edit slide" );

if( !empty( $subtitle ) ) {
    echo '<span>' . $subtitle . '</span>';
}

echo '</div>';

do_action( array( 'after_title_inner_page', 'after_title_slider_page', 'after_title_edit_slider_page' ) );

if( isset( $slides[$slide_id] ) ) {

$slide = $slides[$slide_id];

if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'slider_csrf' ) ) {

if( isset( $_POST['image_url'] ) && isset( $_POST['link'] ) )
if( admin\actions::edit_slider_slide( $slide_id,
array(
'image_url'     => ( isset( $_POST['image_url'] ) ? trim( $_POST['image_url'] ) : '' ),
'image'         => ( isset( $_FILES['image'] ) ? $_FILES['image'] : array() ),
'link'          => ( isset( $_POST['link'] ) ? trim( $_POST['link'] ) : '' ),
'order'         => ( isset( $_POST['order'] ) ? (int) $_POST['order'] : 0 )
) ) ) {

$slides = admin\actions::get_slider_slides();
$slide = $slides[$slide_id];

echo '<div class="a-success">' . t( 'msg_saved', "Saved!" ) . '</div>';

} else
echo '<div class="a-error">' . t( 'msg_error', "Error!" ) . '</div>';

}

$_SESSION['slider_csrf'] = $csrf;

echo '<div class="form-table">

<form action="?route=slider.php&amp;action=edit&amp;id=' . $slide_id . '" method="POST" enctype="multipart/form-data">';

if( !empty( $slide['image'] ) ) {
    $img_src = ( preg_match( '/^http(s)?/i', $slide['image'] ) ? $slide['image'] : '../' . $slide['image'] );
    echo '<div class="row"><span>' . t( 'slider_current_image', "Current Image" ) . ':</span><div style="display:table;margin-bottom:2px;"><img src="' . $img_src . '" class="avt" alt="" style="display:table-cell;vertical-align:middle;max-width:300px;height:auto;margin:0 20px 5px 0;" /></div></div>';
}

echo '<div class="row"><span>' . t( 'slider_image_url', "Image URL" ) . ':</span><div><input type="text" name="image_url" value="' . ( !empty( $slide['image'] ) && preg_match( '/^http(s)?/i', $slide['image'] ) ? esc_html( $slide['image'] ) : '' ) . '" placeholder="https://example.com/image.jpg" /><span class="info"><span>' . t( 'slider_image_url_info', "Paste a full image URL here if you host the image externally. Leave empty if uploading from computer." ) . '</span></span></div></div>';

echo '<div class="row image-upload"><span>' . t( 'slider_image_upload', "Or Upload New Image" ) . ':</span><div><input type="file" name="image" accept="image/*" /></div></div>';

echo '<div class="row"><span>' . t( 'slider_link', "Target URL" ) . ':</span><div><input type="text" name="link" value="' . ( !empty( $slide['link'] ) ? esc_html( $slide['link'] ) : '' ) . '" placeholder="https://example.com or /coupons" /></div></div>';

echo '<div class="row"><span>' . t( 'slider_order', "Display Order" ) . ':</span><div><input type="number" name="order" value="' . ( isset( $slide['order'] ) ? (int) $slide['order'] : 0 ) . '" min="0" /><span class="info"><span>' . t( 'slider_order_info', "Lower numbers appear first. Use 0 for default order." ) . '</span></span></div></div>';

echo '<input type="hidden" name="csrf" value="' . $csrf . '" />

<div class="twocols">
    <div>
        <button class="btn btn-important">' . t( 'slider_edit_button', "Save Slide" ) . '</button>
    </div>
</div>

</form>

</div>';

} else echo '<div class="a-error">Invalid slide ID.</div>';

break;

/** DELETE SLIDE */

case 'delete':

if( isset( $_GET['id'] ) && isset( $_GET['token'] ) && check_csrf( $_GET['token'], 'slider_csrf' ) ) {

    if( admin\actions::delete_slider_slide( (int) $_GET['id'] ) )
    echo '<div class="a-success">' . t( 'msg_deleted', "Deleted!" ) . '</div>';
    else
    echo '<div class="a-error">' . t( 'msg_error', "Error!" ) . '</div>';

}

header( 'Location: ?route=slider.php&amp;action=list' );
die;

break;

/** LIST OF SLIDES */

default:

echo '<div class="title">

<h2>' . t( 'slider_title', "Homepage Slider" ) . '</h2>

<div style="float:right; margin: 0 2px 0 0;">';
echo '<a href="?route=slider.php&amp;action=add" class="btn">' . t( 'slider_add', "Add Slide" ) . '</a>';
echo '</div>';

$subtitle = t( 'slider_subtitle', "Manage homepage slider slides" );

if( !empty( $subtitle ) ) {
    echo '<span>' . $subtitle . '</span>';
}

echo '</div>';

do_action( array( 'after_title_inner_page', 'after_title_slider_page', 'after_title_slider_list_page' ) );

if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'slider_csrf' ) ) {

    if( isset( $_POST['delete'] ) && isset( $_POST['id'] ) ) {

        $deleted = 0;
        foreach( array_keys( $_POST['id'] ) as $id ) {
            if( admin\actions::delete_slider_slide( (int) $id ) ) {
                $deleted++;
            }
        }
        
        if( $deleted > 0 )
        echo '<div class="a-success">' . sprintf( t( 'msg_deleted_count', "%s deleted!" ), $deleted ) . '</div>';
        else
        echo '<div class="a-error">' . t( 'msg_error', "Error!" ) . '</div>';

    }

} else if( isset( $_GET['action'] ) && isset( $_GET['token'] ) && check_csrf( $_GET['token'], 'slider_csrf' ) ) {

    if( $_GET['action'] == 'delete' ) {

        if( isset( $_GET['id'] ) )
        if( admin\actions::delete_slider_slide( (int) $_GET['id'] ) )
        echo '<div class="a-success">' . t( 'msg_deleted', "Deleted!" ) . '</div>';
        else
        echo '<div class="a-error">' . t( 'msg_error', "Error!" ) . '</div>';

    }

}

$csrf = $_SESSION['slider_csrf'] = \site\utils::str_random(10);

$slides = admin\actions::get_slider_slides();

if( !empty( $slides ) ) {

echo '<form action="?route=slider.php&amp;action=list" method="POST">

<ul class="elements-list">

<li class="head"><input type="checkbox" id="selectall" data-checkall /> <label for="selectall"><span></span> ' . t( 'slider_image', "Image" ) . '</label></li>';

echo '<div class="bulk_options">
    <button class="btn" name="delete" data-delete-msg="' . t( 'delete_msg', "Are you sure that you want to delete this?" ) . '">' . t( 'delete_all', "Delete All" ) . '</button>
</div>';

// Sort by order
uasort( $slides, function( $a, $b ) {
    $order_a = isset( $a['order'] ) ? (int) $a['order'] : 999;
    $order_b = isset( $b['order'] ) ? (int) $b['order'] : 999;
    if( $order_a === $order_b ) return 0;
    return ( $order_a < $order_b ? -1 : 1 );
} );

foreach( $slides as $id => $slide ) {

    $img_src = ( !empty( $slide['image'] ) ? ( preg_match( '/^http(s)?/i', $slide['image'] ) ? $slide['image'] : '../' . $slide['image'] ) : '' );
    $link = !empty( $slide['link'] ) ? esc_html( $slide['link'] ) : '-';
    $order = isset( $slide['order'] ) ? (int) $slide['order'] : 0;

    echo '<li>
    <input type="checkbox" name="id[' . $id . ']" id="slide_' . $id . '" value="1" />
    <label for="slide_' . $id . '"><span></span>
    <div style="display:inline-block;vertical-align:middle;width:200px;margin-right:20px;">';
    if( !empty( $img_src ) ) {
        echo '<img src="' . $img_src . '" alt="" style="max-width:200px;max-height:100px;object-fit:contain;" />';
    } else {
        echo '<span style="color:#999;">' . t( 'no_image', "No image" ) . '</span>';
    }
    echo '</div>
    <div style="display:inline-block;vertical-align:middle;">
    <strong>' . t( 'slider_link', "Link" ) . ':</strong> ' . $link . '<br />
    <strong>' . t( 'slider_order', "Order" ) . ':</strong> ' . $order . '
    </div>
    </label>
    <div class="options">
    <a href="#" class="btn">' . t( 'options', "Options" ) . '</a>
    <ul>
    <li><a href="?route=slider.php&amp;action=edit&amp;id=' . $id . '">' . t( 'edit', "Edit" ) . '</a></li>
    <li><a href="' . \site\utils::update_uri( '', array( 'action' => 'delete', 'id' => $id, 'token' => $csrf ) ) . '" data-delete-msg="' . t( 'delete_msg', "Are you sure that you want to delete this?" ) . '">' . t( 'delete', "Delete" ) . '</a></li>
    </ul>
    </div>
    </li>';

}

echo '</ul>

<input type="hidden" name="csrf" value="' . $csrf . '" />

</form>';

} else echo '<div class="a-alert">' . t( 'slider_no_slides', "No slides yet." ) . '</div>';

break;

}

