(function() {
    "use strict";
    
    // Wait for jQuery to be available
    function initAjax() {
        if (typeof jQuery === 'undefined') {
            setTimeout(initAjax, 50);
            return;
        }
        
        var $ = jQuery;
        
        $( document ).ready(function() {

    $(document).on( 'click', '[data-ajax-call]:not(.disabled)', function(e) {
        e.preventDefault();
        var t = $(this);
        var url = t.data( 'ajax-call' ),
        data = t.data( 'data' );

        if( t.data( 'confirmation' ) == undefined || confirm( t.data( 'confirmation' ) ) ) {
            $.post( url, data, function( result ) {
                if( t.data( 'after-ajax' ) != undefined ) {
                    switch( t.data( 'after-ajax' ) ) {
                        case 'ajax_voted':
                            if( result.state != 'success' ) {
                                // alert( result.message );
                                window.location = login_page;
                            } else {
                                var votes_form = t.parents( '.vote-form' );
                                votes_form.after( '<li><span class="ajax-message"><strong>' + t.data( 'message' ) + '</strong></span></li>' );
                                votes_form.remove();
                                $('.tooltip').remove();
                            }
                        break;
                        case 'coupon_claimed':
                            if( result.state == 'success' ) {
                                t.addClass( 'disabled' );
                                t.html( result.message );
                            } else {
                                // alert( result.message );
                                window.location = login_page;
                            }
                        break;
                    }
                } else {
                    if( result.state != 'success' ) {
                        // alert( result.message );
                        window.location = login_page;
                    } else {
                        // Handle store follow button specially (floating, icon, and notification bell versions)
                        if( t.hasClass( 'store-follow-btn-floating' ) || t.hasClass( 'store-follow-btn-icon' ) || t.hasClass( 'store-notification-bell' ) ) {
                            // Update icon and data attribute
                            var iconClass = 'fas fa-bell' + ( result.followed ? '' : '-slash' );
                            t.find('i').attr('class', iconClass);
                            t.attr('data-followed', result.followed ? '1' : '0');
                            if( result.button_title ) {
                                t.attr('title', result.button_title );
                            }
                            // Show notification message
                            if( result.message ) {
                                // You can add a toast notification here if needed
                                console.log(result.message);
                            }
                        } else {
                            t.html( result.message );
                        }
                    }
                }
            }, "json" );
        }
    });

        });
    }
    
    // Start initialization
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initAjax);
    } else {
        initAjax();
    }
})();