<?php

// HERO SECTION – headline + small subtext (search is still in header)
?>
<div class="home-hero bgGray pt-75 pb-50 clearfix">
    <div class="container text-center">
        <h1 class="home-hero-title"><?php te( 'theme_home_hero_title', "Shop Today's Trending Coupons & Save Big" ); ?></h1>
        <p class="home-hero-subtitle"><?php te( 'theme_home_hero_sub', 'Discover exclusive offers from top brands and save on every order.' ); ?></p>
    </div>
</div>

<?php
// CAMPAIGN BANNERS - After Slider
echo render_campaign_banners( 'after_slider' );

// DEAL OF THE DAY - Featured Deal Section
$deal_of_day = items_custom( [ 'show' => 'active,popular', 'orderby' => 'rand', 'max' => 1 ] );
if( !empty( $deal_of_day ) ) {
    $deal_item = current( $deal_of_day );
    ?>
    <div class="deal-of-day-section bgWhite pt-75 pb-75 clearfix">
        <div class="container">
            <div class="deal-of-day-header text-center mb-40">
                <span class="deal-badge"><?php te( 'theme_deal_of_day', 'Deal of the Day' ); ?></span>
                <h2 class="deal-title"><?php te( 'theme_dont_miss', "Don't Miss This Exclusive Deal!" ); ?></h2>
            </div>
            <div class="deal-of-day-content">
                <div class="list clearfix">
                    <?php echo couponscms_coupon_item( $deal_item ); ?>
                </div>
            </div>
        </div>
    </div>
    <?php
}

// TOP STORES STRIP – row of popular store logos
?>
<div class="bgGray pb-50 clearfix">
    <div class="container">
        <div class="section-header home-top-stores-header">
            <h2 class="mb-0"><?php te( 'theme_home_top_stores', 'Featured Stores' ); ?></h2>
            <a href="<?php echo tlink( 'stores' ); ?>" class="view-all-link button"><?php te( 'theme_view_all', 'View All' ); ?></a>
        </div>
        <div class="home-top-stores mt-25">
            <?php foreach( stores_custom( [ 'show' => 'popular', 'orderby' => 'rand', 'max' => 8 ] ) as $store ) { ?>
                <a href="<?php echo $store->link; ?>" class="home-top-store">
                    <img src="<?php echo store_avatar( $store->image ); ?>" alt="<?php echo ts( $store->name ); ?>" />
                    <span><?php echo ts( $store->name ); ?></span>
                </a>
            <?php } ?>
        </div>
    </div>
</div>

<?php
// EXCLUSIVE COUPONS
?>
<div class="bgWhite pt-75 pb-75 clearfix">
    <div class="container">
        <div class="section-header clearfix">
            <h2 class="float-left mb-0"><?php te( 'theme_home_exclusive_coupons', 'Exclusive Coupons' ); ?></h2>
            <a href="<?php echo tlink( 'tpage/coupons', 'type=exclusive' ); ?>" class="view-all-link button float-right"><?php te( 'theme_view_all', 'View All' ); ?></a>
        </div>
        <div class="list mt-40 clearfix">
            <?php foreach( items_custom( [ 'show' => 'exclusive,active', 'orderby' => 'rand', 'max' => 12 ] ) as $item ) {
                echo couponscms_coupon_item( $item );
            } ?>
        </div>
    </div>
</div>

<?php
// FEATURED / POPULAR COUPONS
?>
<div class="bgGray pt-75 pb-75 clearfix">
    <div class="container">
        <div class="section-header clearfix">
            <h2 class="float-left mb-0"><?php te( 'theme_home_popular_coupons', 'Featured Coupons' ); ?></h2>
            <a href="<?php echo tlink( 'tpage/coupons', 'type=popular' ); ?>" class="view-all-link button float-right"><?php te( 'theme_view_all', 'View All' ); ?></a>
        </div>
        <div class="list mt-40 clearfix">
            <?php foreach( items_custom( [ 'show' => 'popular,active', 'orderby' => 'rand', 'max' => 18 ] ) as $item ) {
                echo couponscms_coupon_item( $item );
            } ?>
        </div>
    </div>
</div>

<?php
// CAMPAIGN BANNERS - Before Featured Stores
echo render_campaign_banners( 'before_featured_stores' );

// FEATURED STORES – random popular stores grid with coupons count
?>
<div class="bgWhite pt-75 pb-75 clearfix">
    <div class="container">
        <div class="section-header clearfix">
            <h2 class="float-left mb-0"><?php te( 'theme_home_popular_stores', 'Featured Stores' ); ?></h2>
            <a href="<?php echo tlink( 'stores', 'type=top' ); ?>" class="view-all-link button float-right"><?php te( 'theme_view_all', 'View All' ); ?></a>
        </div>
        <div class="list2 mt-50 clearfix">
            <?php foreach( stores_custom( [ 'show' => 'popular', 'orderby' => 'rand', 'max' => 18 ] ) as $store ) {
                echo couponscms_store_item( $store );
            } ?>
        </div>
    </div>
</div>

<?php
// RECENTLY VIEWED COUPONS
?>
<div class="bgWhite pt-75 pb-75 clearfix" id="recently-viewed-section" style="display: none;">
    <div class="container">
        <div class="section-header clearfix">
            <h2 class="float-left mb-0"><?php te( 'theme_recently_viewed', 'Recently Viewed Coupons' ); ?></h2>
            <a href="#" class="view-all-link button float-right" id="clear-recently-viewed"><?php te( 'theme_clear', 'Clear' ); ?></a>
        </div>
        <div class="list mt-40 clearfix" id="recently-viewed-list">
            <!-- Populated by JavaScript -->
        </div>
    </div>
</div>

<script>
(function() {
    function loadRecentlyViewed() {
        try {
            var viewed = JSON.parse( localStorage.getItem( 'recently_viewed_coupons' ) || '[]' );
            if( viewed.length === 0 ) {
                document.getElementById( 'recently-viewed-section' ).style.display = 'none';
                return;
            }
            
            var container = document.getElementById( 'recently-viewed-list' );
            var html = '';
            
            viewed.forEach( function( coupon ) {
                html += '<div class="item recently-viewed-item">';
                html += '<div class="item-content">';
                html += '<div class="image"><img src="' + ( coupon.image || '' ) + '" alt="' + ( coupon.store || '' ) + '" class="store-logo" /></div>';
                html += '<div class="store-header"><div class="store-meta"><span>Store</span><span class="store-name">' + ( coupon.store || '' ) + '</span></div></div>';
                html += '<div class="content">';
                html += '<div class="title"><h4><a href="' + coupon.url + '">' + coupon.title + '</a></h4></div>';
                html += '<a href="' + coupon.url + '" class="button">' + ( '<?php echo t( "theme_get_deal", "Get Deal" ); ?>' || 'Get Deal' ) + '</a>';
                html += '</div></div></div>';
            } );
            
            container.innerHTML = html;
            document.getElementById( 'recently-viewed-section' ).style.display = 'block';
        } catch( e ) {
            console.error( 'Error loading recently viewed:', e );
        }
    }
    
    document.getElementById( 'clear-recently-viewed' ).addEventListener( 'click', function( e ) {
        e.preventDefault();
        localStorage.removeItem( 'recently_viewed_coupons' );
        document.getElementById( 'recently-viewed-section' ).style.display = 'none';
    } );
    
    loadRecentlyViewed();
})();
</script>

<?php
// FEATURED CATEGORIES – grid before footer
?>
<div class="bgGray pt-75 pb-75 clearfix">
    <div class="container">
        <div class="section-header clearfix">
            <h2 class="float-left mb-0"><?php te( 'theme_home_categories', 'Featured Categories' ); ?></h2>
            <a href="<?php echo tlink( 'tpage/coupons' ); ?>" class="view-all-link button float-right"><?php te( 'theme_view_all', 'View All' ); ?></a>
        </div>
        <div class="list3 home-categories-grid mt-50 clearfix">
            <?php foreach( categories_custom( [ 'show' => 'cats', 'orderby' => 'rand', 'max' => 10 ] ) as $cat ) { ?>
                <div class="item">
                    <div class="icon">
                        <?php echo couponscms_category_icon( $cat ); ?>
                    </div>
                    <div class="bottom clearfix">
                        <div class="title">
                            <a href="<?php echo $cat->link; ?>"><?php echo $cat->name; ?></a>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
