<?php
// Footer mega-categories section (parent categories + subcategories)
$footer_categories = all_grouped_categories();
if( !empty( $footer_categories ) ) { ?>
<div class="footer-categories bgWhite pt-50 pb-25">
    <div class="container">
        <div class="row">
            <?php foreach( $footer_categories as $cat ) { ?>
                <div class="col-6 col-md-3 footer-cat-group">
                    <h6><a href="<?php echo $cat['info']->link; ?>"><?php echo ts( $cat['info']->name ); ?></a></h6>
                    <?php if( !empty( $cat['subcats'] ) ) { ?>
                        <ul>
                            <?php foreach( $cat['subcats'] as $subcat ) { ?>
                                <li><a href="<?php echo $subcat->link; ?>"><?php echo ts( $subcat->name ); ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php } ?>

<?php
// Follow us section above footer, centered
$networks_follow = social_networds();
if( !empty( $networks_follow ) ) { ?>
<div class="follow-us bgWhite pt-30 pb-30">
    <div class="container text-center">
        <h6 class="follow-us-title"><?php te( 'theme_follow_us', 'Follow Us' ); ?></h6>
        <ul class="follow-us-links">
            <?php
            if( isset( $networks_follow['myspace'] ) ) unset( $networks_follow['myspace'] );
            foreach( $networks_follow as $name => $url ) { ?>
                <li>
                    <a href="<?php echo esc_html( $url ); ?>" class="follow-icon follow-<?php echo esc_attr( $name ); ?>" target="_blank" rel="nofollow">
                        <i class="fab fa-<?php echo $name; ?>"></i>
                    </a>
                </li>
            <?php } ?>
        </ul>
    </div>
</div>
<?php } ?>

<!-- Floating promo notification bar -->
<div class="footer-promo-bar" id="footer-promo-bar">
    <div class="footer-promo-inner">
        <div class="footer-promo-content">
            <div class="footer-promo-deal">
                <span class="footer-promo-text">
                    🎉 <strong>BLACK FRIDAY DEAL</strong> Up to <strong>80% OFF</strong> + extra <strong>8% with code BLACKFRIDAY</strong> 🔥
                </span>
            </div>
            <div class="footer-promo-timer">
                <span class="timer-label">Ends in:</span>
                <span class="timer-display" id="promo-timer">
                    <span class="timer-value" id="timer-hours">00</span><span class="timer-label-small">H</span>
                    <span class="timer-separator"> : </span>
                    <span class="timer-value" id="timer-minutes">00</span><span class="timer-label-small">M</span>
                    <span class="timer-separator"> : </span>
                    <span class="timer-value" id="timer-seconds">00</span><span class="timer-label-small">S</span>
                </span>
            </div>
        </div>
        <div class="footer-promo-actions">
            <a class="footer-promo-cta" href="<?php echo tlink( 'tpage/coupons' ); ?>"><?php te( 'claim_deal', 'Claim Deal' ); ?></a>
            <button type="button" class="footer-promo-close" aria-label="<?php te( 'close', 'Close' ); ?>">×</button>
        </div>
    </div>
</div>

<script>
(function() {
    // Check if bar was dismissed
    if (localStorage.getItem('footerPromoDismissed') === 'true') {
        document.getElementById('footer-promo-bar').style.display = 'none';
        return;
    }

    // Close button functionality
    var closeBtn = document.querySelector('.footer-promo-close');
    var promoBar = document.getElementById('footer-promo-bar');
    
    if (closeBtn && promoBar) {
        closeBtn.addEventListener('click', function() {
            promoBar.style.transform = 'translateY(100%)';
            promoBar.style.opacity = '0';
            setTimeout(function() {
                promoBar.style.display = 'none';
                localStorage.setItem('footerPromoDismissed', 'true');
            }, 300);
        });
    }

    // Countdown timer - Set end date (24 hours from now, adjust as needed)
    var endDate = new Date().getTime() + (24 * 60 * 60 * 1000); // 24 hours
    
    function updateTimer() {
        var now = new Date().getTime();
        var distance = endDate - now;

        if (distance < 0) {
            // Timer expired
            document.getElementById('timer-hours').textContent = '00';
            document.getElementById('timer-minutes').textContent = '00';
            document.getElementById('timer-seconds').textContent = '00';
            return;
        }

        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        document.getElementById('timer-hours').textContent = String(hours).padStart(2, '0');
        document.getElementById('timer-minutes').textContent = String(minutes).padStart(2, '0');
        document.getElementById('timer-seconds').textContent = String(seconds).padStart(2, '0');
    }

    // Update timer immediately and then every second
    updateTimer();
    setInterval(updateTimer, 1000);
})();
</script>

<footer>
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-3 text-center text-md-left m-mb-30">
                <a href="<?php echo tlink( 'index' ); ?>"><img src="<?php echo site_logo( THEME_LOCATION . '/assets/img/logo.png' ); ?>" class="w50" alt="" /></a>
                <?php $site_desc = description();
                if( !empty( $site_desc ) ) {
                    echo '<p class="footer-site-desc mt-10">' . $site_desc . '</p>';
                } ?>
            </div>
            <div class="col-6 col-md-2 text-center text-md-left">
                <h6><?php te( 'theme_company', 'Company' ); ?></h6>
                <ul>
                    <?php echo couponscms_menu( 'footer_company' ); ?>
                </ul>
            </div>
            <div class="col-6 col-md-2 text-center text-md-left">
                <h6><?php te( 'stores', 'Stores' ); ?></h6>
                <ul class="flinks">
                    <li><a href="<?php echo tlink( 'stores' ); ?>"><?php te( 'theme_all_stores', 'All Stores' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'stores', 'type=top' ); ?>"><?php te( 'theme_top_stores', 'Top Stores' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'stores', 'type=most-voted' ); ?>"><?php te( 'theme_most_voted', 'Most Voted' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'tpage/suggest' ); ?>"><?php te( 'theme_make_a_suggestion', 'Make A Suggestion' ); ?></a></li>
                </ul>
            </div>
            <div class="col-6 col-md-2 text-center text-md-left m-mt-30">
                <h6><?php te( 'coupons', 'Coupons' ); ?></h6>
                <ul class="flinks">
                    <li><a href="<?php echo tlink( 'tpage/coupons', 'type=recent' ); ?>"><?php te( 'theme_coupons_recently_added', 'Recently Added' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'tpage/coupons', 'type=expiring_soon' ); ?>"><?php te( 'theme_coupons_expiring_soon', 'Expiring Soon' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'tpage/coupons', 'type=printable' ); ?>"><?php te( 'theme_coupons_printable', 'Printable' ); ?></a></li>
                    <li><a href="<?php echo tlink( 'tpage/coupons', 'type=codes' ); ?>"><?php te( 'theme_coupons_codes', 'Coupon Codes' ); ?></a></li>
                </ul>
            </div>
            <div class="col-12 col-md-3 text-center text-md-left m-mt-30">
                <?php
                // Footer "Social" section heading and icons
                $networks = social_networds();
                $follow_icons = ['facebook', 'twitter', 'instagram'];
                if( isset( $networks['myspace'] ) ) unset( $networks['myspace'] );
                $has_follow = false;
                foreach( $follow_icons as $icon_name ) {
                    if( !empty( $networks[$icon_name] ) ) { $has_follow = true; break; }
                }
                if( $has_follow ) { ?>
                    <h6><?php te( 'theme_social', 'Social' ); ?></h6>
                    <div class="footer-follow">
                        <ul class="footer-follow-icons">
                            <?php foreach( $follow_icons as $icon_name ) {
                                if( empty( $networks[$icon_name] ) ) continue;
                                $url = esc_html( $networks[$icon_name] ); ?>
                                <li>
                                    <a href="<?php echo $url; ?>" class="footer-follow-icon footer-follow-<?php echo esc_attr( $icon_name ); ?>" target="_blank" rel="nofollow">
                                        <i class="fab fa-<?php echo $icon_name; ?>"></i>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                <?php } ?>

                <h6 class="mt-20"><?php te( 'newsletter', 'Newsletter' ); ?></h6>
                <p class="footer-newsletter-text"><?php te( 'theme_footer_newsletter', 'Get the latest coupons and deals directly in your inbox.' ); ?></p>
                <div class="footer-newsletter-form">
                    <?php echo newsletter_form( '_footer_form', 'footer_newsletter' ); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="footer text-center text-md-left bgGray">
        <div class="container">
            <div class="footer-dmca-badge">
                <a href="//www.dmca.com/Protection/Status.aspx?ID=1901296e-c7de-4c4f-bcc0-60d255233cb1" title="DMCA.com Protection Status" class="dmca-badge">
                    <img src="https://images.dmca.com/Badges/dmca-badge-w150-5x1-06.png?ID=1901296e-c7de-4c4f-bcc0-60d255233cb1" alt="DMCA.com Protection Status" />
                </a>
                <script src="https://images.dmca.com/Badges/DMCABadgeHelper.min.js"></script>
            </div>
            <span class="copyright">
              © <?php echo date("Y"); ?> <a href="https://www.alonedeals.com">Alonedeals.com</a>. All Rights Reserved.

            </span>
        </div>
    </div>
</footer>

<!-- Cookie consent -->
<div id="cookie-consent" class="cookie-consent">
    <div class="container">
        <p><?php te( 'theme_cookie_text', 'We use cookies to improve your experience, analyze traffic, and track affiliate links.
By clicking "Accept", you consent to our use of cookies.' ); ?> <a href="https://alonedeals.com/privacy_policy-3" target="_blank" style="color: #fff; text-decoration: underline;"><?php te( 'theme_privacy_policy', 'Privacy Policy' ); ?></a></p>
        <button type="button" id="cookie-consent-accept" class="button small"><?php te( 'theme_cookie_accept', 'Accept' ); ?></button>
    </div>
</div>

<!-- Scroll to Top Button -->
<button id="scroll-to-top" aria-label="Scroll to top">
    <i class="fas fa-arrow-up"></i>
</button>

<script>
    var login_page = "<?php echo tlink( 'tpage/login' ); ?>";
</script>

<script>
// Footer promo bar close + persistence
(function() {
    var bar = document.getElementById('footer-promo-bar');
    var storageKey = 'footerPromoDismissed';
    if (!bar) return;

    try {
        if (localStorage.getItem(storageKey) === '1') {
            bar.style.display = 'none';
            return;
        }
    } catch (e) {}

    var close = bar.querySelector('.footer-promo-close');
    if (close) {
        close.addEventListener('click', function() {
            bar.style.display = 'none';
            try { localStorage.setItem(storageKey, '1'); } catch (e) {}
        });
    }
})();
</script>

<?php if( couponscms_has_local_stores() && google_maps() && ( this_is_store() || this_is_coupon() || this_is_product() ) ) { ?>
<script src="//maps.googleapis.com/maps/api/js?key=<?php echo esc_html( option( 'google_maps_key' ) ); ?>"></script>
<script src="<?php echo THEME_LOCATION; ?>/assets/js/map.js"></script>

<?php
// OneSignal Push Notifications
$onesignal_app_id = \query\main::get_option( 'dac6a619-03f0-47bc-bc0d-bcff5063740b' );
if( !empty( $onesignal_app_id ) ) {
?>
<script>
window.OneSignalDeferred = window.OneSignalDeferred || [];
OneSignalDeferred.push(function(OneSignal) {
    OneSignal.init({
        appId: "dac6a619-03f0-47bc-bc0d-bcff5063740b",
        notifyButton: {
            enable: true,
            size: "medium",
            position: "bottom-left",
            prenotify: true,
            showCredit: false,
            text: {
                "tip.state.unsubscribed": "Subscribe to notifications",
                "tip.state.subscribed": "You're subscribed to notifications",
                "tip.state.blocked": "You've blocked notifications",
                "message.prenotify": "Click to subscribe to notifications",
                "message.action.subscribed": "Thanks for subscribing!",
                "message.action.resubscribed": "You're subscribed to notifications",
                "message.action.unsubscribed": "You won't receive notifications again",
                "dialog.main.title": "Manage Site Notifications",
                "dialog.main.button.subscribe": "SUBSCRIBE",
                "dialog.main.button.unsubscribe": "UNSUBSCRIBE",
                "dialog.blocked.title": "Unblock Notifications",
                "dialog.blocked.message": "Follow these instructions to allow notifications:"
            },
            colors: {
                "circle.background": "#ed174f",
                "circle.foreground": "#ffffff",
                "badge.background": "#ed174f",
                "badge.foreground": "#ffffff",
                "badge.bordercolor": "#ed174f",
                "pulse.color": "#ed174f",
                "dialog.button.background": "#ed174f",
                "dialog.button.foreground": "#ffffff"
            }
        },
        allowLocalhostAsSecureOrigin: true,
    });
    
    // Move OneSignal bell to custom container on left side
    OneSignal.on('notificationPermissionChanged', function(permission) {
        setTimeout(function() {
            var onesignalBell = document.querySelector('#onesignal-bell-container');
            var onesignalButton = document.querySelector('#onesignal-bell');
            if (onesignalButton && onesignalBell) {
                onesignalBell.appendChild(onesignalButton);
            }
        }, 500);
    });
    
    // Also try to move it after initialization
    setTimeout(function() {
        var onesignalBell = document.querySelector('#onesignal-bell-container');
        var onesignalButton = document.querySelector('#onesignal-bell');
        if (onesignalButton && onesignalBell && !onesignalBell.contains(onesignalButton)) {
            onesignalBell.appendChild(onesignalButton);
        }
    }, 1000);
});
</script>
<?php
}
?>
<?php } ?>

</body>

</html>