<?php

if( !$GLOBALS['me']->is_admin ) die;

switch( $_GET['action'] ) {

/** ASSIGN A ADMITAD ID TO A STORE */

case 'store_assign':

echo '<div class="title">
<h2>Assign ID</h2>
<div style="float:right;margin:0 2px 0 0;">

<div class="options">
<a href="#" class="btn">Show</a>
<ul>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=programs">Programs</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Coupons</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
    <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
</ul>
</div>

</div>

<span>Assign a Admitad ID to an existing store</span>

</div>';

if( !empty( $_GET['id'] ) ) {

$imported = \plugin\AdmitadApiPro\inc\import::store_imported();

if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'adad_plugin_csrf' ) ) {

    if( isset( $_POST['store'] ) )
    if( \plugin\AdmitadApiPro\inc\actions::assign( array( 'adadID' => ( (int) $_POST['store'] === 0 ? 0 : $_GET['id'] ), 'storeID' => ( (int) $_POST['store'] === 0 && $imported ? $imported->ID : $_POST['store'] ) ) ) ) {
    echo '<div class="a-success">Saved!</div>';
    $imported = (object) array( 'ID' => ( !empty( $_POST['store'] ) ? (int) $_POST['store'] : '' ) );
    } else
    echo '<div class="a-error">Error!</div>';

}

$csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

echo '<div class="form-table">

<form action="#" method="POST" autocomplete="off">';

if( isset( $imported->ID ) ) $storeID = $imported->ID;
else {
    $storeID = ( isset( $_POST['store'] ) ? (int) $_POST['store'] : '' );
}
echo '<div class="row"><span>Store ID:</span><div data-search="store"><input type="text" name="store" value="' . $storeID . '" /><a href="#" class="downarr"></a>';
if( empty( $storeID ) || !\query\main::store_exists( $storeID ) ) {
    echo '<span class="idinfo"></span>';
} else {
    $store_info = \query\main::store_info( $storeID );
    echo '<span class="idinfo">' . $store_info->name . ' (ID: ' . $store_info->ID . ')</span>';
}
echo '</div></div>';

echo '<div class="row"><span>To Admitad ID:</span><div><input type="text" name="adadid" value="' . (int) $_GET['id'] . '" disabled /></div></div>

<input type="hidden" name="csrf" value="' . $csrf . '" />

<div class="twocols">
    <div>
        <button class="btn btn-important">Save</button>
    </div>
    <div></div>
</div>

</form>

</div>';

} else echo '<div class="a-error">ID not set.</div>';

break;


/** PREVIEW COUPON */

case 'coupon_preview':

echo '<div class="title">

<h2>Preview & Import</h2>
<div style="float:right;margin:0 2px 0 0;">

<div class="options">
    <a href="#" class="btn">Options</a>
    <ul>
        <li><a href="#" class="more_fields">More</a></li>
    </ul>
</div>

<div class="options">
    <a href="#" class="btn">Show</a>
    <ul>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=programs">Programs</a></li>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Coupons</a></li>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
        <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
    </ul>
</div>

</div>

<span>Here you can edit the details of this coupon before the import</span>

</div>';

if( isset( $_GET['coupon'] ) ) {

    $coupon = json_decode( urldecode( $_GET['coupon'] ), true );

    $id = key( $coupon );

    $coupon = array_map( 'htmlspecialchars', current( $coupon ) );

}

if( !isset( $id ) ) {

    echo '<div class="a-error">Error !</div>';

} else if( !isset( $coupon['Advertiser'] ) || !( $store = \plugin\AdmitadApiPro\inc\import::store_imported( $coupon['Advertiser'] ) ) ) {

    echo '<div class="a-error">Sorry, this store is not imported.</div>';

} else if( \plugin\AdmitadApiPro\inc\import::coupon_imported( $id ) ) {

    echo '<div class="a-alert">Sorry, this coupon is already imported.</div>';

} else {

    $info = array();
    $info['storeID']        = $store->ID;
    $info['title']          = ( !empty( $coupon['Title'] ) ? $coupon['Title'] : '' );
    $info['original_url']   = ( !empty( $coupon['Link'] ) ? $coupon['Link'] : '' );
    $info['code']           = ( !empty( $coupon['Code'] ) ? $coupon['Code'] : '' );
    $info['catID']          = ( !empty( $coupon['Category'] ) ? $coupon['Category'] : $store->catID );
    if( !isset( $_GET['type'] ) || !isset( $_GET['token'] ) || $_GET['type'] != 'delete_image' || !check_csrf( $_GET['token'], 'adad_plugin_csrf' ) ) {
        $info['image']          = ( !empty( $coupon['Image'] ) ? $coupon['Image'] : '' );
        $skip_image             = true;
    }
    $info['description']    = ( !empty( $coupon['Description'] ) ? $coupon['Description'] : '' );
    $info['start_date']     = ( !empty( $coupon['SD'] ) ? $coupon['SD'] : date( 'Y-m-d H:i:s' ) );
    $info['expiration_date']= ( !empty( $coupon['ED'] ) ? $coupon['ED'] : date( 'Y-m-d H:i:s' ) );
    $info['store_is_physical']  = $store->is_physical;
    $info['store_sellonline']   = $store->sellonline;
    $info['is_available_online']= true;
    $info = (object) $info;

    if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'adad_plugin_csrf' ) ) {

        if( isset( $_GET['type'] ) && $_GET['type'] == 'delete_image' ) {
            $info->image    = '';
            $skip_image     = true;
        }
        if( isset( $_POST['store'] ) && isset( $_POST['category'] ) && isset( $_POST['name'] ) && isset( $_POST['coupon_type'] ) && isset( $_POST['coupon_source_url'] ) && isset( $_FILES['coupon_source'] ) && isset( $_POST['code'] ) && isset( $_POST['description'] ) && isset( $_POST['tags'] ) && isset( $_POST['reward_points'] ) && isset( $_POST['votes'] ) && isset( $_POST['votes_average'] ) && isset( $_POST['lverified'] ) && isset( $_POST['start'] ) && isset( $_POST['end'] ) && isset( $_POST['meta_title'] ) && isset( $_POST['meta_keywords'] ) && isset( $_POST['meta_desc'] ) )
        if( ( $new_coupon_id = \plugin\AdmitadApiPro\inc\actions::add_item(
            array(
            'adadID'    => $id,
            'store'     => $_POST['store'],
            'category'  => $_POST['category'],
            'popular'   => ( isset( $_POST['popular'] ) ? 1 : 0 ),
            'exclusive' => ( isset( $_POST['exclusive'] ) ? 1 : 0 ),
            'printable' => ( in_array( (int) $_POST['coupon_type'], array( 1, 2 ) ) ? 1 : 0 ),
            'available_online'=> ( isset( $_POST['coupon_use_online'] ) ? 1 : 0 ),
            'name'      => $_POST['name'],
            'link'      => ( !isset( $_POST['coupon_ownlink'] ) && isset( $_POST['link'] ) && preg_match( '/^http(s)?/i', $_POST['link'] ) ? $_POST['link'] : '' ),
            'code'      => ( (int) $_POST['coupon_type'] === 0 ? $_POST['code'] : '' ),
            'source'    => ( (int) $_POST['coupon_type'] === 2 ? ( isset( $_POST['coupon_online_source'] ) ? ( filter_var( $_POST['coupon_source_url'], FILTER_VALIDATE_URL ) ? $_POST['coupon_source_url'] : '' ) : $_FILES['coupon_source'] ) : '' ),
            'description'=> $_POST['description'],
            'tags'      => $_POST['tags'],
            'cashback'  => $_POST['reward_points'],
            'start'     => date( 'Y-m-d H:i:s', strtotime( implode( ' ', $_POST['start'] ) ) ),
            'end'       => date( 'Y-m-d H:i:s', strtotime( implode( ' ', $_POST['end'] ) ) ),
            'image'     => isset( $_FILES['image'] ) ? $_FILES['image'] : array(),
            'import_image'=> ( !empty( $_FILES['image']['size'] ) || $skip_image ? (boolean) \query\main::get_option( 'adad_impimg' ) : false ),
            'image_url' => ( isset( $info->image ) ? $info->image : '' ),
            'votes'     => $_POST['votes'],
            'votes_average'=> $_POST['votes_average'],
            'verified'  => ( isset( $_POST['verified'] ) ? 1 : 0 ),
            'last_verif'=> date( 'Y-m-d H:i:s', strtotime( implode( ' ', $_POST['lverified'] ) ) ),
            'publish'   => ( isset( $_POST['publish'] ) ? 1 : 0 ),
            'meta_title'=> $_POST['meta_title'],
            'meta_keywords'=> $_POST['meta_keywords'],
            'meta_desc' => $_POST['meta_desc'],
            'extra'     => ( isset( $_POST['extra'] ) ? $_POST['extra'] : array() )
            ) ) ) ) {

            do_action( array( 'admin_coupon_added_edited', 'admin_coupon_added', 'admin_coupon_imported', 'admin_admitad_coupon_imported' ), $new_coupon_id );

            echo '<div class="a-success">Added!</div>';
            } else
            echo '<div class="a-error">Error!</div>';

    }

    $csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

    $main   = $GLOBALS['admin_main_class']->coupon_fields( $info, $csrf );
    $fields = $main['fields'];

    admin\widgets::get_page_tabs( $main );

    echo '<div class="form-table">

    <form action="#" method="POST" enctype="multipart/form-data" autocomplete="off" class="coupon-form">';

    uasort( $fields, function( $a, $b ) {
        if( (int) $a['position'] === (int) $b['position'] ) return 0;
        return ( (int) $a['position'] < (int) $b['position'] ? -1 : 1 );
    } );

    foreach( $fields as $key => $f ) {
        echo $f['markup'];
    }

    echo '<div id="modify_mt">

    <div class="title">
        <h2>Modify Personalized Meta-Tags</h2>
    </div>

    <div class="content">';

    $fields = $GLOBALS['admin_main_class']->meta_tags_fields( $info, $csrf, true );

    uasort( $fields, function( $a, $b ) {
        if( (double) $a['position'] === (double) $b['position'] ) return 0;
        return ( (double) $a['position'] < (double) $b['position'] ? -1 : 1 );
    } );

    foreach( $fields as $key => $f ) {
        echo $f['markup'];
    }

    echo '</div>

    </div>

    <input type="hidden" name="csrf" value="' . $csrf . '" />

    <div class="twocols">
        <div>
            <button class="btn btn-important">Import</button>
        </div>
        <div>
            <a href="#" class="btn" id="modify_mt_but">Meta Tags</a>
        </div>
    </div>

    </form>

    </div>';

}

break;


/** IMPORT COUPONS */

case 'import_coupons':

if( empty( $_POST['id'] ) || empty( $_POST['coupon'] ) ) {

    echo '<div class="a-error">Select the coupons that you want to import.</div>';
    echo '<a href="?' . esc_html( $_POST['request_uri'] ) . '" class="btn">Back</a>';

} else {

    if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['token'] ) && check_csrf( $_POST['token'], 'adad_plugin_csrf' ) ) {

        $success = $error = 0;

        foreach( $_POST['coupon'] as $coupon ) {

        $coupon = json_decode( urldecode( $coupon ), true );

        $id = key( $coupon );

        $coupon = current( $coupon );

        if( isset( $_POST['id'][$id] ) )

        if( ( $store = \plugin\AdmitadApiPro\inc\import::store_imported( $coupon['Advertiser'] ) ) && \plugin\AdmitadApiPro\inc\actions::add_item(
        array(
        'adadID'     => $id,
        'store'     => $store->ID,
        'category'  => ( isset( $_POST['category'] ) ? $_POST['category'] : $store->catID ),
        'popular'   => 0,
        'exclusive' => 0,
        'printable' => 0,
        'available_online'=> 1,
        'name'      => ( !empty( $_POST['coupon_name'][$id] ) ? $_POST['coupon_name'][$id] : '' ),
        'link'      => urldecode( $coupon['Link'] ),
        'code'      => ( isset( $coupon['Code'] ) ? $coupon['Code'] : '' ),
        'source'    => '',
        'description'=> ( !empty( $_POST['coupon_description'][$id] ) ? $_POST['coupon_description'][$id] : '' ),
        'tags'      => '',
        'cashback'  => 0,
        'start'     => ( isset( $coupon['SD'] ) ? $coupon['SD'] : date( 'Y-m-d H:i:s' ) ),
        'end'       => ( isset( $coupon['ED'] ) ? $coupon['ED'] : date( 'Y-m-d H:i:s' ) ),
        'image'     => array(),
        'import_image'=> (boolean) \query\main::get_option( 'adad_impimg' ),
        'image_url' => ( isset( $coupon['Image'] ) ? $coupon['Image'] : '' ),
        'votes'     => 0,
        'votes_average'=> 0.00,
        'verified'  => 0,
        'last_verif'=> date( 'Y-m-d H:i:s' ),
        'publish'   => 1,
        'meta_title'=> '',
        'meta_keywords'=> '',
        'meta_desc' => '',
        'extra'     => array()
        ) ) ) {
            $success++;
        } else {
            $error++;

        }

        }

        echo '<div class="a-message">Import procedure has been successfully finished.</div>';

        echo '<ul class="announce-box">
        <li>Imported:<b>' . $success . '</b></li>
        <li>Errors:<b>' . $error . '</b></li>
        </ul>';

    }

    echo '<a href="?' . esc_html( $_POST['request_uri'] ) . '" class="btn">Back</a>';

}

break;


/** PREVIEW STORE */

case 'store_preview':

echo '<div class="title">

<h2>Preview & Import</h2>
<div style="float:right;margin:0 2px 0 0;">

<div class="options">
    <a href="#" class="btn">Show</a>
    <ul>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=programs">Programs</a></li>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Coupons</a></li>
        <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
        <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
    </ul>
</div>

</div>

<span>Here you can edit the details of this store before the import</span>

</div>';

if( isset( $_GET['store'] ) ) {

    $store = json_decode( urldecode( $_GET['store'] ), true );

    $id = key( $store );

    $store = array_map( 'htmlspecialchars', current( $store ) );

}

if( !isset( $id ) ) {

    echo '<div class="a-error">Error !</div>';

} else if( \plugin\AdmitadApiPro\inc\import::store_imported( $id ) ) {

    echo '<div class="a-error">Sorry, this store is already imported.</div>';

} else {

    $info = array();
    $skip_image = false;
    $info['name']           = ( !empty( $store['Name'] ) ? $store['Name'] : '' );
    $info['url']            = ( !empty( $store['Link'] ) ? $store['Link'] : '' );

    if( !isset( $_GET['type'] ) || !isset( $_GET['token'] ) || $_GET['type'] != 'delete_image' || !check_csrf( $_GET['token'], 'adad_plugin_csrf' ) ) {
        $info['image']      = ( !empty( $store['Image'] ) ? $store['Image'] : '' );
        $skip_image         = true;
    }

    $info = (object) $info;

    if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'adad_plugin_csrf' ) ) {

        if( isset( $_GET['type'] ) && $_GET['type'] == 'delete_image' ) {
            $info->image    = '';
            $skip_image     = true;
        }

        if( isset( $_POST['user'] ) && isset( $_POST['category'] ) && isset( $_POST['name'] ) && isset( $_POST['store_type'] ) && isset( $_POST['url'] ) && isset( $_POST['description'] ) && isset( $_POST['tags'] ) && isset( $_POST['meta_title'] ) && isset( $_POST['meta_keywords'] ) && isset( $_POST['meta_desc'] ) )
        if( ( $new_store_id = \plugin\AdmitadApiPro\inc\actions::add_store(
        array(
        'adadID'    => $id,
        'user'      => $_POST['user'],
        'category'  => $_POST['category'],
        'name'      => $_POST['name'],
        'type'      => $_POST['store_type'],
        'url'       => $_POST['url'],
        'description'=> $_POST['description'],
        'tags'      => $_POST['tags'],
        'hours'     => ( isset( $_POST['hours-bi'] ) ? array() : $_POST['hours'] ),
        'sellonline'=> ( isset( $_POST['sellonline'] ) ? 1 : 0 ),
        'popular'   => ( isset( $_POST['popular'] ) ? 1 : 0 ),
        'publish'   => ( isset( $_POST['publish'] ) ? 1 : 0 ),
        'logo'      => isset( $_FILES['logo'] ) ? $_FILES['logo'] : array(),
        'import_logo'=> ( !empty( $_FILES['logo']['size'] ) || $skip_image ? (boolean) \query\main::get_option( 'adad_impimg' ) : false ),
        'logo_url'  => ( isset( $info->image ) ? $info->image : '' ),
        'phone'     => $_POST['phone'],
        'meta_title'=> $_POST['meta_title'],
        'meta_keywords'=> $_POST['meta_keywords'],
        'meta_desc' => $_POST['meta_desc'],
        'extra'     => ( isset( $_POST['extra'] ) ? $_POST['extra'] : array() )
        ) ) ) ) {

        do_action( array( 'admin_store_added_edited', 'admin_store_added', 'admin_store_imported', 'admin_admitad_store_imported' ), $new_store_id );

        echo '<div class="a-success">Added!</div>';
        } else
        echo '<div class="a-error">Error!</div>';

    }

    $csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

    $main   = $GLOBALS['admin_main_class']->store_fields( $info, $csrf );
    $fields = $main['fields'];

    admin\widgets::get_page_tabs( $main );

    echo '<div class="form-table">

    <form action="#" method="POST" enctype="multipart/form-data" autocomplete="off">';

    uasort( $fields, function( $a, $b ) {
        if( (int) $a['position'] === (int) $b['position'] ) return 0;
        return ( (int) $a['position'] < (int) $b['position'] ? -1 : 1 );
    } );

    foreach( $fields as $key => $f ) {
            echo $f['markup'];
    }

    echo '<div id="modify_mt">

    <div class="title">
        <h2>Modify Personalized Meta-Tags</h2>
    </div>

    <div class="content">';

    $fields = $GLOBALS['admin_main_class']->meta_tags_fields( $info, $csrf, true );

    uasort( $fields, function( $a, $b ) {
        if( (double) $a['position'] === (double) $b['position'] ) return 0;
        return ( (double) $a['position'] < (double) $b['position'] ? -1 : 1 );
    } );

    foreach( $fields as $key => $f ) {
        echo $f['markup'];
    }

    echo '</div>

    </div>

    <input type="hidden" name="csrf" value="' . $csrf . '" />

    <div class="twocols">
        <div>
            <button class="btn btn-important">Import</button>
        </div>
        <div>
            <a href="#" class="btn" id="modify_mt_but">Meta Tags</a>
        </div>
    </div>

    </form>

    </div>';

}

break;


/** IMPORT STORES */

case 'import_stores':

if( empty( $_POST['id'] ) || empty( $_POST['store'] ) ) {

    echo '<div class="a-error">Select the stores that you want to import.</div>';
    echo '<a href="?' . esc_html( $_POST['request_uri'] ) . '" class="btn">Back</a>';

} else {

    if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['token'] ) && check_csrf( $_POST['token'], 'adad_plugin_csrf' ) ) {

        $success = $error = 0;

        foreach( $_POST['store'] as $store ) {

        $store = json_decode( urldecode( $store ), true );

        $id = key( $store );

        $store = current( $store );

        if( isset( $_POST['id'][$id] ) )

        if( !\plugin\AdmitadApiPro\inc\import::store_imported( $id ) && \plugin\AdmitadApiPro\inc\actions::add_store(
        array(
        'adadID'    => $id,
        'user'      => $GLOBALS['me']->ID,
        'category'  => ( isset( $_POST['category'] ) ? $_POST['category'] : 0 ),
        'name'      => ( !empty( $_POST['store_name'][$id] ) ? $_POST['store_name'][$id] : '' ),
        'type'      => '',
        'url'       => urldecode( $store['Link'] ),
        'description' => ( !empty( $_POST['store_description'][$id] ) ? $_POST['store_description'][$id] : '' ),
        'tags'      => '',
        'hours'     => array(),
        'sellonline'=> 1,
        'popular'   => 0,
        'publish'   => 1,
        'logo'      => array(),
        'import_logo'=> (boolean) \query\main::get_option( 'adad_impimg' ),
        'logo_url'  => ( isset( $store['Image'] ) ? $store['Image'] : '' ),
        'phone'     => '',
        'meta_title'=> '',
        'meta_keywords' => '',
        'meta_desc' => '',
        'extra'     => array()
        ) ) ) {
            $success++;
        } else {
            $error++;

        }

        }

        echo '<div class="a-message">Import procedure has been successfully finished.</div>';

        echo '<ul class="announce-box">
        <li>Imported:<b>' . $success . '</b></li>
        <li>Errors:<b>' . $error . '</b></li>
        </ul>';

    }

    echo '<a href="?' . esc_html( $_POST['request_uri'] ) . '" class="btn">Back</a>';

}

break;


/** DEEPLINK GENERATOR */

case 'deeplink':

echo '<div class="title">

<h2>Deeplink Generator</h2>

<div style="float:right;margin:0 2px 0 0;">

<div class="options">
    <a href="#" class="btn">Show</a>
    <ul>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=programs">Programs</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Coupons</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
    <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
    </ul>
</div>

</div>

<span>List of coupons</span>

</div>';

$results = '';

if( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['csrf'] ) && check_csrf( $_POST['csrf'], 'adad_plugin_csrf' ) ) {

    if( !empty( $_POST['program'] ) && !empty( $_POST['list'] ) && !empty( $_POST['subid'] ) ) {

        $success = $error = 0;
        $links = array_filter( explode( "\n", $_POST['list'] ) );

        foreach( $links as $link ) {
            /** New Admitad Client */
            $adad = new \plugin\AdmitadApiPro\inc\client;
            /** */

            try {
                $result = $adad->getDeepLink( (int) $_POST['program'], trim( $link ), $_POST['subid'] );

                if( !isset( $result['error'] ) ) {
                    $results .= $result[0];
                    $results .= "\r\n";
                    $success++;
                } else {
                    $error++;
                }
            }

            catch( Exception $e ) {
                $error++;
            }
        }

        if( $success > 0 ) {
            echo '<div class="a-success">' . sprintf( '%s links generated, %s errors', $success, $error ) . '</div>';
        } else
            echo '<div class="a-error">Error!</div>';

    }

}

$csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

echo '<div class="form-table">

<form action="#" method="POST">
    <div class="row"><span>Program ID:</span><div><input type="text" name="program" value="' . ( isset( $_GET['id'] ) ? (int) $_GET['id'] : '' ) . '" required /></div></div>
    <div class="row"><span>The list of links (one link per row):</span><div><textarea type="text" name="list" required /></textarea></div></div>
    <div class="row"><span>Sub-ID Tracking:</span><div><input type="text" name="subid" value="" required /></div></div>

    <input type="hidden" name="csrf" value="' . $csrf . '" />
    <div class="twocols">
        <div>
            <button class="btn btn-important">Generate</button>
        </div>
        <div></div>
    </div>
</form>';

if( !empty( $results ) ) {

    echo '<div class="section-content">
    <div class="title">
        <h2>Results</h2>
    </div>

    <div class="content">
        <div class="row"><span>Links Generated:</span><div><textarea type="text" name="results" readonly />' . trim( esc_html( $results ) ) . '</textarea></div></div>
    </div>

    </div>';

}

echo '</div>';

break;


/** LIST OF COUPONS */

case 'coupons':

echo '<div class="title">

<h2>Coupons</h2>

<div style="float:right;margin:0 2px 0 0;">

<div class="options">
    <a href="#" class="btn">Show</a>
    <ul>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=programs">Programs</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
    <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
    </ul>
</div>

</div>

<span>List of coupons</span>

</div>';

$csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

/** New Admitad Client */
$adad = new \plugin\AdmitadApiPro\inc\client;
/** */

echo '<div class="page-toolbar">

<form action="#" method="GET" autocomplete="off" style="float:right;">
<input type="hidden" name="plugin" value="AdmitadApiPro/admitad.php" />
<input type="hidden" name="action" value="coupons" />';
if( isset( $_GET['id'] ) ) echo '<input type="hidden" name="id" value="' . (int) $_GET['id'] . '" />';
echo '<input type="search" name="search" value="' . ( !isset( $_GET['search'] ) ? '' : esc_html( $_GET['search'] ) ) . '" placeholder="Search coupons" />
<button class="btn">Search</button>
</form>

</div>';

try {

    $options = array();

    $options['region'] = strtoupper( \query\main::get_option( 'adad_region' ) );

    if( !empty( $_GET['search'] ) ) $options['search'] = esc_html( $_GET['search'] );

    if( isset( $_GET['id'] ) ) {
        $options['campaign'] = (int) $_GET['id'];
    }

    if( isset( $_GET['page'] ) ) {
        $options['offset'] = ( (int) $_GET['page'] - 1 ) * 20;
    }

    $coupons    = $adad->getCoupons( $options );

    if( !isset( $coupons['_meta']['count'] ) ) {
        $coupons['_meta']           = array();
        $coupons['_meta']['count']  = 0;
    }

    echo '<div class="results">' . number_format( $coupons['_meta']['count'] ) . ' results';
    if( !empty( $_GET['id'] ) || !empty( $_GET['search'] ) ) echo ' / <a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Reset view</a>';
    echo '</div>';

    if( !empty( $coupons['results'] ) ) {

    echo '<form action="?plugin=AdmitadApiPro/admitad.php&amp;action=import_coupons#" method="POST">

    <ul class="elements-list">

    <li class="head"><input type="checkbox" id="selectall" data-checkall /> <label for="selectall"><span></span> Name</label>
    <a href="#" class="adad-qe" style="margin-right:7px;">Quick Edit</a></li>

    <div class="bulk_options">';

    if( isset( $_GET['id'] ) ) echo '<input type="hidden" name="id" value="' . (int) $_GET['id'] . '" />';
    echo '<input type="hidden" name="page" value="' . ( isset( $_GET['page'] ) ? (int) $_GET['page'] : 1 ) . '" />';
    if( isset( $_GET['search'] ) ) echo '<input type="hidden" name="search" value="' . esc_html( $_GET['search'] ) . '" />';
    if( isset( $_GET['search_type'] ) ) echo '<input type="hidden" name="search_type" value="' . esc_html( $_GET['search_type'] ) . '" />';
    if( isset( $_GET['sort'] ) ) echo '<input type="hidden" name="sort" value="' . esc_html( $_GET['sort'] ) . '" />';
    echo '<button class="btn">Import all</button>

    </div>';

    $ab_edt = ab_to( array( 'coupons' => 'edit' ) );

    foreach( $coupons['results'] as $item ) {

        // item id
        $item_id        = $item['id'];

        // check first if this store is imported on your website
        $store_imported = \plugin\AdmitadApiPro\inc\import::store_imported( $item['campaign']['id'] );

        // check first if this coupon is imported on your website
        $coupon_imported = \plugin\AdmitadApiPro\inc\import::coupon_imported( $item['id'] );

        echo '<li>
        <div>

        <input type="checkbox" name="id[' . $item_id . ']" id="id[' . $item_id . ']"' . ( !$store_imported || ( $store_imported && $coupon_imported ) ? ' disabled' : '' ) . ' /> <label for="id[' . $item_id . ']"><span></span></label>

        <img src="' . ( \query\main::store_avatar( ( $store_imported ? $store_imported->image : $item['image'] ) ) ) . '" alt="" style="width:80px;min-width:80px;" />
        <div class="info-div">
        <h2>' . ( $store_imported && $coupon_imported ? '<span class="msg-alert" title="Local name: ' . $coupon_imported->title . '">Imported</span> ' : '' ) . esc_html( $item['name'] ) . '</h2>';
         if( !( $store_imported && $coupon_imported ) ) {
            echo '<div class="adad-coupon-info" style="display:none;">
            <input type="text" name="coupon_name[' . $item_id . ']" style="width:100%;margin-bottom:5px;" value="' . esc_html( $item['name'] ) . '" />';
            echo 'Description:';
            echo '<textarea name="coupon_description[' . $item_id . ']" style="width:100%;margin-bottom:5px;">' . esc_html( trim( $item['description'] ) ) . '</textarea>
            </div>';
        }
        echo 'Advertiser: <b>' . ( $store_imported ? '<span class="msg-success">Imported</span> ' : '<span class="msg-alert">Not Imported</span> ' ) . '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons&amp;id=' . $item['campaign']['id'] . '">' . esc_html( $item['campaign']['name'] ) . '</a>' . ( !$store_imported ? ' / <a href="?plugin=AdmitadApiPro/admitad.php&amp;action=store_assign&amp;id=' . $item['campaign']['id'] . '">Assign</a>' : '' ) . '</b> <br />
         URL: <a href="' . esc_html( $item['goto_link'] ) . '" target="_blank">' . ( ( $url = urldecode( $item['goto_link'] ) ) && strlen( $url ) > 50 ? esc_html( substr( $url, 0, 50 ) ) . '...' : esc_html( $url ) ) . '</a> <br />';
         echo \plugin\AdmitadApiPro\inc\markup::get_categories( $item['categories'] );

        echo '<a href="javascript:void(0)" onclick="$(this).next().is(\':visible\') ? $(this).next().slideUp() : $(this).next().slideDown(); return false;">More/Less</a>

        <div class="store_more" style="display:none;margin-top:8px;">';

        $jsdt = array();
        $jsdt[$item_id]['Advertiser']   = $item['campaign']['id'];
        $jsdt[$item_id]['Title']        = $item['name'];
        $jsdt[$item_id]['Link']         = \site\utils::update_uri( $item['goto_link'], array( 'subid' => '{UID}', 'subid1' => '{TYPE}', 'subid2' => '{ID}' ) );
        $jsdt[$item_id]['SD']           = $item['date_start'];
        $jsdt[$item_id]['ED']           = $item['date_end'];

        echo 'Status: <b>' . esc_html( $item['status'] ) . '</b> <br />';
        echo 'Rating: <b>' . esc_html( $item['rating'] ) . '</b> <br />';
        echo 'Discount: <b>' . esc_html( $item['discount'] ) . '</b> <br />';
        echo esc_html( $item['campaign']['name'] ) . ' Program ID: <b>' . esc_html( $item['campaign']['id'] ) . '</b> <br />';
        if( $item['species'] == 'promocode' && !empty( $item['promocode'] ) ) {
            $jsdt[$item_id]['Code']     = $item['promocode'];
            echo 'Code: <b>' . esc_html( $item['promocode'] ) . '</b> <br />';
        }
        echo 'Species: <b>' . esc_html( $item['species'] ) . '</b> <br />';
        echo 'Start date: <b>' . esc_html( $item['date_start'] ) . '</b> <br />';
        echo 'Expiration date: <b>' . esc_html( $item['date_end'] ) . '</b>';

        if( !empty( $item['description'] ) ) {
            $jsdt[$item['id']]['Description'] = trim( $item['description'] );
            echo '<br />Description: <b>' . esc_html( $item['description'] ) . '</b>';
        }

        echo '<br />Regions: <b>' . ( $item['regions'][0] == '00' ? 'All' : implode( ', ', $item['regions'] ) ) . '</b>';

        echo '</div>

        </div></div>

        <div style="clear:both;"></div>

        <div class="options">';

        if( $store_imported && !$coupon_imported ) {
            echo '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupon_preview&amp;coupon=' . esc_html( $cdata = urlencode( json_encode( $jsdt ) ) ) . '">Preview & Import</a>';
            echo '<input type="hidden" name="coupon[]" value="' . $cdata . '" />';
        }

        if( $coupon_imported && $ab_edt ) {
            echo '<a href="?route=coupons.php&amp;action=edit&amp;id=' . $coupon_imported->ID . '">Edit</a>';
        }

        echo '</div>
        </li>';

    }

    echo '</ul>

    <input type="hidden" name="request_uri" value="' . esc_html( http_build_query( $_GET, '', '&' ) ) . '" />
    <input type="hidden" name="token" value="' . $csrf . '" />

    </form>';

    \plugin\AdmitadApiPro\inc\markup::pagination( ceil( $coupons['_meta']['count'] / 20 ) );

    } else echo '<div class="a-alert">No coupons.</div>';

}

catch( Exception $e ) {

    echo '<div class="a-error">' . $e->getMessage() . '</div>';

}

break;

default:

echo '<div class="title">

<h2>Programs</h2>

<div style="float:right;margin:0 2px 0 0;">

<div class="options">
    <a href="#" class="btn">Show</a>
    <ul>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons">Coupons</a></li>
    <li><a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink">Deeplink Generator</a></li>
    <li><a href="?plugin=AdmitadApiPro/options.php">Settings</a></li>
    </ul>
</div>

</div>

<span>List of programs</span>

</div>';

$csrf = $_SESSION['adad_plugin_csrf'] = \site\utils::str_random(10);

/** New Admitad Client */
$adad = new \plugin\AdmitadApiPro\inc\client;
/** */

/*
echo '<div class="page-toolbar">

<form action="#" method="GET" autocomplete="off" style="float:right;">
<input type="hidden" name="plugin" value="AdmitadApiPro/admitad.php" />
<input type="hidden" name="action" value="list" />';
echo '<input type="search" name="search" value="' . ( !isset( $_GET['search'] ) ? '' : esc_html( $_GET['search'] ) ) . '" placeholder="Search programs" />
<button class="btn">Search</button>
</form>

</div>';
*/

try {

    $options = array();

    if( isset( $_GET['page'] ) ) {
        $options['offset'] = ( (int) $_GET['page'] - 1 ) * 20;
    }

    $stores     = $adad->getPrograms( $options );

    if( !isset( $stores['_meta']['count'] ) ) {
        $stores['_meta']           = array();
        $stores['_meta']['count']  = 0;
    }

    echo '<div class="results">' . number_format( $stores['_meta']['count'] ) . ' results';
    // if( !empty( $_GET['search'] ) ) echo ' / <a href="?plugin=AdmitadApiPro/admitad.php&amp;action=list">Reset view</a>';
    echo '</div>';

    if( !empty( $stores['results'] ) ) {

    echo '<form action="?plugin=AdmitadApiPro/admitad.php&amp;action=import_stores#" method="POST">

    <ul class="elements-list">

    <li class="head"><input type="checkbox" id="selectall" data-checkall /> <label for="selectall"><span></span> Name</label>
    <a href="#" class="adad-qe" style="margin-right:7px;">Quick Edit</a></li>

    <div class="bulk_options">

    Category: ';
    echo '<select name="category">';
        foreach( \query\main::group_categories( array( 'max' => 0 ) ) as $cat ) {
            echo '<optgroup label="' . $cat['info']->name . '">';
            echo '<option value="' . $cat['info']->ID . '">' . $cat['info']->name . '</option>';
            if( isset( $cat['subcats'] ) ) {
            foreach( $cat['subcats'] as $subcat ) {
                echo '<option value="' . $subcat->ID . '">' . $subcat->name . '</option>';
            }
            }
            echo '</optgroup>';
        }
    echo '</select> ';

    if( isset( $_GET['id'] ) ) echo '<input type="hidden" name="id" value="' . (int) $_GET['id'] . '" />';
    echo '<input type="hidden" name="page" value="' . ( isset( $_GET['page'] ) ? (int) $_GET['page'] : 1 ) . '" />';
    if( isset( $_GET['search'] ) ) echo '<input type="hidden" name="search" value="' . esc_html( $_GET['search'] ) . '" />';
    if( isset( $_GET['search_type'] ) ) echo '<input type="hidden" name="search_type" value="' . esc_html( $_GET['search_type'] ) . '" />';
    if( isset( $_GET['sort'] ) ) echo '<input type="hidden" name="sort" value="' . esc_html( $_GET['sort'] ) . '" />';
    echo '<button class="btn">Import all</button>

    </div>';

    $ab_edt = ab_to( array( 'coupons' => 'edit' ) );

    foreach( $stores['results'] as $item ) {

        // item id
        $item_id        = $item['id'];

        // check first if this store is imported on your website
        $imported = \plugin\AdmitadApiPro\inc\import::store_imported( $item['id'] );

        echo '<li>
        <div>
            <input type="checkbox" name="id[' . $item_id . ']" id="id[' . $item_id . ']"' . ( $imported ? ' disabled' : '' ) . ' /> <label for="id[' . $item_id . ']"><span></span></label>
            <img src="' . ( \query\main::store_avatar( ( $imported ? $imported->image : esc_html( $item['image'] ) ) ) ) . '" alt="" style="width:80px;min-width:80px;" />
            <div class="info-div">
                <h2>' . ( !$imported ? '<span class="msg-alert">Not imported</span> ' : '' ) . esc_html( $item['name'] ) . '</h2>';
                if( !$imported ) {
                    echo '<div class="adad-store-info" style="display:none;">
                    <input type="text" name="store_name[' . $item_id . ']" style="width:100%;margin-bottom:5px;" value="' . esc_html( $item['name'] ) . '" />';
                    echo 'Description:';
                    echo '<textarea name="store_description[' . $item_id . ']" style="width:100%;margin-bottom:5px;"></textarea>
                    </div>';
                }
                echo 'URL: <a href="' . esc_html( $item['site_url'] ) . '" target="_blank">' . ( ( $url = urldecode( $item['site_url'] ) ) && strlen( $url ) > 50 ? esc_html( substr( $url, 0, 50 ) ) . '...' : esc_html( $url ) ) . '</a> <br />
                <a href="javascript:void(0)" onclick="$(this).next().is(\':visible\') ? $(this).next().slideUp() : $(this).next().slideDown(); return false;">More/Less</a>

                <div class="store_more" style="display:none;margin-top:8px;">';

                $jsdt = array();
                $jsdt[$item_id]['Name']         = $item['name'];
                $jsdt[$item_id]['Link']         = \site\utils::update_uri( $item['gotolink'], array( 'subid' => '{UID}', 'subid1' => '{TYPE}', 'subid2' => '{ID}' ) );
                $jsdt[$item_id]['Image']        = $item['image'];

                echo 'Connection Status: <b>' . esc_html( $item['connection_status'] ) . '</b> <br />';
                echo 'Rating: <b>' . esc_html( $item['rating'] ) . '</b> <br />';
                echo 'Program ID: <b>' . esc_html( $item_id ) . '</b> <br />';
                echo 'Cookie Lifetime: <b>' . esc_html( $item['goto_cookie_lifetime'] ) . '</b> <br />';
                echo 'Currency: <b>' . esc_html( $item['currency'] ) . '</b> <br />';
                echo 'Average Hold Time: <b>' . esc_html( $item['avg_hold_time'] ) . '</b> <br />';
                echo 'Average Money Transfer Time: <b>' . esc_html( $item['avg_money_transfer_time'] ) . '</b> <br />';

                echo '</div>';
            echo '</div>
        </div>

        <div style="clear:both;"></div>

        <div class="options">';
        if( !$imported ) {
            echo '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=store_preview&amp;store=' . esc_html( $sdata = urlencode( json_encode( $jsdt ) ) ) . '">Preview & Import</a>';
            echo '<input type="hidden" name="store[]" value="' . $sdata . '" />';
        }
        echo '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=coupons&amp;id=' . $item['id'] . '">View Coupons</a>';
        echo '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=deeplink&amp;id=' . esc_html( $item_id ) . '">Deeplink Generator</a>';
        echo '<a href="?plugin=AdmitadApiPro/admitad.php&amp;action=store_assign&amp;id=' . $item['id'] . '">' . ( $imported ? 'Change ID' : 'Assign ID' ) . '</a>';

        echo '</div>
        </li>';

    }

    echo '</ul>

    <input type="hidden" name="request_uri" value="' . esc_html( http_build_query( $_GET, '', '&' ) ) . '" />
    <input type="hidden" name="token" value="' . $csrf . '" />

    </form>';

    \plugin\AdmitadApiPro\inc\markup::pagination( ceil( $stores['_meta']['count'] / 20 ) );

    } else echo '<div class="a-alert">No programs.</div>';

}

catch( Exception $e ) {

    echo '<div class="a-error">' . $e->getMessage() . '</div>';

}

break;

}