<?php

class couponscms_home_slider {

    public static function shortcode( $atts, $content ) {
        // Attributes (for future extension) - simple merge, no WordPress helpers
        $atts = array_merge([
            'autoplay' => '1',
            'loop'     => '1',
        ], (array) $atts );

        // Get slides from admin slider management
        $slides_json = \query\main::get_option( 'homepage_slider_slides', false );
        
        $slides_data = array();
        if( !empty( $slides_json ) ) {
            $slides_data = @json_decode( $slides_json, true );
            if( !is_array( $slides_data ) ) {
                $slides_data = array();
            }
        }
        
        // Sort by order first
        uasort( $slides_data, function( $a, $b ) {
            $order_a = isset( $a['order'] ) ? (int) $a['order'] : 999;
            $order_b = isset( $b['order'] ) ? (int) $b['order'] : 999;
            if( $order_a === $order_b ) return 0;
            return ( $order_a < $order_b ? -1 : 1 );
        } );
        
        // Convert to format expected by template
        $slides = array();
        foreach( $slides_data as $id => $slide_data ) {
            $slides[] = array(
                'slide' => array(
                    'image' => $slide_data['image'],
                    'link'  => !empty( $slide_data['link'] ) ? $slide_data['link'] : ''
                )
            );
        }

        if( empty( $slides ) ) {
            return '';
        }

        // Build markup: wrapper with proper section spacing
        $markup  = '<section class="hero-slider-section">
            <div class="home-hero-slider">
                <div class="owl-carousel owl-theme home-hero-owl">';

        foreach( $slides as $slide ) {
            // Get image URL
            $image = $slide['slide']['image'];
            if( !filter_var( $image, FILTER_VALIDATE_URL ) ) {
                // Local image - prepend site URL if needed
                if( !empty( $image ) && strpos( $image, 'http' ) !== 0 ) {
                    $image = site_url( $image );
                }
            }

            $link  = !empty( $slide['slide']['link'] ) ? esc_html( $slide['slide']['link'] ) : '#';
            $img   = esc_html( $image );

            $markup .= '<div class="item">
                            <a href="' . $link . '">
                                <img src="' . $img . '" alt="" class="slider-image" />
                            </a>
                        </div>';
        }

        $markup .= '   </div>
            </div>
        </section>';

        return $markup;
    }
}

// Register shortcode [home_slider]
add( 'shortcodes', 'home_slider', [ 'couponscms_home_slider', 'shortcode' ] );
