<!DOCTYPE html>
<html>

<head>
<?php echo add_head(); ?>
</head>

<body<?php echo ( ( $body_classes = body_classes() ) ? ' class="' . $body_classes . '"' : ''); ?>>

<!-- Preloader -->
<div id="preloader">
    <div class="preloader-circle"></div>
</div>

<script>
// Preloader fadeout - vanilla JavaScript (works without jQuery)
window.addEventListener('load', function() {
    var preloader = document.getElementById('preloader');
    if (preloader) {
        preloader.classList.add('hide');
        setTimeout(function() {
            preloader.remove();
        }, 500);
    }
});
</script>

<div class="bgGray">

<header class="menu-container">
    <div class="header-menu container">
        <?php
        // OneSignal Bell Icon
        $onesignal_app_id = \query\main::get_option( 'onesignal_app_id' );
        if( !empty( $onesignal_app_id ) ) {
            echo '<div id="onesignal-bell-container" class="onesignal-bell-container"></div>';
        }
        ?>
        <div class="logo">
            <a href="<?php echo tlink( 'index' ); ?>"><img src="<?php echo site_logo( THEME_LOCATION . '/assets/img/logo.png' ); ?>" alt="" /></a>
        </div>
        <?php $menu = couponscms_menu( 'main' ); ?>
        <div class="header-search header-search--in-header desktop-only">
            <span class="header-search-icon"><i class="fas fa-search"></i></span>
            <div class="search-input">
                <input type="text" name="s" placeholder="<?php te( 'search_coupons_stores', 'Search categories or stores' ); ?>" data-ajax-search="<?php echo ajax_call_url( 'slick_ajax_search' ); ?>" autocomplete="off" />
                <div class="search-helper"></div>
            </div>
        </div>
        <ul class="menu text-right">
            <?php if( ( $me = me() ) ) { ?>
            <li class="user-name hlbt"><a href="<?php echo tlink( 'user/account' ); ?>" class="button"><?php echo $me->Name; ?></a></li>
            <?php } else { ?>
            <li class="sing-in"><a href="<?php echo tlink( 'tpage/login' ); ?>"><?php te( 'theme_login_button', 'Sign In' ); ?></a></li>
            <li class="register hlbt"><a href="<?php echo tlink( 'tpage/register' ); ?>"><?php te( 'theme_join_button', 'Join' ); ?></a></li>
            <?php } ?>
            <?php echo ( $languages = couponscms_site_languages() ); ?>
        </ul>
        <div class="mobile-search-icon">
            <a href="#" class="show-search"><i class="fas fa-search"></i></a>
        </div>
        <div class="mob-menu">
            <a href="#">
                <div class="lines">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </a>
        </div>
    </div>

    <div class="mobile-overlay">
        <div class="mobile-menu">
            <div>
                <ul class="menu">
                <?php echo $menu; ?>
                </ul>
                <ul class="user-links">
                <?php if( $me ) { ?>
                <li class="user-name hlbt"><a href="<?php echo tlink( 'user/account' ); ?>" class="button"><?php echo $me->Name; ?></a></li>
                <?php } else { ?>
                <li class="sing-in"><a href="<?php echo tlink( 'tpage/login' ); ?>"><?php te( 'theme_login_button', 'Sign In' ); ?></a></li>
                <li class="register hlbt"><a href="<?php echo tlink( 'tpage/register' ); ?>"><?php te( 'theme_join_button', 'Join' ); ?></a></li>
                <?php } ?>
                    <?php echo $languages; ?>
                </ul>
            </div>
            <div>
                <div class="container">
                    <?php echo couponscms_search_form( 'clearfix', false ); ?>
                    <a href="#" class="mt-30 d-block close-search"><i class="fa fa-angle-left"></i> <?php te( 'back_to_menu', 'Back to menu' ); ?></a>
                </div>
            </div>
        </div>
    </div>

</header>

<div class="menu-spacer"></div>

<!-- Main nav bar (desktop) -->
<nav class="main-nav desktop-only">
    <div class="container">
        <ul class="menu main-nav-menu">
            <?php echo $menu; ?>
        </ul>
    </div>
</nav>

</div>

<?php if( this_is_home_page() ) { 
    // Render the new OwlCarousel-based home slider managed from admin slider page
    // Get slides from admin slider management
    $slides_json = \query\main::get_option( 'homepage_slider_slides', false );
    
    $slides_data = array();
    if( !empty( $slides_json ) ) {
        $slides_data = @json_decode( $slides_json, true );
        if( !is_array( $slides_data ) ) {
            $slides_data = array();
        }
    }
    
    // Sort by order first
    uasort( $slides_data, function( $a, $b ) {
        $order_a = isset( $a['order'] ) ? (int) $a['order'] : 999;
        $order_b = isset( $b['order'] ) ? (int) $b['order'] : 999;
        if( $order_a === $order_b ) return 0;
        return ( $order_a < $order_b ? -1 : 1 );
    } );
    
    if( !empty( $slides_data ) ) {
        echo '<section class="hero-slider-section">';
        echo '<div class="home-hero-slider">';
        echo '<div class="owl-carousel owl-theme home-hero-owl">';
        
        foreach( $slides_data as $id => $slide_data ) {
            // Get image URL
            $image = $slide_data['image'];
            if( !filter_var( $image, FILTER_VALIDATE_URL ) ) {
                // Local image - prepend site URL if needed
                if( !empty( $image ) && strpos( $image, 'http' ) !== 0 ) {
                    $image = site_url( $image );
                }
            }
            
            $link = !empty( $slide_data['link'] ) ? esc_html( $slide_data['link'] ) : '#';
            $img = esc_html( $image );
            
            echo '<div class="item">';
            echo '<a href="' . $link . '">';
            echo '<img src="' . $img . '" alt="" class="slider-image" />';
            echo '</a>';
            echo '</div>';
        }
        
        echo '</div>';
        echo '</div>';
        echo '</section>';
    }
} ?>
