<?php

function couponscms_coupon_item( $item = object, $owner_view = false ) {

    $item->is_owner_view = $owner_view;

    $store_logo = store_avatar( ( !empty( $item->store_img ) ? $item->store_img : $item->image ) );

    $markup = do_action( 'before_coupon_outside', $item );

    $markup = '
    <div class="item" id="coupon-' . $item->ID . '">
        ' . do_action( 'before_coupon_inside', $item ) . '
        <div class="item-content">
            <div class="image">';
            if( $item->is_show_in_store && ( $claimed = is_coupon_claimed( $item->ID ) )  ) {
                $markup .= '<div class="qr-code">
                <img src="https://chart.googleapis.com/chart?cht=qr&chl=' . urlencode( tlink( 'user/account', 'action=check&code=' . $claimed->code ) ) . '&chs=120x120&choe=UTF-8&chld=L|2" alt="qr code" />
                </div>';
            }
            $markup .= '<img src="' . $store_logo . '" alt="' . ts( $item->store_name ) . '" class="store-logo" />
            </div>
            <div class="store-header">
                <div class="store-meta">
                    <span>' . t( 'store', 'Store' ) . '</span>
                    <a href="' . $item->store_link . '" class="store-name">' . ts( $item->store_name ) . '</a>
                </div>
            </div>
            <div class="content">';
                $desc_id = 'coupon-desc-' . $item->ID;
                // Check if coupon is claimed (for use in content area)
                $claimed = false;
                if( $item->is_show_in_store ) {
                    $claimed = is_coupon_claimed( $item->ID );
                }
                $markup .= '<div class="title"><h4>' . ts( $item->title ) . '</h4></div>
                <button type="button" class="desc-toggle button" data-desc-target="#' . $desc_id . '" data-open-text="' . t( 'theme_desc_show', 'View More' ) . '" data-close-text="' . t( 'theme_desc_hide', 'Hide Details' ) . '">' . t( 'theme_desc_show', 'View More' ) . '</button>
                <p class="date">';
                if( $item->is_expired ) {
                    $markup .= t( 'theme_expired', 'Expired' );
                } else if( !$item->is_started ) {
                    $markup .= sprintf( t( 'theme_starts', 'Starts %s' ), couponscms_dateformat( $item->start_date ) );
                } else {
                    $expiry_timestamp = strtotime( $item->expiration_date );
                    $markup .= sprintf( t( 'theme_expires', 'Expires %s' ), couponscms_dateformat( $item->expiration_date ) );
                    // Add countdown timer for active coupons
                    if( $expiry_timestamp > time() ) {
                        $markup .= '<div class="coupon-countdown" data-expiry="' . $expiry_timestamp . '">
                            <span class="countdown-label">' . t( 'theme_time_left', 'Time Left:' ) . '</span>
                            <span class="countdown-timer" id="countdown-' . $item->ID . '">
                                <span class="countdown-days"><span class="countdown-value" id="days-' . $item->ID . '">00</span><span class="countdown-label-small">D</span></span>
                                <span class="countdown-separator">:</span>
                                <span class="countdown-hours"><span class="countdown-value" id="hours-' . $item->ID . '">00</span><span class="countdown-label-small">H</span></span>
                                <span class="countdown-separator">:</span>
                                <span class="countdown-minutes"><span class="countdown-value" id="minutes-' . $item->ID . '">00</span><span class="countdown-label-small">M</span></span>
                                <span class="countdown-separator">:</span>
                                <span class="countdown-seconds"><span class="countdown-value" id="seconds-' . $item->ID . '">00</span><span class="countdown-label-small">S</span></span>
                            </span>
                        </div>';
                    }
                }
                $markup .= '</p>
                <div class="coupon-action-area">';
                // Move coupon button/code to content area (highlighted area)
                if( !$owner_view && !$item->is_expired ) {
                    if( $item->is_printable ) {
                        $markup .= '<a href="' . get_target_link( 'coupon', $item->ID ) . '" class="button">' . t( 'theme_print', 'Print It' ) . '</a>';
                    } else if( $item->is_show_in_store ) {
                        if( $claimed ) {
                            $markup .= '<a href="#" data-code="' . $claimed->code . '" class="button">' . t( 'theme_claimed_show_code', 'Show the Code' ) . '</a>';
                        } else if( $item->claim_limit == 0 || $item->claim_limit > $item->claims ) {
                            $markup .= '<a href="#" data-ajax-call="' . ajax_call_url( "claim" ) . '" data-data=\'' . json_encode( array( 'item' => $item->ID, 'claimed_message' => '<i class="fa fa-check"></i><span> ' . t( 'theme_claimed', 'Claimed !' ) ) ) . '\' data-after-ajax="coupon_claimed" data-confirmation="' . t( 'theme_claim_ask', 'Do you want to claim and use this coupon in store?' ) . '" class="button">' . t( 'theme_claim', 'Claim' ) . '</span></a>';
                        }
                    } else if( $item->is_coupon ) {
                        // If this specific coupon was already revealed, show full code
                        if( couponscms_view_store_coupons( $item->ID ) ) {
                            $markup .= '<div class="coupon-code-revealed"><i class="fas fa-scissors"></i><span>' . esc_html( $item->code ) . '</span></div>';
                        } else {
                            $ajax_url = ajax_call_url( 'reveal_coupon_code' );
                            $markup .= '<a href="' . get_target_link( 'coupon', $item->ID, array( 'reveal_code' => true, 'backTo' => base64_encode( $item->store_link ) ) ) . '" class="button show-coupon-popup" data-target-on-click="' . get_target_link( 'coupon', $item->ID ) . '" data-coupon-id="' . $item->ID . '" data-ajax-url="' . esc_attr( $ajax_url ) . '" data-reveal-code="true">' . t( 'theme_claimed_show_code', 'Show Coupon' ) . '</a>';
                        }
                    } else {
                        $markup .= '<a href="' . get_target_link( 'coupon', $item->ID ) . '" target="_blank" class="button">' . t( 'theme_get_deal', 'Get Deal' ) . '</a>';
                    }
                }
                $markup .= '</div>
                <div class="description collapsed" id="' . $desc_id . '">' . ( !empty( $item->description ) ? '<p>' . $item->description . '</p>' : t( 'theme_no_description', 'No description.' ) ) . '</div>
            </div>
        </div>
        <div class="bottom clearfix">';
            if( ( $rating = couponscms_rating( (int) $item->stars, $item->reviews ) ) ) {
                $markup .= '<a href="' . $item->store_reviews_link . '#reviews" class="rating">' . $rating . '</a>';
            }
            $markup .= '<div>
                <ul class="options">
                    <li class="share-menu-container" style="position: relative;">
                        <a href="#" class="share-coupon-btn" data-coupon-id="' . $item->ID . '" data-coupon-title="' . htmlspecialchars( ts( $item->title ) ) . '" data-coupon-url="' . htmlspecialchars( get_target_link( 'coupon', $item->ID ) ) . '"><i class="fas fa-share"></i></a>
                        <ul class="social-share-menu" style="display: block !important; visibility: visible !important; opacity: 1 !important;">';
                        // Use coupon page URL for sharing, not affiliate link
                        $share_url = get_target_link( 'coupon', $item->ID );
                        $markup .= couponscms_share_links( $share_url, ts( $item->title ) );
                        $markup .= '</ul>
                    </li>
                </ul>';
                // Coupon Usage Stats
                $stats = array();
                if( !empty( $item->views ) ) {
                    $stats[] = '<span class="coupon-stat" title="' . t( 'theme_views', 'Views' ) . '"><i class="fas fa-eye"></i> ' . number_format( $item->views ) . '</span>';
                }
                if( !empty( $item->claims ) && $item->is_show_in_store ) {
                    $stats[] = '<span class="coupon-stat" title="' . t( 'theme_claimed', 'Claimed' ) . '"><i class="fas fa-check-circle"></i> ' . number_format( $item->claims ) . '</span>';
                }
                if( !empty( $item->clicks ) ) {
                    $stats[] = '<span class="coupon-stat" title="' . t( 'theme_clicks', 'Clicks' ) . '"><i class="fas fa-mouse-pointer"></i> ' . number_format( $item->clicks ) . '</span>';
                }
                if( !empty( $stats ) ) {
                    $markup .= '<div class="coupon-usage-stats">' . implode( ' ', $stats ) . '</div>';
                }
                if( !( $owner_view || $item->is_expired ) ) {
                    $markup .= '<a href="#" data-ajax-call="' . ajax_call_url( "save" ) . '" data-data=\'' . json_encode( array( 'item' => $item->ID, 'type' => 'coupon', 'added_message' => '<i class="fa fa-star"></i>', 'removed_message' => '<i class="far fa-star"></i>' ) ) . '\'' . ( is_saved( $item->ID, 'coupon' ) ? ' class="favorite"><i class="fa fa-star"></i>' : '><i class="far fa-star"></i>' ) . '</a>';
                }
                if( $owner_view ) {
                    if( $item->is_show_in_store ) {
                        $markup .= '<a href="' . get_update( array( 'action' => 'coupon-claims', 'id' => $item->ID ) ) . '" class="button">' . sprintf( t( 'theme_claims', 'Claims (%s)' ), $item->claims ) . '</a>';
                    }
                    $markup .= '<a href="' . get_update( array( 'action' => 'edit-coupon', 'id' => $item->ID ) ) . '" class="button">' . t( 'edit', 'Edit' ) . '</a>';
                }
            $markup .= '</div>
        </div>
        ' . do_action( 'after_coupon_inside', $item ) . '
    </div>';

    $markup .= do_action( 'after_coupon_outside', $item );

    return $markup;

}

function couponscms_claims_item( $item = object ) {

    $markup = do_action( 'before_claims_item_outside', $item );

    $markup .= '<div class="item">
    <div class="info">';

    $markup .= do_action( 'before_claims_item_inside', $item );

    $markup .= '<div class="list-item-content claims-item-content">';
    $markup .= '<div class="middle">';
    $markup .= '<h3>' . ( $item->is_used ? $item->code : '***' . substr( $item->code, -3 ) ) . '</h3>';
    $markup .= '<div class="list-info">' . sprintf( t( 'theme_claims_used_state', 'Used: %s' ), ( $item->is_used ? t( 'yes', 'Yes' ) : t( 'no', 'No' ) ) ) . '</div>';
    if( $item->is_used ) {
        $markup .= '<div class="list-info">' . sprintf( t( 'theme_claims_used_date', 'Used Date: %s' ), $item->used_date ) . '</div>';
    }
    $markup .= '<div class="list-info">' . sprintf( t( 'theme_claims_claimed_date', 'Claimed Date: %s' ), $item->date ) . '</div>';
    $markup .= '</div>

    </div>';

    $markup .= do_action( 'after_reward_reqest_inside', $item );

    $markup .= '</div>
    </div>';

    $markup .= do_action( 'after_reward_reqest_outside', $item );

    return $markup;

}