<?php $item = the_item(); ?>

<script>
// Track recently viewed coupon
(function() {
    var couponId = <?php echo $item->ID; ?>;
    var couponData = {
        id: couponId,
        title: <?php echo json_encode( ts( $item->title ) ); ?>,
        url: <?php echo json_encode( get_target_link( 'coupon', $item->ID ) ); ?>,
        store: <?php echo json_encode( ts( $item->store_name ) ); ?>,
        image: <?php echo json_encode( store_avatar( ( !empty( $item->store_img ) ? $item->store_img : $item->image ) ) ); ?>,
        viewed: new Date().toISOString()
    };
    
    try {
        var viewed = JSON.parse( localStorage.getItem( 'recently_viewed_coupons' ) || '[]' );
        // Remove if already exists
        viewed = viewed.filter( function( c ) { return c.id != couponId; } );
        // Add to beginning
        viewed.unshift( couponData );
        // Keep only last 10
        viewed = viewed.slice( 0, 10 );
        localStorage.setItem( 'recently_viewed_coupons', JSON.stringify( viewed ) );
    } catch( e ) {
        console.error( 'Error saving recently viewed:', e );
    }
})();
</script>

<div class="bgWhite pt-75 pb-75 clearfix">
    <div class="container">
        <?php echo do_action( 'coupon_before_info' ); ?>

        <div class="list single-coupon-page-list clearfix">
            <?php echo couponscms_coupon_item( $item ); ?>
        </div>

        <div class="single-coupon-description mt-25">
            <h3><?php te( 'description', 'Description' ); ?></h3>
            <p><?php echo ( !empty( $item->description ) ? ts( $item->description ) : t( 'theme_no_description', 'No description.' ) ); ?></p>
        </div>

        <?php echo do_action( 'coupon_after_info' ); ?>
    </div>
</div>

<div class="bgBlack pt-50 pb-50 clearfix">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center">
            <?php echo sprintf( t( 'theme_store_share_links', '<h3>Share With Friends</h3> %s' ), couponscms_share_links( $item->link ) ); ?>
            </div>
        </div>
    </div>
</div>

<div class="pt-100 clearfix">
    <div class="container">
        <div class="title-options">
            <h2><?php te( 'theme_related_coupons', 'Related Coupons' );  ?></h2>
        </div>
    </div>
</div>

<div class="pt-100 pb-100 clearfix">
    <div class="container">
        <?php echo do_action( 'coupon_before_items' ); ?>
        <div class="items clearfix">
        <?php foreach( items_custom( array( 'show' => 'visible,active', 'orderby' => 'rand', 'max' => option( 'items_per_page' ) ) ) as $item ) {
            echo couponscms_coupon_item( $item );
        } ?>
        </div>
        <?php echo do_action( 'coupon_after_items' ); ?>
    </div>
</div>

</div>