<?php

namespace plugin\AdmitadApiPro\inc;

/** */

class client {

    private $url     = 'https://api.admitad.com/%s/';
    private $timeout = 10;
    private $client_id;
    private $client_secret;

    function __construct() {
        $this->client_id    = \query\main::get_option( 'adad_client_id' );
        $this->client_secret= \query\main::get_option( 'adad_client_secret' );
    }

    private function generateToken() {
        $ch = curl_init();
        curl_setopt( $ch, CURLOPT_URL, "https://api.admitad.com/token/" );
        $headers = array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Basic ' . base64_encode( $this->client_id . ':' . $this->client_secret )
        );

        curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_POST, true );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query(  array( 'grant_type' => 'client_credentials', 'client_id' => $this->client_id, 'scope' => 'advcampaigns_for_website coupons_for_website deeplink_generator' ) ) );
        $output = curl_exec( $ch );
        curl_close( $ch );

        return $output;
    }

    public function getToken() {
        $generated  = $this->generateToken();

        $g_json     = json_decode( $generated );
        if( isset( $g_json->access_token ) ) {
            return $g_json->access_token;
        }
        return false;
    }

    public function updateToken() {
        $token = $this->getToken();
        if( $token ) {
            \admin\actions::set_option( array( 'adad_token' => $token ) );
        }
    }

    public function Token() {
        return \query\main::get_option( 'adad_token' );
    }

    public function getPrograms( $params = array() ) {
        return $this->Api( 'advcampaigns/website/' . \query\main::get_option( 'adad_website' ), array_merge( $params, array( 'language' => \query\main::get_option( 'adad_lang' ) ) ) );
    }

    public function getCoupons( $params = array() ) {
        return $this->Api( 'coupons/website/' . \query\main::get_option( 'adad_website' ), array_merge( $params, array( 'language' => \query\main::get_option( 'adad_lang' ) ) ) );
    }

    public function getDeepLink( $program_id = '', $url = '', $subid = '', $params = array() ) {
        return $this->Api( 'deeplink/' . \query\main::get_option( 'adad_website' ) . '/advcampaign/' . $program_id, array_merge( $params, array( 'ulp' => $url, 'subid' => $subid ) ) );
    }

    public function Api( $resource, $params, $method = 'GET', $invalid_token = false ) {
        if( empty( $this->client_id ) && empty( $this->client_secret ) ) {
            throw new \Exception( 'Missing Client ID or Client Secret, check your <a href="?plugin=AdmitadApiPro/options.php">settings</a> and try again.' );
        }

        $ch = curl_init();

        curl_setopt( $ch, CURLOPT_URL, sprintf( $this->url, $resource ) . ( !empty( $params ) && $method == 'GET' ? '?' . http_build_query( $params, '', '&' ) : '' ) );

        $headers = array(
            'Content-Type: application/x-www-form-urlencoded',
            'Authorization: Bearer ' . $this->Token()
        );

        curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, $this->timeout );
        $a = curl_getinfo( $ch, CURLINFO_HTTP_CODE );

        $output = curl_exec( $ch );
        curl_close( $ch );

        if( empty( $output ) ) {
            throw new \Exception( 'Unexpected.' );
        }

        $array = json_decode( $output, true );

        if( isset( $array['error'] ) && $array['error'] == 'invalid_token' ) {

            if( $invalid_token ) {
                throw new \Exception( 'Invalid token / token cannot be generated. Error: ' . $array['error_description'] );
            }

            $this->updateToken();

            return $this->Api( $resource, $params, $method, true );

        }

        if( !$array ) {
            throw new \Exception( $output );
        }

        return $array;
    }

}