<?php

namespace plugin\AdmitadApiPro\inc;

/** */

class markup {

    public static function get_categories( $categories = array() ) {
        if( !empty( $categories ) ) {
            $markup = 'Category: <b>';
            foreach( $categories as $i =>  $cat ) {
                $markup .= $cat['name'];
                if( count( $categories ) > ( $i + 1 ) ) {
                    $markup .= ', ';
                }
            }
            $markup .= '</b><br />';

            return $markup;
        }
    }

    public static function pagination( $pages ) {
        $p      = array();
        $page   = isset( $_GET['page'] ) ? (int) $_GET['page'] : 1;

        if( $page > $pages ) {
            $page = $pages;
        }

        if( $pages > 1 ) {
            if( $page > 1 ) {
                $p['prev_page'] = \site\utils::update_uri( '', array( 'page' => ($page-1) ) );
            }

            if( $page < $pages ) {
                $p['next_page'] = \site\utils::update_uri( '', array( 'page' => ($page+1) ) );
            }
        }

        if( isset( $p['prev_page'] ) || isset( $p['next_page'] ) ) {
            echo '<div class="pagination">';

            if( isset( $p['prev_page'] ) ) echo '<a href="' . $p['prev_page'] . '" class="btn">&larr; Prev</a>';
            if( isset( $p['next_page'] ) ) echo '<a href="' . $p['next_page'] . '" class="btn">Next &rarr;</a>';

            if( $pages > 1 ) {
                echo '<div class="pag_goto">' . sprintf( "Page <b>%s</b> of <b>%s</b>", number_format( $page ), number_format( (int) $pages ) ) . '
                <form action="#" method="GET">';
                foreach( $_GET as $gk => $gv ) if( $gk !== 'page' ) echo '<input type="hidden" name="' . esc_html( $gk ) . '" value="' . esc_html( $gv ) . '" />';
                echo '<input type="number" name="page" min="1" max="' . $pages . '" size="5" value="' . $page . '" />
                <button class="btn">Go</button>
                </form>
                </div>';
            }

            echo '</div>';
        }
    }

}