<?php

$types = [];
$types['recently']      = array( 'label' => t( 'theme_coupons_recently_added', 'Recently Added' ),  'url' => get_remove( array( 'page', 'type' ) ),                                                 'orderby' => 'date desc',   'show' => '',           'limit' => 100 );
$types['expiring']      = array( 'label' => t( 'theme_coupons_expiring_soon', 'Expiring Soon' ),    'url' => get_update( array( 'type' => 'expiring' ), get_remove( array( 'page', 'type' ) ) ),    'orderby' => 'expiration',  'show' => '',           'limit' => 100 );
$types['printable']     = array( 'label' => t( 'theme_coupons_printable', 'Printable' ),            'url' => get_update( array( 'type' => 'printable' ), get_remove( array( 'page', 'type' ) ) ),   'orderby' => '',            'show' => 'printable',  'limit' => 100 );
$types['codes']         = array( 'label' => t( 'theme_coupons_codes', 'Coupon Codes' ),             'url' => get_update( array( 'type' => 'codes' ), get_remove( array( 'page', 'type' ) ) ),       'orderby' => '',            'show' => 'codes',      'limit' => 100 );
$types['exclusive']     = array( 'label' => t( 'theme_coupons_exclusive', 'Exclusive' ),            'url' => get_update( array( 'type' => 'exclusive' ), get_remove( array( 'page', 'type' ) ) ),   'orderby' => '',            'show' => 'exclusive',  'limit' => 100 );
$types['popular']       = array( 'label' => t( 'theme_coupons_popular', 'Popular' ),                'url' => get_update( array( 'type' => 'popular' ), get_remove( array( 'page', 'type' ) ) ),     'orderby' => '',            'show' => 'popular',    'limit' => 100 );
$types['verified']      = array( 'label' => t( 'theme_coupons_verified', 'Verified' ),              'url' => get_update( array( 'type' => 'verified' ), get_remove( array( 'page', 'type' ) ) ),    'orderby' => '',            'show' => 'verified',   'limit' => 100 );

$type = isset( $_GET['type'] ) && in_array( $_GET['type'], array_keys( $types ) ) ? $_GET['type'] : 'recently';

$atts = [];
$atts['show'] = $types[$type]['show'];
$atts['limit'] = $types[$type]['limit'];

$type_orderby = $types[$type]['orderby'];

if( empty( $type_orderby ) ) {

    $orderby = [ 'newest' => 'date desc', 'oldest' => 'date' ];
    $default_orderby = 'newest';

    if( isset( $_GET['orderby'] ) && in_array( $_GET['orderby'], array_keys( $orderby ) ) ) {
        $default_orderby = $_GET['orderby'];
    }

    $types[$type]['orderby'] = $orderby[$default_orderby];

}

$active = [ 1, '<i class="far fa-circle"></i>'];

if( !empty( $_GET['active'] ) ) {
    $active = [ 0, '<i class="fas fa-check-circle"></i>' ];
    $atts['show'] = $atts['show'] . ',active';
}

$pagination = have_items_custom( $atts ); ?>

<div class="bgGray">
    <div class="hero-title">
        <div class="container">
            <h2><?php te( 'coupons', 'Coupons' ); ?></h2>
        </div>
    </div>
</div>

<div class="pt-50 pb-50 hr-bottom clearfix">
    <div class="container">
        <div class="list3 owl-carousel clearfix">
            <?php foreach( categories_custom( [ 'show' => 'cats', 'max' => 0 ] ) as $cat ) { ?>
            <div class="item">
                <div class="icon">
                    <?php echo couponscms_category_icon( $cat ); ?>
                </div>
                <div class="bottom clearfix">
                    <div class="title">
                        <a href="<?php echo $cat->link; ?>"><?php echo $cat->name; ?></a>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="bgGray pt-75 pb-75 clearfix">
    <div class="container">
        <div class="mb-40 clearfix">
            <ul class="options float-left">
                <li class="contains-sub-menu pb-10"><a href="#"><?php echo $types[$type]['label']; ?> <i class="fa fa-angle-down"></i></a>
                    <ul>
                        <?php foreach( $types as $cur_type => $type2 ) {
                            echo '<li' . ( $cur_type == $type ? ' class="active"' : '' ) . '><a href="' . $type2['url'] . '">' . $type2['label'] . '</a></li>';
                        } ?>
                    </ul>
                </li>
            </ul>
            <a href="<?php echo get_update( [ 'active' => $active[0] ], get_remove( [ 'page' ] ) ); ?>" class="float-right"><?php echo $active[1] . ' ' . t( 'theme_active_only', 'Active only' ); ?></a>
        </div>
        <div class="list clearfix">
            <?php if( $pagination['results'] ) {
                foreach( items_custom( ( array( 'orderby' => $types[$type]['orderby'] ) + $atts ) ) as $item ) {
                    echo couponscms_coupon_item( $item );
                }
            } else echo '<div class="alert">' . t( 'theme_no_coupons_list',  'Huh :( No coupons found here.' ) . '</div>'; ?>
        </div>
        <?php echo couponscms_theme_pagination( $pagination ); ?>
    </div>
</div>