<?php

/* DEFINE CONSTANTS */
define( 'THEME_LOCATION', theme_location() );
define( 'COUPONSCMS_CORE_LOCATION', theme_location2() . '/core' );

/* REQUIRED PARTS AND FUNCTIONS */
require_once 'core/theme_options.php';
require_once 'core/shortcodes.php';
require_once 'core/functions.php';
require_once 'core/campaigns.php';
require_once 'extend/store.php';
require_once 'extend/product.php';
require_once 'extend/coupon.php';
require_once 'extend/review.php';
require_once 'extend/reward.php';
require_once 'extend/plans.php';
require_once 'extend/pagination.php';
require_once 'extend/menu.php';
require_once 'extras/banner_advertising.php';

/* ADD THEME STYLES */
add( 'styles', THEME_LOCATION . '/assets/css/bootstrap.min.css',        [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/assets/css/fontawesome-all.min.css',  [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/assets/css/fontawesome-fix.php',      [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/style.css',                           [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/assets/css/couponscms.css',           [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/assets/css/responsive.css',           [ 'media' => 'all', 'rel' => 'stylesheet' ] );
add( 'styles', THEME_LOCATION . '/assets/css/owl.carousel.min.css',     [ 'media' => 'all', 'rel' => 'stylesheet' ] );
// Manrope font from Google Fonts
add( 'styles', '//fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&display=swap',   [ 'rel' => 'stylesheet' ] );

// Preconnects (reduces font + CDN connection latency)
add( 'in-head', '<link rel="preconnect" href="https://fonts.googleapis.com" />' );
add( 'in-head', '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />' );
add( 'in-head', '<link rel="preconnect" href="https://ajax.googleapis.com" />' );
add( 'in-head', '<link rel="dns-prefetch" href="//ajax.googleapis.com" />' );

/* ADD THEME SCRIPTS (defer to reduce render-blocking) */
add( 'scripts', 'https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js', [ 'defer' => 'defer' ] );
add( 'scripts', '<script>window.jQuery || document.write(\'<script defer src="' . site_url( 'assets/js/jquery.3.7.1.min.js') . '"><\\/script>\')</script>' );
add( 'scripts', THEME_LOCATION . '/assets/js/functions.js', [ 'defer' => 'defer' ] );
add( 'scripts', THEME_LOCATION . '/assets/js/ajax.js', [ 'defer' => 'defer' ] );
add( 'scripts', THEME_LOCATION . '/assets/js/owl.carousel.min.js', [ 'defer' => 'defer' ] );

/* ADD ONESIGNAL SDK */
$onesignal_app_id = \query\main::get_option( 'onesignal_app_id' );
if( !empty( $onesignal_app_id ) ) {
    add( 'in-head', '<link rel="preconnect" href="https://cdn.onesignal.com" />' );
    add( 'scripts', 'https://cdn.onesignal.com/sdks/web/v16/OneSignalSDK.page.js', [ 'defer' => 'defer' ] );
}

/* USE OR DON'T USE REWARDS */
function theme_has_rewards() {
    return true;
}

/* LANGUAGES LOCATION */
function theme_languages_location() {
    return 'languages';
}

/* ADD THEME MENUS */
add( 'menu', 'main', 'theme_menu' );
add( 'menu', 'footer_company', 'theme_footer_company_menu' );

/* BUILD SITE'S MENU */
function theme_menu() {
    $links = [];

    $links['home'] = [ 'type' => 'home', 'name' => t( 'theme_home', 'Home' ) ];

    $links['coupons'] = [ 'name' => t( 'theme_nav_coupons', 'Coupons' ), 'url' => '#' ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_recently_added', 'Recently Added' ), 'url' => tlink( 'tpage/coupons', 'type=recent' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_expiring_soon', 'Expiring Soon' ), 'url' => tlink( 'tpage/coupons', 'type=expiring' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_printable', 'Printable' ), 'url' => tlink( 'tpage/coupons', 'type=printable' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_codes', 'Coupon Codes' ), 'url' => tlink( 'tpage/coupons', 'type=codes' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_exclusive', 'Exclusive' ), 'url' => tlink( 'tpage/coupons', 'type=exclusive' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_popular', 'Popular' ), 'url' => tlink( 'tpage/coupons', 'type=popular' ) ];
    $links['coupons']['links'][] = [ 'name' => t( 'theme_coupons_verified', 'Verified' ), 'url' => tlink( 'tpage/coupons', 'type=verified' ) ];

    $links['stores'] = [ 'name' => t( 'theme_nav_stores', 'Stores' ), 'url' => tlink( 'stores' ) ];
    $links['stores']['links'][] = [ 'name' => t( 'theme_all_stores', 'All Stores' ), 'url' => tlink( 'stores' ) ];
    $links['stores']['links'][] = [ 'name' => t( 'theme_top_stores', 'Top Stores' ), 'url' => tlink( 'stores', 'type=top' ) ];
    $links['stores']['links'][] = [ 'name' => t( 'theme_most_voted', 'Most Voted' ), 'url' => tlink( 'stores', 'type=most-voted' ) ];
    $links['stores']['links'][] = [ 'name' => t( 'theme_popular', 'Popular' ), 'url' => tlink( 'stores', 'type=popular' ) ];

    $links['more'] = [ 'name' => t( 'theme_more', 'More' ), 'url' => '#' ];

    if( couponscms_has_products() ) {
        $products = [ 'name' => t( 'theme_nav_products', 'Products' ), 'url' => '#' ];
        $products['links'][] = [ 'name' => t( 'theme_products_recently_added', 'Recently Added' ), 'url' => tlink( 'tpage/products', 'type=recent' ) ];
        $products['links'][] = [ 'name' => t( 'theme_products_expiring_soon', 'Expiring Soon' ), 'url' => tlink( 'tpage/products', 'type=expiring' ) ];
        $products['links'][] = [ 'name' => t( 'theme_products_popular', 'Popular' ), 'url' => tlink( 'tpage/products', 'type=popular' ) ];
        $links['more']['links'][] = $products;
    }

    $categories = [ 'name' => t( 'theme_nav_categories', 'Categories' ), 'type' => 'categories', 'url' => '#' ];

    $links['more']['links'][] = $categories;

    return $links;
}

function theme_footer_company_menu() {

    $links = [];

    $links['home'] = [ 'type' => 'home', 'name' => t( 'theme_home', 'Home' ) ];

    return $links;

}

/* AJAX SEARCH - Only Categories and Stores */

add( 'ajax-call', 'slick_ajax_search', function() {
    $text = !empty( $_POST['text'] ) ? $_POST['text'] : '';
    if( strlen( $text ) < 2 ) return ;

    // Only search categories and stores - simple AJAX search
    $categories = $stores = [];

    // Search categories
    foreach( categories_custom( ['search' => $text, 'max' => 5] ) as $category ) {
        $categories[] = '<li class="search-category-item"><a href="' . $category->link . '"><i class="fas fa-folder"></i> <span>' . ts( $category->name ) . '</span></a></li>';
    }

    // Search stores
    foreach( stores_custom( ['search' => $text, 'max' => 5] ) as $store ) {
        // Always show logo - store_avatar() handles empty images with default
        $logo_src = store_avatar( !empty( $store->image ) ? $store->image : '' );
        $logo = '<span class="search-store-logo"><img src="' . esc_html( $logo_src ) . '" alt="' . ts( $store->name ) . '" /></span>';
        $stores[] = '<li class="search-store-item"><a href="' . $store->link . '">' . $logo . '<span class="search-store-name">' . ts( $store->name ) . '</span></a></li>';
    }

    if( !empty( $categories ) ) {
        echo '<h6>' . t( 'categories', 'Categories' ) . '</h6>';
        echo '<ul>' . implode( "\n", $categories ) . '</ul>';
    }
    if( !empty( $stores ) ) {
        echo '<h6>' . t( 'stores', 'Stores' ) . '</h6>';
        echo '<ul>' . implode( "\n", $stores ) . '</ul>';
    }
});

/* AJAX call to import image from URL */
add( 'ajax-call', 'import_campaign_image', function() {
    $image_url = !empty( $_POST['image_url'] ) ? trim( $_POST['image_url'] ) : '';
    
    if( empty( $image_url ) || !filter_var( $image_url, FILTER_VALIDATE_URL ) ) {
        echo json_encode( ['success' => false, 'message' => 'Invalid image URL'] );
        return;
    }
    
    // Get file extension
    $url_parts = parse_url( $image_url );
    $path_parts = pathinfo( $url_parts['path'] );
    $extension = !empty( $path_parts['extension'] ) ? strtolower( $path_parts['extension'] ) : 'jpg';
    
    // Allowed extensions
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    if( !in_array( $extension, $allowed_extensions ) ) {
        $extension = 'jpg'; // Default to jpg if extension not recognized
    }
    
    // Create upload directory if it doesn't exist
    $upload_dir = 'content/uploads/campaigns/';
    if( !file_exists( $upload_dir ) ) {
        @mkdir( $upload_dir, 0755, true );
    }
    
    // Generate unique filename
    $filename = 'campaign_' . time() . '_' . uniqid() . '.' . $extension;
    $file_path = $upload_dir . $filename;
    
    // Download image
    $image_data = @file_get_contents( $image_url );
    if( $image_data === false ) {
        echo json_encode( ['success' => false, 'message' => 'Failed to download image'] );
        return;
    }
    
    // Save image
    if( @file_put_contents( $file_path, $image_data ) === false ) {
        echo json_encode( ['success' => false, 'message' => 'Failed to save image'] );
        return;
    }
    
    // Return relative path
    $relative_path = $upload_dir . $filename;
    
    echo json_encode( [
        'success' => true,
        'path' => $relative_path,
        'url' => site_url( $relative_path ),
        'message' => 'Image imported successfully'
    ] );
});

/* AJAX call to reveal coupon code */
add( 'ajax-call', 'reveal_coupon_code', function() {
    $coupon_id = !empty( $_POST['coupon_id'] ) ? (int) $_POST['coupon_id'] : 0;
    if( $coupon_id <= 0 ) {
        echo json_encode( ['success' => false, 'message' => 'Invalid coupon ID'] );
        return;
    }
    
    $item = \query\main::item_info( $coupon_id );
    if( !$item || !$item->is_coupon ) {
        echo json_encode( ['success' => false, 'message' => 'Coupon not found'] );
        return;
    }
    
    // Set session to reveal code for THIS COUPON only
    if( !isset( $_SESSION['couponscms_rc'] ) ) {
        $_SESSION['couponscms_rc'] = [];
    }
    if( !in_array( $coupon_id, $_SESSION['couponscms_rc'] ) ) {
        $_SESSION['couponscms_rc'][] = $coupon_id;
    }
    
    // Get store info
    $store = \query\main::store_info( $item->storeID );
    $store_logo = store_avatar( ( !empty( $store->image ) ? $store->image : '' ) );
    
    // Get affiliate URL
    $affiliate_url = get_target_link( 'coupon', $coupon_id );
    
    // Get share link
    $share_link = $item->link;
    
    echo json_encode( [
        'success' => true,
        'code' => $item->code,
        'affiliate_url' => $affiliate_url,
        'title' => ts( $item->title ),
        'store_name' => ts( $item->store_name ),
        'store_logo' => $store_logo,
        'share_link' => $share_link,
        'description' => !empty( $item->description ) ? ts( $item->description ) : ''
    ] );
});

/* AJAX call to follow/unfollow store */
add( 'ajax-call', 'follow_store', function() {
    $store_id = !empty( $_POST['store_id'] ) ? (int) $_POST['store_id'] : 0;
    $action = !empty( $_POST['action'] ) ? $_POST['action'] : 'toggle';
    
    if( $store_id <= 0 ) {
        echo json_encode( ['state' => 'error', 'message' => 'Invalid store ID'] );
        return;
    }
    
    if( !$GLOBALS['me'] ) {
        echo json_encode( ['state' => 'error', 'message' => 'Please login to follow stores'] );
        return;
    }
    
    global $db;
    
    // Check if store exists
    $store = \query\main::store_info( $store_id );
    if( !$store ) {
        echo json_encode( ['state' => 'error', 'message' => 'Store not found'] );
        return;
    }
    
    // Check if table exists
    $table_check = $db->query( "SHOW TABLES LIKE '" . DB_TABLE_PREFIX . "store_follows'" );
    if( $table_check->num_rows == 0 ) {
        echo json_encode( ['state' => 'error', 'message' => 'Store follow feature is not available'] );
        return;
    }
    
    // Check if already following
    $stmt = $db->stmt_init();
    if( !$stmt->prepare( "SELECT id FROM " . DB_TABLE_PREFIX . "store_follows WHERE user = ? AND store = ?" ) ) {
        echo json_encode( ['state' => 'error', 'message' => 'Database error'] );
        return;
    }
    $stmt->bind_param( "ii", $GLOBALS['me']->ID, $store_id );
    $stmt->execute();
    $stmt->bind_result( $follow_id );
    $is_following = $stmt->fetch();
    $stmt->close();
    
    if( $is_following ) {
        // Unfollow
        $stmt = $db->stmt_init();
        if( !$stmt->prepare( "DELETE FROM " . DB_TABLE_PREFIX . "store_follows WHERE user = ? AND store = ?" ) ) {
            echo json_encode( ['state' => 'error', 'message' => 'Database error'] );
            return;
        }
        $stmt->bind_param( "ii", $GLOBALS['me']->ID, $store_id );
        $stmt->execute();
        $stmt->close();
        
        echo json_encode( [
            'state' => 'success',
            'message' => t( 'theme_unfollowed_store', 'Unfollowed store' ),
            'followed' => false,
            'button_text' => t( 'theme_follow_store', 'Follow Store' ),
            'button_icon' => 'fa-bell-slash',
            'button_title' => t( 'theme_follow_store', 'Follow Store' )
        ] );
    } else {
        // Follow
        $stmt = $db->stmt_init();
        if( !$stmt->prepare( "INSERT INTO " . DB_TABLE_PREFIX . "store_follows (user, store, date) VALUES (?, ?, NOW())" ) ) {
            echo json_encode( ['state' => 'error', 'message' => 'Database error'] );
            return;
        }
        $stmt->bind_param( "ii", $GLOBALS['me']->ID, $store_id );
        $stmt->execute();
        $stmt->close();
        
        echo json_encode( [
            'state' => 'success',
            'message' => t( 'theme_followed_store', 'Now following store. You will receive email notifications for new coupons.' ),
            'followed' => true,
            'button_text' => t( 'theme_unfollow_store', 'Unfollow' ),
            'button_icon' => 'fa-bell',
            'button_title' => t( 'theme_unfollow_store', 'Unfollow' )
        ] );
    }
});

/* Check if user is following a store */
function is_store_followed( $store_id ) {
    if( !$GLOBALS['me'] ) {
        return false;
    }
    
    global $db;
    
    // Check if table exists first
    $table_check = $db->query( "SHOW TABLES LIKE '" . DB_TABLE_PREFIX . "store_follows'" );
    if( $table_check->num_rows == 0 ) {
        // Table doesn't exist, return false
        return false;
    }
    
    $stmt = $db->stmt_init();
    if( !$stmt->prepare( "SELECT COUNT(*) FROM " . DB_TABLE_PREFIX . "store_follows WHERE user = ? AND store = ?" ) ) {
        return false;
    }
    
    $stmt->bind_param( "ii", $GLOBALS['me']->ID, $store_id );
    $stmt->execute();
    $stmt->bind_result( $count );
    $stmt->fetch();
    $stmt->close();
    
    return $count > 0;
}

/* APPLY OPTIONS */
if( ( $search_box_bg = get_theme_option( 'search_image' ) ) && !empty( $search_box_bg ) ) {
    if( !filter_var( $search_box_bg, FILTER_VALIDATE_URL ) ) {
        $search_box_gallery = @json_decode( $search_box_bg ); 
        if( $search_box_gallery ) {
            $search_box_bg = current( $search_box_gallery );
        }
    }
    add( 'inline-style', '.search-container:not(.fixed-popup)::after {background-image:url("' . $search_box_bg . '")}' );
}

/* ADD EXTRA CSS */
add( 'in-head', add_extra_css() );

function add_extra_css() {
    if( ( $ecss = get_theme_option( 'extra_css' ) ) ) {
        return "<style>\n" . $ecss . "\n</style>";
    }
}

/* ADD EXTRA JS */
add( 'in-head', add_extra_js() );

function add_extra_js() {
    if( ( $ejs = get_theme_option( 'extra_js' ) ) ) {
        return "<script>" . $ejs . "\n</script>";
    }
}

/* BANNER ADVERISING PLUGIN */
add( 'action', 'banner-advertising-page', 'banner_advertising_order_page' );

/* CATEGORY EXTRA FIELDS */
add( 'category-fields', [ 'position' => 3.1, 'fields' => [ 
    'icon' => [ 'type' => 'text', 'title' => t( 'theme_category_input_icon', 'Icon', true ), 'info' => t( 'theme_category_input_icon_info', 'Font-awesome icons (e.g., fas fa-list-ul) or Flaticon class (e.g., flaticon-shopping-cart). Leave empty if using custom icon image below.', true ) ],
    'icon_image' => [ 
        'type' => 'callback', 
        'title' => t( 'theme_category_input_icon_image', 'Custom Icon Image', true ), 
        'info' => t( 'theme_category_input_icon_image_info', 'Upload a custom icon image from your computer, or enter an image URL (supports Flaticon, Iconfinder, etc.). If set, this will be used instead of FontAwesome icon.', true ),
        'callback' => function( $item, $value, $post_name ) {
            $current_image = '';
            if( !empty( $item ) && isset( $item->extra['icon_image'] ) ) {
                $current_image = $item->extra['icon_image'];
            } else if( isset( $value['icon_image'] ) ) {
                $current_image = $value['icon_image'];
            }
            
            $markup = '<div class="row image-upload">';
            if( !empty( $current_image ) ) {
                $img_src = ( preg_match( '/^http(s)?/i', $current_image ) ? $current_image : '../' . $current_image );
                $markup .= '<div style="display:table;margin-bottom:15px;"><img src="' . $img_src . '" class="avt" alt="" style="display:table-cell;vertical-align:middle;max-width:80px;height:80px;margin:0 20px 5px 0;border:1px solid #ddd;padding:5px;background:#fff;" />';
                $markup .= '<div style="display:table-cell;vertical-align:middle;margin-left:25px;">';
                $markup .= '<a href="' . $img_src . '" target="_blank" class="btn" style="margin-right:5px;">' . t( 'view', "View" ) . '</a>';
                $markup .= '<a href="#" class="btn remove-icon-image" style="background:#dc3545;color:#fff;">' . t( 'delete', "Remove" ) . '</a>';
                $markup .= '</div></div>';
            }
            
            // Tabs for different input methods
            $markup .= '<div style="margin-bottom:15px;">';
            $markup .= '<div style="display:flex;gap:10px;margin-bottom:10px;border-bottom:2px solid #ddd;">';
            $markup .= '<a href="#" class="icon-upload-tab active" data-tab="upload" style="padding:8px 15px;background:#f5f5f5;text-decoration:none;border-bottom:2px solid transparent;margin-bottom:-2px;">' . t( 'form_upload_file', "Upload File" ) . '</a>';
            $markup .= '<a href="#" class="icon-upload-tab" data-tab="url" style="padding:8px 15px;background:#f5f5f5;text-decoration:none;border-bottom:2px solid transparent;margin-bottom:-2px;">' . t( 'theme_icon_from_url', "From URL" ) . '</a>';
            $markup .= '</div>';
            
            // Upload tab
            $markup .= '<div class="icon-upload-content" id="icon-upload-tab-upload" style="display:block;">';
            $markup .= '<input type="file" name="category_icon_image" accept="image/*" style="margin-bottom:10px;" />';
            $markup .= '<p style="font-size:12px;color:#666;margin:5px 0;">' . t( 'theme_icon_upload_info', 'Upload an icon image from your computer (PNG, JPG, SVG, etc.)' ) . '</p>';
            $markup .= '</div>';
            
            // URL tab
            $markup .= '<div class="icon-upload-content" id="icon-upload-tab-url" style="display:none;">';
            $markup .= '<input type="text" name="category_icon_image_url" id="category_icon_image_url" value="' . ( preg_match( '/^http(s)?/i', $current_image ) ? esc_html( $current_image ) : '' ) . '" placeholder="https://cdn-icons-png.flaticon.com/512/1234/1234567.png" style="width:100%;padding:8px;margin-bottom:10px;border:1px solid #ddd;" />';
            $markup .= '<button type="button" class="btn import-icon-from-url" style="margin-bottom:10px;">' . t( 'theme_import_icon', "Import Icon from URL" ) . '</button>';
            $markup .= '<div id="icon-url-preview" style="margin-top:10px;display:none;"><img src="" alt="" style="max-width:80px;max-height:80px;border:1px solid #ddd;padding:5px;background:#fff;" /></div>';
            $markup .= '<p style="font-size:12px;color:#666;margin:5px 0;">' . t( 'theme_icon_url_info', 'Enter an image URL from Flaticon, Iconfinder, or any image hosting service. The image will be downloaded and saved to your server.' ) . '</p>';
            $markup .= '</div>';
            
            $markup .= '</div>';
            $markup .= '<input type="hidden" name="' . $post_name . '[icon_image]" id="category_icon_image_value" value="' . esc_html( $current_image ) . '" />';
            
            // JavaScript for tab switching and URL import
            $markup .= '<script>
            (function() {
                // Tab switching
                var tabs = document.querySelectorAll(".icon-upload-tab");
                var contents = document.querySelectorAll(".icon-upload-content");
                tabs.forEach(function(tab) {
                    tab.addEventListener("click", function(e) {
                        e.preventDefault();
                        var targetTab = this.getAttribute("data-tab");
                        tabs.forEach(function(t) { t.classList.remove("active"); });
                        contents.forEach(function(c) { c.style.display = "none"; });
                        this.classList.add("active");
                        document.getElementById("icon-upload-tab-" + targetTab).style.display = "block";
                    });
                });
                
                // Remove icon
                var removeBtn = document.querySelector(".remove-icon-image");
                if(removeBtn) {
                    removeBtn.addEventListener("click", function(e) {
                        e.preventDefault();
                        if(confirm("' . t( 'delete_msg', "Are you sure that you want to delete this?" ) . '")) {
                            document.getElementById("category_icon_image_value").value = "";
                            this.closest(".row").querySelector("img").src = "";
                            this.closest("div[style*=\"display:table\"]").style.display = "none";
                        }
                    });
                }
                
                // Import from URL
                var importBtn = document.querySelector(".import-icon-from-url");
                if(importBtn) {
                    importBtn.addEventListener("click", function(e) {
                        e.preventDefault();
                        var url = document.getElementById("category_icon_image_url").value.trim();
                        if(!url) {
                            alert("' . t( 'theme_please_enter_url', "Please enter an image URL" ) . '");
                            return;
                        }
                        if(!url.match(/^https?:\/\/.+/i)) {
                            alert("' . t( 'theme_invalid_url', "Please enter a valid URL starting with http:// or https://" ) . '");
                            return;
                        }
                        
                        // Show preview
                        var preview = document.getElementById("icon-url-preview");
                        var previewImg = preview.querySelector("img");
                        previewImg.src = url;
                        preview.style.display = "block";
                        
                        // Set the value
                        document.getElementById("category_icon_image_value").value = url;
                        
                        // Show success message
                        alert("' . t( 'theme_icon_url_set', "Icon URL set successfully! Click Save to apply." ) . '");
                    });
                }
            })();
            </script>';
            
            $markup .= '</div>';
            return $markup;
        }
    ]
] ] );