(function() {
    "use strict";
    
    // Wait for jQuery to be available
    function initAjax() {
        if (typeof jQuery === 'undefined') {
            setTimeout(initAjax, 50);
            return;
        }
        
        var $ = jQuery;
        
        $( document ).ready(function() {

    $(document).on( 'click', '[data-ajax-call]:not(.disabled)', function(e) {
        e.preventDefault();
        var t = $(this);
        var url = t.data( 'ajax-call' ),
        data = t.data( 'data' );

        if( t.data( 'confirmation' ) == undefined || confirm( t.data( 'confirmation' ) ) ) {
            $.post( url, data, function( result ) {
                if( t.data( 'after-ajax' ) != undefined ) {
                    switch( t.data( 'after-ajax' ) ) {
                        case 'ajax_voted':
                            if( result.state != 'success' ) {
                                // alert( result.message );
                                window.location = login_page;
                            } else {
                                var votes_form = t.parents( '.vote-form' );
                                votes_form.after( '<li><span class="ajax-message"><strong>' + t.data( 'message' ) + '</strong></span></li>' );
                                votes_form.remove();
                                $('.tooltip').remove();
                            }
                        break;
                        case 'coupon_claimed':
                            if( result.state == 'success' ) {
                                t.addClass( 'disabled' );
                                t.html( result.message );
                            } else {
                                // alert( result.message );
                                window.location = login_page;
                            }
                        break;
                    }
                } else {
                    if( result.state != 'success' ) {
                        // Check if it's a login required error
                        if( result.message && ( result.message.indexOf('login') !== -1 || result.message.indexOf('Login') !== -1 ) ) {
                            // Redirect to login with return URL
                            var currentUrl = window.location.href;
                            window.location = login_page + ( login_page.indexOf('?') !== -1 ? '&' : '?' ) + 'redirect=' + encodeURIComponent(currentUrl);
                        } else {
                            // Show error message
                            showToast( result.message || 'An error occurred', 'error' );
                        }
                    } else {
                        // Handle store follow button specially (floating, icon, and notification bell versions)
                        if( t.hasClass( 'store-follow-btn-floating' ) || t.hasClass( 'store-follow-btn-icon' ) || t.hasClass( 'store-notification-bell' ) ) {
                            // Update icon and data attribute
                            var iconClass = 'fas fa-bell' + ( result.followed ? '' : '-slash' );
                            var iconElement = t.find('i');
                            if( iconElement.length ) {
                                iconElement.attr('class', iconClass);
                            } else {
                                // If no icon element, create one
                                t.html('<i class="' + iconClass + '"></i>');
                            }
                            // Update data attribute
                            t.attr('data-followed', result.followed ? '1' : '0');
                            // Update CSS class for styling
                            if( result.followed ) {
                                t.addClass('followed');
                            } else {
                                t.removeClass('followed');
                            }
                            // Update title/tooltip
                            if( result.button_title ) {
                                t.attr('title', result.button_title );
                            }
                            // Show success notification message
                            if( result.message ) {
                                showToast( result.message, 'success' );
                            }
                        } else {
                            t.html( result.message );
                        }
                    }
                }
            }, "json" ).fail(function(xhr, status, error) {
                // Handle AJAX errors
                console.error('AJAX Error:', status, error);
                if( xhr.status === 401 || xhr.status === 403 ) {
                    // Unauthorized - redirect to login
                    var currentUrl = window.location.href;
                    window.location = login_page + ( login_page.indexOf('?') !== -1 ? '&' : '?' ) + 'redirect=' + encodeURIComponent(currentUrl);
                } else {
                    showToast( 'An error occurred. Please try again.', 'error' );
                }
            });
        }
    });

        });
    }
    
    // Toast notification function
    function showToast(message, type) {
        type = type || 'info';
        var toast = $('<div class="toast-notification toast-' + type + '">' + message + '</div>');
        $('body').append(toast);
        
        // Animate in
        setTimeout(function() {
            toast.addClass('show');
        }, 10);
        
        // Remove after 3 seconds
        setTimeout(function() {
            toast.removeClass('show');
            setTimeout(function() {
                toast.remove();
            }, 300);
        }, 3000);
    }
    
    // Make showToast available globally
    window.showToast = showToast;
    
    // Start initialization
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initAjax);
    } else {
        initAjax();
    }
})();