<?php
// 404 Error Page
http_response_code(404);

require './config.php';
require './functions.php';

$connect = connect($database);

// Get page title and meta data
$page_title = "Page Not Found - 404";
$page_description = "The page you are looking for could not be found.";
$page_keywords = "404, page not found, error";

// Include header
require './sections/header.php';
?>

<div class="uk-container uk-margin-large-top uk-margin-large-bottom">
    <div class="uk-text-center">
        <div class="uk-card uk-card-default uk-card-body uk-padding-large">
            <div class="uk-margin-large-bottom">
                <h1 class="uk-heading-large uk-text-bold uk-text-primary">404</h1>
                <h2 class="uk-heading-medium uk-margin-remove-top">Page Not Found</h2>
            </div>
            
            <div class="uk-margin-large-bottom">
                <p class="uk-text-large uk-text-muted">
                    Sorry, the page you are looking for could not be found.
                </p>
                <p class="uk-text-muted">
                    The page may have been moved, deleted, or you may have entered an incorrect URL.
                </p>
            </div>
            
            <div class="uk-margin-large-bottom">
                <a href="<?php echo SITE_URL; ?>" class="uk-button uk-button-primary uk-button-large uk-border-pill">
                    <i class="ti ti-home"></i> Go to Homepage
                </a>
            </div>
            
            <div class="uk-grid-small uk-child-width-1-2 uk-child-width-1-3@s uk-child-width-1-4@m" uk-grid>
                <div>
                    <a href="<?php echo $urlPath->stores(); ?>" class="uk-button uk-button-default uk-button-small uk-width-1-1 uk-border-pill">
                        <i class="ti ti-store"></i> Browse Stores
                    </a>
                </div>
                <div>
                    <a href="<?php echo $urlPath->search(); ?>" class="uk-button uk-button-default uk-button-small uk-width-1-1 uk-border-pill">
                        <i class="ti ti-search"></i> Search Coupons
                    </a>
                </div>
                <div>
                    <a href="<?php echo $urlPath->categories(); ?>" class="uk-button uk-button-default uk-button-small uk-width-1-1 uk-border-pill">
                        <i class="ti ti-category"></i> Categories
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require './sections/footer.php'; ?>