<?php
session_start();

require '../../config.php';
require '../admin_config.php';
require '../functions.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);

if (!isAdmin($connect) && !isAgent($connect)) {
    header('Location: ../../index.php');
    exit;
}

/**
 * Test affiliate program connection
 */
function testAffiliateConnection($connect, $program_name) {
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ?");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program) {
        return ['success' => false, 'message' => 'Program not found'];
    }
    
    if (empty($program['api_key'])) {
        return ['success' => false, 'message' => 'API key not configured'];
    }
    
    switch ($program_name) {
        case 'Cuelinks':
            return testCuelinksConnection($program);
        case 'INR Deals':
            return testINRDealsConnection($program);
        case 'Admitad':
            return testAdmitadConnection($program);
        case 'Commission Junction (CJ)':
            return testCJConnection($program);
        default:
            return ['success' => false, 'message' => 'Unknown program'];
    }
}

function testCuelinksConnection($program) {
    try {
        $url = "https://api.cuelinks.com/v1/deals";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['deals'])) $count = count($data['deals']);
            
            return ['success' => true, 'message' => "Connected! Found $count deals"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testINRDealsConnection($program) {
    try {
        $url = "https://api.inrdeals.com/v1/coupons";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['coupons'])) $count = count($data['coupons']);
            
            return ['success' => true, 'message' => "Connected! Found $count coupons"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testAdmitadConnection($program) {
    try {
        // Test token endpoint first
        $token_url = "https://api.admitad.com/token/";
        $credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);
        
        // Try different scopes in order of preference
        $scopes_to_try = ['advcampaigns', 'websites', 'advertisers', 'coupons', 'banners'];
        
        foreach ($scopes_to_try as $scope) {
            $token_data = [
                'grant_type' => 'client_credentials',
                'scope' => $scope
            ];
            
            $headers = [
                'Authorization: Basic ' . $credentials,
                'Content-Type: application/x-www-form-urlencoded'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            
            $token_response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);
            
            if ($curl_error) {
                return ['success' => false, 'message' => "cURL Error: $curl_error"];
            }
            
            if ($http_code == 200) {
                $token_data = json_decode($token_response, true);
                if (isset($token_data['access_token'])) {
                    return ['success' => true, 'message' => "Connected! Token obtained with scope '$scope'. Token expires in " . ($token_data['expires_in'] ?? 'unknown') . " seconds"];
                } else {
                    return ['success' => false, 'message' => "Token response invalid for scope '$scope': " . substr($token_response, 0, 200)];
                }
            } elseif ($http_code == 400) {
                // Try next scope for 400 errors (bad request/scope)
                continue;
            } else {
                // For other errors, try to decode and provide better error message
                $error_data = json_decode($token_response, true);
                if ($error_data && isset($error_data['error_description'])) {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . $error_data['error_description']];
                } else {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . substr($token_response, 0, 200)];
                }
            }
        }
        
        return ['success' => false, 'message' => "All scopes failed. Please check your API credentials and account permissions."];
        
    } catch (Exception $e) {
        return ['success' => false, 'message' => "Exception: " . $e->getMessage()];
    }
}

function testCJConnection($program) {
    try {
        $url = "https://product-search.api.cj.com/v3/product-search";
        $params = [
            'website-id' => $program['api_secret'],
            'format' => 'json',
            'page-number' => 1,
            'records-per-page' => 1
        ];
        
        $url .= '?' . http_build_query($params);
        
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['products'])) $count = count($data['products']);
            elseif (isset($data['links'])) $count = count($data['links']);
            
            return ['success' => true, 'message' => "Connected! Found $count products"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_programs'])) {
    $programs = [
        'Cuelinks' => [
            'api_key' => cleardata($_POST['cuelinks_api_key']),
            'api_secret' => cleardata($_POST['cuelinks_username']),
            'status' => isset($_POST['cuelinks_enabled']) ? 1 : 0
        ],
        'INR Deals' => [
            'api_key' => cleardata($_POST['inrdeals_api_key']),
            'api_secret' => cleardata($_POST['inrdeals_username']),
            'status' => isset($_POST['inrdeals_enabled']) ? 1 : 0
        ],
        'Admitad' => [
            'api_key' => cleardata($_POST['admitad_client_id']),
            'api_secret' => cleardata($_POST['admitad_client_secret']),
            'base64_credentials' => cleardata($_POST['admitad_base64']),
            'status' => isset($_POST['admitad_enabled']) ? 1 : 0
        ],
        'Commission Junction (CJ)' => [
            'api_key' => cleardata($_POST['cj_api_key']),
            'api_secret' => cleardata($_POST['cj_publisher_id']),
            'status' => isset($_POST['cj_enabled']) ? 1 : 0
        ]
    ];

    foreach ($programs as $program => $data) {
        $stmt = $connect->prepare("UPDATE affiliate_programs SET 
            api_key = :api_key, 
            api_secret = :api_secret,
            base64_credentials = :base64_credentials,
            status = :status 
            WHERE program_name = :program");
        
        $stmt->execute([
            ':api_key' => $data['api_key'],
            ':api_secret' => $data['api_secret'],
            ':base64_credentials' => $data['base64_credentials'] ?? '',
            ':status' => $data['status'],
            ':program' => $program
        ]);
    }
    
    $success_message = "Affiliate program settings updated successfully!";
}

    // Handle test connection requests
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['test_connection'])) {
        $program_name = cleardata($_POST['test_connection']);
        $test_result = testAffiliateConnection($connect, $program_name);
        
        if ($test_result['success']) {
            $success_message = "✅ " . $program_name . " connection successful! " . $test_result['message'];
        } else {
            $error_message = "❌ " . $program_name . " connection failed: " . $test_result['message'];
        }
    }

// Get current settings
$stmt = $connect->prepare("SELECT * FROM affiliate_programs");
$stmt->execute();
$programs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $program_settings = [];
    foreach ($programs as $program) {
        $program_settings[$program['program_name']] = $program;
    }

    // Initialize messages
    if (!isset($success_message)) $success_message = '';
    if (!isset($error_message)) $error_message = '';

    require '../views/header.view.php';
    require '../views/affiliate_programs.view.php';
    require '../views/footer.view.php';

} else {
    header('Location: ./login.php');
}
?>


require '../../config.php';
require '../admin_config.php';
require '../functions.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);

if (!isAdmin($connect) && !isAgent($connect)) {
    header('Location: ../../index.php');
    exit;
}

/**
 * Test affiliate program connection
 */
function testAffiliateConnection($connect, $program_name) {
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ?");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program) {
        return ['success' => false, 'message' => 'Program not found'];
    }
    
    if (empty($program['api_key'])) {
        return ['success' => false, 'message' => 'API key not configured'];
    }
    
    switch ($program_name) {
        case 'Cuelinks':
            return testCuelinksConnection($program);
        case 'INR Deals':
            return testINRDealsConnection($program);
        case 'Admitad':
            return testAdmitadConnection($program);
        case 'Commission Junction (CJ)':
            return testCJConnection($program);
        default:
            return ['success' => false, 'message' => 'Unknown program'];
    }
}

function testCuelinksConnection($program) {
    try {
        $url = "https://api.cuelinks.com/v1/deals";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['deals'])) $count = count($data['deals']);
            
            return ['success' => true, 'message' => "Connected! Found $count deals"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testINRDealsConnection($program) {
    try {
        $url = "https://api.inrdeals.com/v1/coupons";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['coupons'])) $count = count($data['coupons']);
            
            return ['success' => true, 'message' => "Connected! Found $count coupons"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testAdmitadConnection($program) {
    try {
        // Test token endpoint first
        $token_url = "https://api.admitad.com/token/";
        $credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);
        
        // Try different scopes in order of preference
        $scopes_to_try = ['advcampaigns', 'websites', 'advertisers', 'coupons', 'banners'];
        
        foreach ($scopes_to_try as $scope) {
            $token_data = [
                'grant_type' => 'client_credentials',
                'scope' => $scope
            ];
            
            $headers = [
                'Authorization: Basic ' . $credentials,
                'Content-Type: application/x-www-form-urlencoded'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            
            $token_response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);
            
            if ($curl_error) {
                return ['success' => false, 'message' => "cURL Error: $curl_error"];
            }
            
            if ($http_code == 200) {
                $token_data = json_decode($token_response, true);
                if (isset($token_data['access_token'])) {
                    return ['success' => true, 'message' => "Connected! Token obtained with scope '$scope'. Token expires in " . ($token_data['expires_in'] ?? 'unknown') . " seconds"];
                } else {
                    return ['success' => false, 'message' => "Token response invalid for scope '$scope': " . substr($token_response, 0, 200)];
                }
            } elseif ($http_code == 400) {
                // Try next scope for 400 errors (bad request/scope)
                continue;
            } else {
                // For other errors, try to decode and provide better error message
                $error_data = json_decode($token_response, true);
                if ($error_data && isset($error_data['error_description'])) {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . $error_data['error_description']];
                } else {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . substr($token_response, 0, 200)];
                }
            }
        }
        
        return ['success' => false, 'message' => "All scopes failed. Please check your API credentials and account permissions."];
        
    } catch (Exception $e) {
        return ['success' => false, 'message' => "Exception: " . $e->getMessage()];
    }
}

function testCJConnection($program) {
    try {
        $url = "https://product-search.api.cj.com/v3/product-search";
        $params = [
            'website-id' => $program['api_secret'],
            'format' => 'json',
            'page-number' => 1,
            'records-per-page' => 1
        ];
        
        $url .= '?' . http_build_query($params);
        
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['products'])) $count = count($data['products']);
            elseif (isset($data['links'])) $count = count($data['links']);
            
            return ['success' => true, 'message' => "Connected! Found $count products"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_programs'])) {
    $programs = [
        'Cuelinks' => [
            'api_key' => cleardata($_POST['cuelinks_api_key']),
            'api_secret' => cleardata($_POST['cuelinks_username']),
            'status' => isset($_POST['cuelinks_enabled']) ? 1 : 0
        ],
        'INR Deals' => [
            'api_key' => cleardata($_POST['inrdeals_api_key']),
            'api_secret' => cleardata($_POST['inrdeals_username']),
            'status' => isset($_POST['inrdeals_enabled']) ? 1 : 0
        ],
        'Admitad' => [
            'api_key' => cleardata($_POST['admitad_client_id']),
            'api_secret' => cleardata($_POST['admitad_client_secret']),
            'base64_credentials' => cleardata($_POST['admitad_base64']),
            'status' => isset($_POST['admitad_enabled']) ? 1 : 0
        ],
        'Commission Junction (CJ)' => [
            'api_key' => cleardata($_POST['cj_api_key']),
            'api_secret' => cleardata($_POST['cj_publisher_id']),
            'status' => isset($_POST['cj_enabled']) ? 1 : 0
        ]
    ];

    foreach ($programs as $program => $data) {
        $stmt = $connect->prepare("UPDATE affiliate_programs SET 
            api_key = :api_key, 
            api_secret = :api_secret,
            base64_credentials = :base64_credentials,
            status = :status 
            WHERE program_name = :program");
        
        $stmt->execute([
            ':api_key' => $data['api_key'],
            ':api_secret' => $data['api_secret'],
            ':base64_credentials' => $data['base64_credentials'] ?? '',
            ':status' => $data['status'],
            ':program' => $program
        ]);
    }
    
    $success_message = "Affiliate program settings updated successfully!";
}

    // Handle test connection requests
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['test_connection'])) {
        $program_name = cleardata($_POST['test_connection']);
        $test_result = testAffiliateConnection($connect, $program_name);
        
        if ($test_result['success']) {
            $success_message = "✅ " . $program_name . " connection successful! " . $test_result['message'];
        } else {
            $error_message = "❌ " . $program_name . " connection failed: " . $test_result['message'];
        }
    }

// Get current settings
$stmt = $connect->prepare("SELECT * FROM affiliate_programs");
$stmt->execute();
$programs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $program_settings = [];
    foreach ($programs as $program) {
        $program_settings[$program['program_name']] = $program;
    }

    // Initialize messages
    if (!isset($success_message)) $success_message = '';
    if (!isset($error_message)) $error_message = '';

    require '../views/header.view.php';
    require '../views/affiliate_programs.view.php';
    require '../views/footer.view.php';

} else {
    header('Location: ./login.php');
}
?>


require '../../config.php';
require '../admin_config.php';
require '../functions.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);

if (!isAdmin($connect) && !isAgent($connect)) {
    header('Location: ../../index.php');
    exit;
}

/**
 * Test affiliate program connection
 */
function testAffiliateConnection($connect, $program_name) {
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ?");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program) {
        return ['success' => false, 'message' => 'Program not found'];
    }
    
    if (empty($program['api_key'])) {
        return ['success' => false, 'message' => 'API key not configured'];
    }
    
    switch ($program_name) {
        case 'Cuelinks':
            return testCuelinksConnection($program);
        case 'INR Deals':
            return testINRDealsConnection($program);
        case 'Admitad':
            return testAdmitadConnection($program);
        case 'Commission Junction (CJ)':
            return testCJConnection($program);
        default:
            return ['success' => false, 'message' => 'Unknown program'];
    }
}

function testCuelinksConnection($program) {
    try {
        $url = "https://api.cuelinks.com/v1/deals";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['deals'])) $count = count($data['deals']);
            
            return ['success' => true, 'message' => "Connected! Found $count deals"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testINRDealsConnection($program) {
    try {
        $url = "https://api.inrdeals.com/v1/coupons";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['coupons'])) $count = count($data['coupons']);
            
            return ['success' => true, 'message' => "Connected! Found $count coupons"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testAdmitadConnection($program) {
    try {
        // Test token endpoint first
        $token_url = "https://api.admitad.com/token/";
        $credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);
        
        // Try different scopes in order of preference
        $scopes_to_try = ['advcampaigns', 'websites', 'advertisers', 'coupons', 'banners'];
        
        foreach ($scopes_to_try as $scope) {
            $token_data = [
                'grant_type' => 'client_credentials',
                'scope' => $scope
            ];
            
            $headers = [
                'Authorization: Basic ' . $credentials,
                'Content-Type: application/x-www-form-urlencoded'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            
            $token_response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);
            
            if ($curl_error) {
                return ['success' => false, 'message' => "cURL Error: $curl_error"];
            }
            
            if ($http_code == 200) {
                $token_data = json_decode($token_response, true);
                if (isset($token_data['access_token'])) {
                    return ['success' => true, 'message' => "Connected! Token obtained with scope '$scope'. Token expires in " . ($token_data['expires_in'] ?? 'unknown') . " seconds"];
                } else {
                    return ['success' => false, 'message' => "Token response invalid for scope '$scope': " . substr($token_response, 0, 200)];
                }
            } elseif ($http_code == 400) {
                // Try next scope for 400 errors (bad request/scope)
                continue;
            } else {
                // For other errors, try to decode and provide better error message
                $error_data = json_decode($token_response, true);
                if ($error_data && isset($error_data['error_description'])) {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . $error_data['error_description']];
                } else {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . substr($token_response, 0, 200)];
                }
            }
        }
        
        return ['success' => false, 'message' => "All scopes failed. Please check your API credentials and account permissions."];
        
    } catch (Exception $e) {
        return ['success' => false, 'message' => "Exception: " . $e->getMessage()];
    }
}

function testCJConnection($program) {
    try {
        $url = "https://product-search.api.cj.com/v3/product-search";
        $params = [
            'website-id' => $program['api_secret'],
            'format' => 'json',
            'page-number' => 1,
            'records-per-page' => 1
        ];
        
        $url .= '?' . http_build_query($params);
        
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['products'])) $count = count($data['products']);
            elseif (isset($data['links'])) $count = count($data['links']);
            
            return ['success' => true, 'message' => "Connected! Found $count products"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_programs'])) {
    $programs = [
        'Cuelinks' => [
            'api_key' => cleardata($_POST['cuelinks_api_key']),
            'api_secret' => cleardata($_POST['cuelinks_username']),
            'status' => isset($_POST['cuelinks_enabled']) ? 1 : 0
        ],
        'INR Deals' => [
            'api_key' => cleardata($_POST['inrdeals_api_key']),
            'api_secret' => cleardata($_POST['inrdeals_username']),
            'status' => isset($_POST['inrdeals_enabled']) ? 1 : 0
        ],
        'Admitad' => [
            'api_key' => cleardata($_POST['admitad_client_id']),
            'api_secret' => cleardata($_POST['admitad_client_secret']),
            'base64_credentials' => cleardata($_POST['admitad_base64']),
            'status' => isset($_POST['admitad_enabled']) ? 1 : 0
        ],
        'Commission Junction (CJ)' => [
            'api_key' => cleardata($_POST['cj_api_key']),
            'api_secret' => cleardata($_POST['cj_publisher_id']),
            'status' => isset($_POST['cj_enabled']) ? 1 : 0
        ]
    ];

    foreach ($programs as $program => $data) {
        $stmt = $connect->prepare("UPDATE affiliate_programs SET 
            api_key = :api_key, 
            api_secret = :api_secret,
            base64_credentials = :base64_credentials,
            status = :status 
            WHERE program_name = :program");
        
        $stmt->execute([
            ':api_key' => $data['api_key'],
            ':api_secret' => $data['api_secret'],
            ':base64_credentials' => $data['base64_credentials'] ?? '',
            ':status' => $data['status'],
            ':program' => $program
        ]);
    }
    
    $success_message = "Affiliate program settings updated successfully!";
}

    // Handle test connection requests
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['test_connection'])) {
        $program_name = cleardata($_POST['test_connection']);
        $test_result = testAffiliateConnection($connect, $program_name);
        
        if ($test_result['success']) {
            $success_message = "✅ " . $program_name . " connection successful! " . $test_result['message'];
        } else {
            $error_message = "❌ " . $program_name . " connection failed: " . $test_result['message'];
        }
    }

// Get current settings
$stmt = $connect->prepare("SELECT * FROM affiliate_programs");
$stmt->execute();
$programs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $program_settings = [];
    foreach ($programs as $program) {
        $program_settings[$program['program_name']] = $program;
    }

    // Initialize messages
    if (!isset($success_message)) $success_message = '';
    if (!isset($error_message)) $error_message = '';

    require '../views/header.view.php';
    require '../views/affiliate_programs.view.php';
    require '../views/footer.view.php';

} else {
    header('Location: ./login.php');
}
?>


require '../../config.php';
require '../admin_config.php';
require '../functions.php';

if (isset($_SESSION['user_email'])){

$connect = connect($database);

if (!isAdmin($connect) && !isAgent($connect)) {
    header('Location: ../../index.php');
    exit;
}

/**
 * Test affiliate program connection
 */
function testAffiliateConnection($connect, $program_name) {
    $stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = ?");
    $stmt->execute([$program_name]);
    $program = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$program) {
        return ['success' => false, 'message' => 'Program not found'];
    }
    
    if (empty($program['api_key'])) {
        return ['success' => false, 'message' => 'API key not configured'];
    }
    
    switch ($program_name) {
        case 'Cuelinks':
            return testCuelinksConnection($program);
        case 'INR Deals':
            return testINRDealsConnection($program);
        case 'Admitad':
            return testAdmitadConnection($program);
        case 'Commission Junction (CJ)':
            return testCJConnection($program);
        default:
            return ['success' => false, 'message' => 'Unknown program'];
    }
}

function testCuelinksConnection($program) {
    try {
        $url = "https://api.cuelinks.com/v1/deals";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['deals'])) $count = count($data['deals']);
            
            return ['success' => true, 'message' => "Connected! Found $count deals"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testINRDealsConnection($program) {
    try {
        $url = "https://api.inrdeals.com/v1/coupons";
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['data'])) $count = count($data['data']);
            elseif (isset($data['coupons'])) $count = count($data['coupons']);
            
            return ['success' => true, 'message' => "Connected! Found $count coupons"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

function testAdmitadConnection($program) {
    try {
        // Test token endpoint first
        $token_url = "https://api.admitad.com/token/";
        $credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);
        
        // Try different scopes in order of preference
        $scopes_to_try = ['advcampaigns', 'websites', 'advertisers', 'coupons', 'banners'];
        
        foreach ($scopes_to_try as $scope) {
            $token_data = [
                'grant_type' => 'client_credentials',
                'scope' => $scope
            ];
            
            $headers = [
                'Authorization: Basic ' . $credentials,
                'Content-Type: application/x-www-form-urlencoded'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            
            $token_response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);
            
            if ($curl_error) {
                return ['success' => false, 'message' => "cURL Error: $curl_error"];
            }
            
            if ($http_code == 200) {
                $token_data = json_decode($token_response, true);
                if (isset($token_data['access_token'])) {
                    return ['success' => true, 'message' => "Connected! Token obtained with scope '$scope'. Token expires in " . ($token_data['expires_in'] ?? 'unknown') . " seconds"];
                } else {
                    return ['success' => false, 'message' => "Token response invalid for scope '$scope': " . substr($token_response, 0, 200)];
                }
            } elseif ($http_code == 400) {
                // Try next scope for 400 errors (bad request/scope)
                continue;
            } else {
                // For other errors, try to decode and provide better error message
                $error_data = json_decode($token_response, true);
                if ($error_data && isset($error_data['error_description'])) {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . $error_data['error_description']];
                } else {
                    return ['success' => false, 'message' => "HTTP $http_code with scope '$scope': " . substr($token_response, 0, 200)];
                }
            }
        }
        
        return ['success' => false, 'message' => "All scopes failed. Please check your API credentials and account permissions."];
        
    } catch (Exception $e) {
        return ['success' => false, 'message' => "Exception: " . $e->getMessage()];
    }
}

function testCJConnection($program) {
    try {
        $url = "https://product-search.api.cj.com/v3/product-search";
        $params = [
            'website-id' => $program['api_secret'],
            'format' => 'json',
            'page-number' => 1,
            'records-per-page' => 1
        ];
        
        $url .= '?' . http_build_query($params);
        
        $headers = [
            'Authorization: Bearer ' . $program['api_key'],
            'Accept: application/json'
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code == 200) {
            $data = json_decode($response, true);
            $count = 0;
            if (isset($data['products'])) $count = count($data['products']);
            elseif (isset($data['links'])) $count = count($data['links']);
            
            return ['success' => true, 'message' => "Connected! Found $count products"];
        } else {
            return ['success' => false, 'message' => "HTTP $http_code: " . substr($response, 0, 100)];
        }
    } catch (Exception $e) {
        return ['success' => false, 'message' => $e->getMessage()];
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_programs'])) {
    $programs = [
        'Cuelinks' => [
            'api_key' => cleardata($_POST['cuelinks_api_key']),
            'api_secret' => cleardata($_POST['cuelinks_username']),
            'status' => isset($_POST['cuelinks_enabled']) ? 1 : 0
        ],
        'INR Deals' => [
            'api_key' => cleardata($_POST['inrdeals_api_key']),
            'api_secret' => cleardata($_POST['inrdeals_username']),
            'status' => isset($_POST['inrdeals_enabled']) ? 1 : 0
        ],
        'Admitad' => [
            'api_key' => cleardata($_POST['admitad_client_id']),
            'api_secret' => cleardata($_POST['admitad_client_secret']),
            'base64_credentials' => cleardata($_POST['admitad_base64']),
            'status' => isset($_POST['admitad_enabled']) ? 1 : 0
        ],
        'Commission Junction (CJ)' => [
            'api_key' => cleardata($_POST['cj_api_key']),
            'api_secret' => cleardata($_POST['cj_publisher_id']),
            'status' => isset($_POST['cj_enabled']) ? 1 : 0
        ]
    ];

    foreach ($programs as $program => $data) {
        $stmt = $connect->prepare("UPDATE affiliate_programs SET 
            api_key = :api_key, 
            api_secret = :api_secret,
            base64_credentials = :base64_credentials,
            status = :status 
            WHERE program_name = :program");
        
        $stmt->execute([
            ':api_key' => $data['api_key'],
            ':api_secret' => $data['api_secret'],
            ':base64_credentials' => $data['base64_credentials'] ?? '',
            ':status' => $data['status'],
            ':program' => $program
        ]);
    }
    
    $success_message = "Affiliate program settings updated successfully!";
}

    // Handle test connection requests
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['test_connection'])) {
        $program_name = cleardata($_POST['test_connection']);
        $test_result = testAffiliateConnection($connect, $program_name);
        
        if ($test_result['success']) {
            $success_message = "✅ " . $program_name . " connection successful! " . $test_result['message'];
        } else {
            $error_message = "❌ " . $program_name . " connection failed: " . $test_result['message'];
        }
    }

// Get current settings
$stmt = $connect->prepare("SELECT * FROM affiliate_programs");
$stmt->execute();
$programs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $program_settings = [];
    foreach ($programs as $program) {
        $program_settings[$program['program_name']] = $program;
    }

    // Initialize messages
    if (!isset($success_message)) $success_message = '';
    if (!isset($error_message)) $error_message = '';

    require '../views/header.view.php';
    require '../views/affiliate_programs.view.php';
    require '../views/footer.view.php';

} else {
    header('Location: ./login.php');
}
?>
