<?php

/*--------------------*/
// Description: Store Image Import from URL
// Author: Wicombit
// Author URI: https://www.wicombit.com
/*--------------------*/

session_start();
if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect();

// Check if user is admin or agent
if (isAdmin($connect) || isAgent($connect)){

$message = '';
$error_message = '';

// Handle single image import
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'import_single') {
    $store_id = cleardata($_POST['store_id']);
    $image_url = cleardata($_POST['image_url']);
    
    if (!empty($store_id) && !empty($image_url)) {
        try {
            // Download and save image
            $image_path = downloadImage($image_url, 'store_');
            
            if ($image_path) {
                // Update store with new image
                $stmt = $connect->prepare("UPDATE stores SET store_image = ? WHERE store_id = ?");
                $stmt->execute([$image_path, $store_id]);
                
                $message = "Store image imported successfully!";
            } else {
                $error_message = "Failed to download image from URL.";
            }
        } catch (Exception $e) {
            $error_message = "Error importing image: " . $e->getMessage();
        }
    } else {
        $error_message = "Please provide both store and image URL.";
    }
}

// Handle bulk image import
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'import_bulk') {
    $image_urls = $_POST['image_urls'] ?? [];
    $imported_count = 0;
    $error_count = 0;
    
    foreach ($image_urls as $data) {
        if (!empty($data['store_id']) && !empty($data['image_url'])) {
            try {
                $image_path = downloadImage($data['image_url'], 'store_');
                
                if ($image_path) {
                    $stmt = $connect->prepare("UPDATE stores SET store_image = ? WHERE store_id = ?");
                    $stmt->execute([$image_path, $data['store_id']]);
                    $imported_count++;
                } else {
                    $error_count++;
                }
            } catch (Exception $e) {
                $error_count++;
                error_log("Store image import error: " . $e->getMessage());
            }
        }
    }
    
    $message = "Bulk import completed! Imported: $imported_count, Errors: $error_count";
}

// Get all stores for dropdown
$stmt = $connect->query("SELECT store_id, store_title, store_image FROM stores ORDER BY store_title");
$stores = $stmt->fetchAll(PDO::FETCH_ASSOC);

require '../views/header.view.php';
require '../views/store_image_import.view.php';
require '../views/footer.view.php';

}else{

    header('Location: ./login.php');

}

}else{

    header('Location: ./login.php');

}

/**
 * Download image from URL and save to local directory
 */
function downloadImage($url, $prefix = '') {
    try {
        // Validate URL
        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            throw new Exception("Invalid URL format");
        }
        
        // Get file extension
        $path_info = pathinfo(parse_url($url, PHP_URL_PATH));
        $extension = isset($path_info['extension']) ? strtolower($path_info['extension']) : 'jpg';
        
        // Validate extension
        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        if (!in_array($extension, $allowed_extensions)) {
            $extension = 'jpg'; // Default to jpg if extension is not recognized
        }
        
        // Generate unique filename
        $filename = $prefix . uniqid() . '_' . time() . '.' . $extension;
        $filepath = '../../images/' . $filename;
        
        // Download image
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
        
        $image_data = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);
        
        if ($curl_error) {
            throw new Exception("cURL Error: " . $curl_error);
        }
        
        if ($http_code != 200) {
            throw new Exception("HTTP Error: " . $http_code);
        }
        
        // Save image to file
        if (file_put_contents($filepath, $image_data) === false) {
            throw new Exception("Failed to save image file");
        }
        
        // Verify image is valid
        $image_info = getimagesize($filepath);
        if ($image_info === false) {
            unlink($filepath); // Delete invalid image
            throw new Exception("Invalid image file");
        }
        
        return $filename;
        
    } catch (Exception $e) {
        error_log("Image download error: " . $e->getMessage());
        return false;
    }
}

?>

