<?php require'sidebar.php'; ?>
<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Import from Affiliate Programs</h5>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-block mb-4">
              <?php if (isset($import_count) && $import_count > 0): ?>
                <div class="alert alert-success">
                  <i class="fas fa-check-circle"></i> Successfully imported <?php echo $import_count; ?> items from <?php echo ucfirst($program); ?>!
                </div>
              <?php endif; ?>
              
              <?php if (isset($error_messages) && !empty($error_messages)): ?>
                <div class="alert alert-danger">
                  <h6>Import Errors:</h6>
                  <ul class="mb-0">
                    <?php foreach ($error_messages as $error): ?>
                      <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>
              
              <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Select Affiliate Program</label>
                      <select class="form-control" name="affiliate_program" required>
                        <option value="">Choose a program...</option>
                        <?php foreach ($available_programs as $program): ?>
                          <option value="<?php echo $program['program_name']; ?>" 
                                  <?php echo empty($program['api_key']) ? 'disabled' : ''; ?>>
                            <?php echo $program['program_name']; ?>
                            <?php if (empty($program['api_key'])): ?>
                              (API Key Required)
                            <?php endif; ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>&nbsp;</label>
                      <button type="submit" name="import_from_affiliate" class="btn btn-primary btn-block">
                        <i class="fas fa-download"></i> Import Coupons & Offers
                      </button>
                    </div>
                  </div>
                </div>
              </form>
              
              <div class="mt-4">
                <h6>Available Programs:</h6>
                <div class="row">
                  <?php foreach ($available_programs as $program): ?>
                    <div class="col-md-3 mb-3">
                      <div class="card <?php echo empty($program['api_key']) ? 'border-warning' : 'border-success'; ?>">
                        <div class="card-body text-center">
                          <h6><?php echo $program['program_name']; ?></h6>
                          <small class="text-muted">
                            <?php if ($program['program_name'] == 'Cuelinks'): ?>
                              Cuelinks affiliate network
                            <?php elseif ($program['program_name'] == 'INR Deals'): ?>
                              INR Deals coupon platform
                            <?php elseif ($program['program_name'] == 'Admitad'): ?>
                              Admitad affiliate network
                            <?php elseif ($program['program_name'] == 'Commission Junction (CJ)'): ?>
                              Commission Junction
                            <?php endif; ?>
                          </small>
                          <div class="mt-2">
                            <?php if (empty($program['api_key'])): ?>
                              <span class="badge badge-warning">
                                <i class="fas fa-exclamation-triangle"></i> API Key Required
                              </span>
                            <?php else: ?>
                              <span class="badge badge-success">
                                <i class="fas fa-check-circle"></i> Configured
                              </span>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
              
              <div class="alert alert-info">
                <h6><i class="fas fa-info-circle"></i> Import Information:</h6>
                <ul class="mb-0">
                  <li>This will import coupons and offers from the selected affiliate program</li>
                  <li>Store information will be automatically created if not exists</li>
                  <li>Images will be downloaded and saved locally</li>
                  <li>Duplicate items will be skipped</li>
                  <li>Make sure you have configured the API credentials in Affiliate Programs section</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Import from Affiliate Programs</h5>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-block mb-4">
              <?php if (isset($import_count) && $import_count > 0): ?>
                <div class="alert alert-success">
                  <i class="fas fa-check-circle"></i> Successfully imported <?php echo $import_count; ?> items from <?php echo ucfirst($program); ?>!
                </div>
              <?php endif; ?>
              
              <?php if (isset($error_messages) && !empty($error_messages)): ?>
                <div class="alert alert-danger">
                  <h6>Import Errors:</h6>
                  <ul class="mb-0">
                    <?php foreach ($error_messages as $error): ?>
                      <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>
              
              <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Select Affiliate Program</label>
                      <select class="form-control" name="affiliate_program" required>
                        <option value="">Choose a program...</option>
                        <?php foreach ($available_programs as $program): ?>
                          <option value="<?php echo $program['program_name']; ?>" 
                                  <?php echo empty($program['api_key']) ? 'disabled' : ''; ?>>
                            <?php echo $program['program_name']; ?>
                            <?php if (empty($program['api_key'])): ?>
                              (API Key Required)
                            <?php endif; ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>&nbsp;</label>
                      <button type="submit" name="import_from_affiliate" class="btn btn-primary btn-block">
                        <i class="fas fa-download"></i> Import Coupons & Offers
                      </button>
                    </div>
                  </div>
                </div>
              </form>
              
              <div class="mt-4">
                <h6>Available Programs:</h6>
                <div class="row">
                  <?php foreach ($available_programs as $program): ?>
                    <div class="col-md-3 mb-3">
                      <div class="card <?php echo empty($program['api_key']) ? 'border-warning' : 'border-success'; ?>">
                        <div class="card-body text-center">
                          <h6><?php echo $program['program_name']; ?></h6>
                          <small class="text-muted">
                            <?php if ($program['program_name'] == 'Cuelinks'): ?>
                              Cuelinks affiliate network
                            <?php elseif ($program['program_name'] == 'INR Deals'): ?>
                              INR Deals coupon platform
                            <?php elseif ($program['program_name'] == 'Admitad'): ?>
                              Admitad affiliate network
                            <?php elseif ($program['program_name'] == 'Commission Junction (CJ)'): ?>
                              Commission Junction
                            <?php endif; ?>
                          </small>
                          <div class="mt-2">
                            <?php if (empty($program['api_key'])): ?>
                              <span class="badge badge-warning">
                                <i class="fas fa-exclamation-triangle"></i> API Key Required
                              </span>
                            <?php else: ?>
                              <span class="badge badge-success">
                                <i class="fas fa-check-circle"></i> Configured
                              </span>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
              
              <div class="alert alert-info">
                <h6><i class="fas fa-info-circle"></i> Import Information:</h6>
                <ul class="mb-0">
                  <li>This will import coupons and offers from the selected affiliate program</li>
                  <li>Store information will be automatically created if not exists</li>
                  <li>Images will be downloaded and saved locally</li>
                  <li>Duplicate items will be skipped</li>
                  <li>Make sure you have configured the API credentials in Affiliate Programs section</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Import from Affiliate Programs</h5>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-block mb-4">
              <?php if (isset($import_count) && $import_count > 0): ?>
                <div class="alert alert-success">
                  <i class="fas fa-check-circle"></i> Successfully imported <?php echo $import_count; ?> items from <?php echo ucfirst($program); ?>!
                </div>
              <?php endif; ?>
              
              <?php if (isset($error_messages) && !empty($error_messages)): ?>
                <div class="alert alert-danger">
                  <h6>Import Errors:</h6>
                  <ul class="mb-0">
                    <?php foreach ($error_messages as $error): ?>
                      <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>
              
              <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Select Affiliate Program</label>
                      <select class="form-control" name="affiliate_program" required>
                        <option value="">Choose a program...</option>
                        <?php foreach ($available_programs as $program): ?>
                          <option value="<?php echo $program['program_name']; ?>" 
                                  <?php echo empty($program['api_key']) ? 'disabled' : ''; ?>>
                            <?php echo $program['program_name']; ?>
                            <?php if (empty($program['api_key'])): ?>
                              (API Key Required)
                            <?php endif; ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>&nbsp;</label>
                      <button type="submit" name="import_from_affiliate" class="btn btn-primary btn-block">
                        <i class="fas fa-download"></i> Import Coupons & Offers
                      </button>
                    </div>
                  </div>
                </div>
              </form>
              
              <div class="mt-4">
                <h6>Available Programs:</h6>
                <div class="row">
                  <?php foreach ($available_programs as $program): ?>
                    <div class="col-md-3 mb-3">
                      <div class="card <?php echo empty($program['api_key']) ? 'border-warning' : 'border-success'; ?>">
                        <div class="card-body text-center">
                          <h6><?php echo $program['program_name']; ?></h6>
                          <small class="text-muted">
                            <?php if ($program['program_name'] == 'Cuelinks'): ?>
                              Cuelinks affiliate network
                            <?php elseif ($program['program_name'] == 'INR Deals'): ?>
                              INR Deals coupon platform
                            <?php elseif ($program['program_name'] == 'Admitad'): ?>
                              Admitad affiliate network
                            <?php elseif ($program['program_name'] == 'Commission Junction (CJ)'): ?>
                              Commission Junction
                            <?php endif; ?>
                          </small>
                          <div class="mt-2">
                            <?php if (empty($program['api_key'])): ?>
                              <span class="badge badge-warning">
                                <i class="fas fa-exclamation-triangle"></i> API Key Required
                              </span>
                            <?php else: ?>
                              <span class="badge badge-success">
                                <i class="fas fa-check-circle"></i> Configured
                              </span>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
              
              <div class="alert alert-info">
                <h6><i class="fas fa-info-circle"></i> Import Information:</h6>
                <ul class="mb-0">
                  <li>This will import coupons and offers from the selected affiliate program</li>
                  <li>Store information will be automatically created if not exists</li>
                  <li>Images will be downloaded and saved locally</li>
                  <li>Duplicate items will be skipped</li>
                  <li>Make sure you have configured the API credentials in Affiliate Programs section</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5>Import from Affiliate Programs</h5>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-block mb-4">
              <?php if (isset($import_count) && $import_count > 0): ?>
                <div class="alert alert-success">
                  <i class="fas fa-check-circle"></i> Successfully imported <?php echo $import_count; ?> items from <?php echo ucfirst($program); ?>!
                </div>
              <?php endif; ?>
              
              <?php if (isset($error_messages) && !empty($error_messages)): ?>
                <div class="alert alert-danger">
                  <h6>Import Errors:</h6>
                  <ul class="mb-0">
                    <?php foreach ($error_messages as $error): ?>
                      <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
              <?php endif; ?>
              
              <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Select Affiliate Program</label>
                      <select class="form-control" name="affiliate_program" required>
                        <option value="">Choose a program...</option>
                        <?php foreach ($available_programs as $program): ?>
                          <option value="<?php echo $program['program_name']; ?>" 
                                  <?php echo empty($program['api_key']) ? 'disabled' : ''; ?>>
                            <?php echo $program['program_name']; ?>
                            <?php if (empty($program['api_key'])): ?>
                              (API Key Required)
                            <?php endif; ?>
                          </option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>&nbsp;</label>
                      <button type="submit" name="import_from_affiliate" class="btn btn-primary btn-block">
                        <i class="fas fa-download"></i> Import Coupons & Offers
                      </button>
                    </div>
                  </div>
                </div>
              </form>
              
              <div class="mt-4">
                <h6>Available Programs:</h6>
                <div class="row">
                  <?php foreach ($available_programs as $program): ?>
                    <div class="col-md-3 mb-3">
                      <div class="card <?php echo empty($program['api_key']) ? 'border-warning' : 'border-success'; ?>">
                        <div class="card-body text-center">
                          <h6><?php echo $program['program_name']; ?></h6>
                          <small class="text-muted">
                            <?php if ($program['program_name'] == 'Cuelinks'): ?>
                              Cuelinks affiliate network
                            <?php elseif ($program['program_name'] == 'INR Deals'): ?>
                              INR Deals coupon platform
                            <?php elseif ($program['program_name'] == 'Admitad'): ?>
                              Admitad affiliate network
                            <?php elseif ($program['program_name'] == 'Commission Junction (CJ)'): ?>
                              Commission Junction
                            <?php endif; ?>
                          </small>
                          <div class="mt-2">
                            <?php if (empty($program['api_key'])): ?>
                              <span class="badge badge-warning">
                                <i class="fas fa-exclamation-triangle"></i> API Key Required
                              </span>
                            <?php else: ?>
                              <span class="badge badge-success">
                                <i class="fas fa-check-circle"></i> Configured
                              </span>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
              
              <div class="alert alert-info">
                <h6><i class="fas fa-info-circle"></i> Import Information:</h6>
                <ul class="mb-0">
                  <li>This will import coupons and offers from the selected affiliate program</li>
                  <li>Store information will be automatically created if not exists</li>
                  <li>Images will be downloaded and saved locally</li>
                  <li>Duplicate items will be skipped</li>
                  <li>Make sure you have configured the API credentials in Affiliate Programs section</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
