// Page Content Display Fix
// This script ensures pages show full content without truncation

document.addEventListener("DOMContentLoaded", function() {
    console.log("Starting page content display fix...");
    
    // Remove any truncation classes
    var elements = document.querySelectorAll(".uk-text-truncate");
    elements.forEach(function(el) {
        el.classList.remove("uk-text-truncate");
        el.style.whiteSpace = "normal";
        el.style.textOverflow = "initial";
        el.style.overflow = "visible";
        console.log("Removed truncation from element:", el);
    });
    
    // Ensure all content is visible
    var contentElements = document.querySelectorAll("[class*='page-content'], [class*='uk-width-expand']");
    contentElements.forEach(function(el) {
        el.style.maxWidth = "none";
        el.style.overflow = "visible";
        el.style.whiteSpace = "normal";
        el.style.textOverflow = "initial";
        console.log("Fixed content element:", el);
    });
    
    // Remove any height restrictions
    var allElements = document.querySelectorAll("*");
    allElements.forEach(function(el) {
        if (el.style.maxHeight && el.style.maxHeight !== "none") {
            el.style.maxHeight = "none";
        }
        if (el.style.height && el.style.height.includes("px") && parseInt(el.style.height) < 100) {
            el.style.height = "auto";
        }
    });
    
    // Additional fix for any remaining truncation issues
    var textElements = document.querySelectorAll("p, div, span, h1, h2, h3, h4, h5, h6");
    textElements.forEach(function(el) {
        if (el.style.textOverflow === "ellipsis") {
            el.style.textOverflow = "initial";
        }
        if (el.style.overflow === "hidden") {
            el.style.overflow = "visible";
        }
        if (el.style.whiteSpace === "nowrap") {
            el.style.whiteSpace = "normal";
        }
    });
    
    console.log("Enhanced page content display applied successfully!");
});