<?php
/**
 * Pages Manager Script for Alonedeals.com
 * This script helps manage pages on live server
 * Usage: Upload this file to your server root and access via browser
 */

// Configuration
$config = [
    'site_url' => 'https://alonedeals.com', // Change to your actual domain
    'admin_email' => 'admin@yourdomain.com', // Change to your admin email
    'database' => [
        'host' => 'localhost:3306',
        'db' => 'shubham5de_Alonedeals.comF', // Your database name
        'user' => 'shubham5de_alonedeals.comf', // Your database username
        'pass' => '5~j735Nxm' // Your database password
    ]
];

// Database connection
try {
    $pdo = new PDO(
        "mysql:host={$config['database']['host']};dbname={$config['database']['db']};charset=utf8mb4",
        $config['database']['user'],
        $config['database']['pass'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Helper functions
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function generateSlug($title) {
    $slug = strtolower($title);
    $slug = preg_replace('/[^a-z0-9]+/', '-', $slug);
    $slug = trim($slug, '-');
    return $slug;
}

function checkSlugExists($pdo, $slug, $exclude_id = null) {
    $sql = "SELECT COUNT(*) FROM pages WHERE page_slug = ?";
    $params = [$slug];
    
    if ($exclude_id) {
        $sql .= " AND page_id != ?";
        $params[] = $exclude_id;
    }
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    return $stmt->fetchColumn() > 0;
}

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'create') {
        $title = sanitize($_POST['page_title'] ?? '');
        $content = $_POST['page_content'] ?? '';
        $seo_title = sanitize($_POST['page_seotitle'] ?? '');
        $seo_description = sanitize($_POST['page_seodescription'] ?? '');
        $template = sanitize($_POST['page_template'] ?? 'default');
        $status = (int)($_POST['page_status'] ?? 1);
        $private = (int)($_POST['page_private'] ?? 0);
        $footer = (int)($_POST['page_footer'] ?? 0);
        
        if (empty($title)) {
            $message = 'Page title is required!';
            $message_type = 'error';
        } else {
            $slug = generateSlug($title);
            $original_slug = $slug;
            $counter = 1;
            
            // Check if slug exists and create unique one
            while (checkSlugExists($pdo, $slug)) {
                $slug = $original_slug . '-' . $counter;
                $counter++;
            }
            
            try {
                $stmt = $pdo->prepare("
                    INSERT INTO pages (
                        page_title, page_seotitle, page_content, page_seodescription,
                        page_status, page_slug, page_template, page_private, page_footer,
                        page_ad_header, page_ad_footer, page_ad_sidebar, page_created
                    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, '', '', '', NOW())
                ");
                
                $stmt->execute([
                    $title, $seo_title, $content, $seo_description,
                    $status, $slug, $template, $private, $footer
                ]);
                
                $message = 'Page created successfully!';
                $message_type = 'success';
            } catch (PDOException $e) {
                $message = 'Error creating page: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
    
    if ($action === 'update') {
        $id = (int)($_POST['page_id'] ?? 0);
        $title = sanitize($_POST['page_title'] ?? '');
        $content = $_POST['page_content'] ?? '';
        $seo_title = sanitize($_POST['page_seotitle'] ?? '');
        $seo_description = sanitize($_POST['page_seodescription'] ?? '');
        $template = sanitize($_POST['page_template'] ?? 'default');
        $status = (int)($_POST['page_status'] ?? 1);
        $private = (int)($_POST['page_private'] ?? 0);
        $footer = (int)($_POST['page_footer'] ?? 0);
        
        if (empty($title) || $id <= 0) {
            $message = 'Page title and ID are required!';
            $message_type = 'error';
        } else {
            $slug = generateSlug($title);
            $original_slug = $slug;
            $counter = 1;
            
            // Check if slug exists (excluding current page)
            while (checkSlugExists($pdo, $slug, $id)) {
                $slug = $original_slug . '-' . $counter;
                $counter++;
            }
            
            try {
                $stmt = $pdo->prepare("
                    UPDATE pages SET 
                        page_title = ?, page_seotitle = ?, page_content = ?, page_seodescription = ?,
                        page_status = ?, page_slug = ?, page_template = ?, page_private = ?, page_footer = ?,
                        page_updated = NOW()
                    WHERE page_id = ?
                ");
                
                $stmt->execute([
                    $title, $seo_title, $content, $seo_description,
                    $status, $slug, $template, $private, $footer, $id
                ]);
                
                $message = 'Page updated successfully!';
                $message_type = 'success';
            } catch (PDOException $e) {
                $message = 'Error updating page: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
    
    if ($action === 'delete') {
        $id = (int)($_POST['page_id'] ?? 0);
        
        if ($id <= 0) {
            $message = 'Invalid page ID!';
            $message_type = 'error';
        } else {
            try {
                $stmt = $pdo->prepare("DELETE FROM pages WHERE page_id = ?");
                $stmt->execute([$id]);
                
                $message = 'Page deleted successfully!';
                $message_type = 'success';
            } catch (PDOException $e) {
                $message = 'Error deleting page: ' . $e->getMessage();
                $message_type = 'error';
            }
        }
    }
}

// Get pages for listing
$pages = [];
try {
    $stmt = $pdo->query("
        SELECT page_id, page_title, page_slug, page_status, page_template, 
               page_private, page_footer, page_created, page_updated
        FROM pages 
        ORDER BY page_created DESC
    ");
    $pages = $stmt->fetchAll();
} catch (PDOException $e) {
    $message = 'Error fetching pages: ' . $e->getMessage();
    $message_type = 'error';
}

// Get page for editing
$edit_page = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    try {
        $stmt = $pdo->prepare("SELECT * FROM pages WHERE page_id = ?");
        $stmt->execute([$edit_id]);
        $edit_page = $stmt->fetch();
    } catch (PDOException $e) {
        $message = 'Error fetching page for editing: ' . $e->getMessage();
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pages Manager - Alonedeals.com</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        .header { background: #e91e63; color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px; }
        .header h1 { font-size: 24px; }
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .card-header { background: #f8f9fa; padding: 15px 20px; border-bottom: 1px solid #dee2e6; border-radius: 8px 8px 0 0; }
        .card-body { padding: 20px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-control { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
        .form-control:focus { outline: none; border-color: #e91e63; box-shadow: 0 0 0 2px rgba(233, 30, 99, 0.2); }
        textarea.form-control { min-height: 200px; resize: vertical; }
        .btn { padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; font-size: 14px; text-decoration: none; display: inline-block; }
        .btn-primary { background: #e91e63; color: white; }
        .btn-primary:hover { background: #c2185b; }
        .btn-success { background: #28a745; color: white; }
        .btn-success:hover { background: #218838; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-danger:hover { background: #c82333; }
        .btn-warning { background: #ffc107; color: #212529; }
        .btn-warning:hover { background: #e0a800; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        .alert { padding: 15px; border-radius: 4px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .table { width: 100%; border-collapse: collapse; }
        .table th, .table td { padding: 12px; text-align: left; border-bottom: 1px solid #dee2e6; }
        .table th { background: #f8f9fa; font-weight: bold; }
        .table tr:hover { background: #f8f9fa; }
        .status-active { color: #28a745; font-weight: bold; }
        .status-inactive { color: #dc3545; font-weight: bold; }
        .actions { display: flex; gap: 5px; }
        .row { display: flex; gap: 20px; }
        .col-md-6 { flex: 1; }
        .col-md-12 { flex: 100%; }
        @media (max-width: 768px) {
            .row { flex-direction: column; }
            .actions { flex-direction: column; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📄 Pages Manager - Alonedeals.com</h1>
            <p>Manage your website pages easily</p>
        </div>

        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3><?php echo $edit_page ? 'Edit Page' : 'Create New Page'; ?></h3>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="<?php echo $edit_page ? 'update' : 'create'; ?>">
                            <?php if ($edit_page): ?>
                                <input type="hidden" name="page_id" value="<?php echo $edit_page['page_id']; ?>">
                            <?php endif; ?>

                            <div class="form-group">
                                <label for="page_title">Page Title *</label>
                                <input type="text" id="page_title" name="page_title" class="form-control" 
                                       value="<?php echo htmlspecialchars($edit_page['page_title'] ?? ''); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="page_seotitle">SEO Title</label>
                                <input type="text" id="page_seotitle" name="page_seotitle" class="form-control" 
                                       value="<?php echo htmlspecialchars($edit_page['page_seotitle'] ?? ''); ?>">
                            </div>

                            <div class="form-group">
                                <label for="page_content">Page Content</label>
                                <textarea id="page_content" name="page_content" class="form-control"><?php echo htmlspecialchars($edit_page['page_content'] ?? ''); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="page_seodescription">SEO Description</label>
                                <textarea id="page_seodescription" name="page_seodescription" class="form-control" rows="3"><?php echo htmlspecialchars($edit_page['page_seodescription'] ?? ''); ?></textarea>
                            </div>

                            <div class="form-group">
                                <label for="page_template">Template</label>
                                <select id="page_template" name="page_template" class="form-control">
                                    <option value="default" <?php echo ($edit_page['page_template'] ?? '') === 'default' ? 'selected' : ''; ?>>Default</option>
                                    <option value="full-width" <?php echo ($edit_page['page_template'] ?? '') === 'full-width' ? 'selected' : ''; ?>>Full Width</option>
                                    <option value="sidebar" <?php echo ($edit_page['page_template'] ?? '') === 'sidebar' ? 'selected' : ''; ?>>With Sidebar</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="page_status">Status</label>
                                <select id="page_status" name="page_status" class="form-control">
                                    <option value="1" <?php echo ($edit_page['page_status'] ?? 1) == 1 ? 'selected' : ''; ?>>Active</option>
                                    <option value="0" <?php echo ($edit_page['page_status'] ?? 1) == 0 ? 'selected' : ''; ?>>Inactive</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="page_private" value="1" 
                                           <?php echo ($edit_page['page_private'] ?? 0) == 1 ? 'checked' : ''; ?>>
                                    Private Page
                                </label>
                            </div>

                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="page_footer" value="1" 
                                           <?php echo ($edit_page['page_footer'] ?? 0) == 1 ? 'checked' : ''; ?>>
                                    Show in Footer
                                </label>
                            </div>

                            <button type="submit" class="btn btn-<?php echo $edit_page ? 'success' : 'primary'; ?>">
                                <?php echo $edit_page ? 'Update Page' : 'Create Page'; ?>
                            </button>

                            <?php if ($edit_page): ?>
                                <a href="pages_manager.php" class="btn btn-warning">Cancel</a>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3>📋 All Pages (<?php echo count($pages); ?>)</h3>
                    </div>
                    <div class="card-body">
                        <?php if (empty($pages)): ?>
                            <p>No pages found. Create your first page!</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Template</th>
                                            <th>Created</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($pages as $page): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($page['page_title']); ?></strong>
                                                    <br><small class="text-muted">/<?php echo htmlspecialchars($page['page_slug']); ?></small>
                                                </td>
                                                <td>
                                                    <span class="status-<?php echo $page['page_status'] ? 'active' : 'inactive'; ?>">
                                                        <?php echo $page['page_status'] ? 'Active' : 'Inactive'; ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($page['page_template']); ?></td>
                                                <td><?php echo date('M j, Y', strtotime($page['page_created'])); ?></td>
                                                <td>
                                                    <div class="actions">
                                                        <a href="?edit=<?php echo $page['page_id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                                        <a href="<?php echo $config['site_url']; ?>/<?php echo $page['page_slug']; ?>" 
                                                           target="_blank" class="btn btn-primary btn-sm">View</a>
                                                        <form method="POST" style="display: inline;" 
                                                              onsubmit="return confirm('Are you sure you want to delete this page?');">
                                                            <input type="hidden" name="action" value="delete">
                                                            <input type="hidden" name="page_id" value="<?php echo $page['page_id']; ?>">
                                                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3>📊 Quick Stats</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <strong>Total Pages:</strong> <?php echo count($pages); ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Active Pages:</strong> <?php echo count(array_filter($pages, fn($p) => $p['page_status'])); ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Private Pages:</strong> <?php echo count(array_filter($pages, fn($p) => $p['page_private'])); ?>
                    </div>
                    <div class="col-md-3">
                        <strong>Footer Pages:</strong> <?php echo count(array_filter($pages, fn($p) => $p['page_footer'])); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-generate slug from title
        document.getElementById('page_title').addEventListener('input', function() {
            const title = this.value;
            const slug = title.toLowerCase()
                .replace(/[^a-z0-9\s-]/g, '')
                .replace(/\s+/g, '-')
                .replace(/-+/g, '-')
                .trim('-');
            
            // You can display the generated slug to the user
            console.log('Generated slug:', slug);
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const title = document.getElementById('page_title').value.trim();
            if (!title) {
                e.preventDefault();
                alert('Page title is required!');
                return false;
            }
        });
    </script>
</body>
</html>