<?php
// Test script to debug Admitad API connection issues
require 'config.php';
require 'admin/functions.php';

$connect = connect($database);

// Get Admitad settings from database
$stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = 'Admitad'");
$stmt->execute();
$program = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$program) {
    die("Admitad program not found in database. Please configure it first in admin panel.");
}

echo "<h2>Admitad API Debug Test</h2>";
echo "<h3>Current Settings:</h3>";
echo "API Key (Client ID): " . (empty($program['api_key']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_key'], 0, 10) . '...') . "<br>";
echo "API Secret (Client Secret): " . (empty($program['api_secret']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_secret'], 0, 10) . '...') . "<br>";
echo "Base64 Credentials: " . (empty($program['base64_credentials']) ? '<span style="color:red">NOT SET</span>' : substr($program['base64_credentials'], 0, 20) . '...') . "<br>";
echo "Status: " . ($program['status'] ? 'Enabled' : 'Disabled') . "<br><br>";

if (empty($program['api_key']) || empty($program['api_secret'])) {
    die("<span style='color:red'>Error: API Key or Secret is not configured. Please set them in the admin panel first.</span>");
}

// Test 1: Basic token request
echo "<h3>Test 1: Basic Token Request</h3>";
$token_url = "https://api.admitad.com/token/";
$credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);

echo "Token URL: $token_url<br>";
echo "Credentials (Base64): " . substr($credentials, 0, 20) . "...<br>";

$token_data = [
    'grant_type' => 'client_credentials',
    'scope' => 'coupons'
];

$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/x-www-form-urlencoded'
];

echo "Headers: " . implode(', ', $headers) . "<br>";
echo "POST Data: " . http_build_query($token_data) . "<br><br>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $token_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$token_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
$curl_info = curl_getinfo($ch);
curl_close($ch);

echo "<strong>Response:</strong><br>";
echo "HTTP Code: $http_code<br>";
if ($curl_error) {
    echo "cURL Error: $curl_error<br>";
}
echo "Response Body: <pre>" . htmlspecialchars($token_response) . "</pre>";

if ($http_code == 200) {
    $token_data = json_decode($token_response, true);
    if (isset($token_data['access_token'])) {
        echo "<span style='color:green'>✅ SUCCESS: Token obtained!</span><br>";
        echo "Access Token: " . substr($token_data['access_token'], 0, 20) . "...<br>";
        echo "Token Type: " . ($token_data['token_type'] ?? 'N/A') . "<br>";
        echo "Expires In: " . ($token_data['expires_in'] ?? 'N/A') . " seconds<br>";
        
        // Test 2: Use token to access coupons API
        echo "<h3>Test 2: Access Coupons API with Token</h3>";
        $coupons_url = "https://api.admitad.com/coupons/";
        $token_headers = [
            'Authorization: Bearer ' . $token_data['access_token'],
            'Accept: application/json'
        ];
        
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $coupons_url);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, $token_headers);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
        
        $coupons_response = curl_exec($ch2);
        $coupons_http_code = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        curl_close($ch2);
        
        echo "Coupons API Response:<br>";
        echo "HTTP Code: $coupons_http_code<br>";
        echo "Response: <pre>" . htmlspecialchars($coupons_response) . "</pre>";
        
    } else {
        echo "<span style='color:red'>❌ FAILED: No access token in response</span><br>";
    }
} else {
    echo "<span style='color:red'>❌ FAILED: HTTP $http_code</span><br>";
    
    // Try to decode error response
    $error_data = json_decode($token_response, true);
    if ($error_data) {
        echo "Error Details:<br>";
        echo "Error: " . ($error_data['error'] ?? 'Unknown') . "<br>";
        echo "Error Description: " . ($error_data['error_description'] ?? 'No description') . "<br>";
    }
}

echo "<h3>Common Issues and Solutions:</h3>";
echo "<ul>";
echo "<li><strong>Invalid Credentials:</strong> Make sure your Client ID and Client Secret are correct</li>";
echo "<li><strong>Wrong Scope:</strong> Try different scopes like 'advcampaigns', 'websites', or 'advertisers'</li>";
echo "<li><strong>Account Status:</strong> Ensure your Admitad account is active and approved</li>";
echo "<li><strong>API Access:</strong> Check if API access is enabled in your Admitad account settings</li>";
echo "<li><strong>Rate Limiting:</strong> You might be hitting rate limits - try again later</li>";
echo "</ul>";

echo "<h3>Alternative Scopes to Try:</h3>";
$alternative_scopes = ['advcampaigns', 'websites', 'advertisers', 'banners', 'statistics'];
foreach ($alternative_scopes as $scope) {
    echo "<a href='?test_scope=$scope'>Test with scope: $scope</a><br>";
}

// Test alternative scope if requested
if (isset($_GET['test_scope'])) {
    $test_scope = $_GET['test_scope'];
    echo "<h3>Testing with scope: $test_scope</h3>";
    
    $token_data_alt = [
        'grant_type' => 'client_credentials',
        'scope' => $test_scope
    ];
    
    $ch_alt = curl_init();
    curl_setopt($ch_alt, CURLOPT_URL, $token_url);
    curl_setopt($ch_alt, CURLOPT_POST, true);
    curl_setopt($ch_alt, CURLOPT_POSTFIELDS, http_build_query($token_data_alt));
    curl_setopt($ch_alt, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch_alt, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_alt, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch_alt, CURLOPT_TIMEOUT, 30);
    
    $alt_response = curl_exec($ch_alt);
    $alt_http_code = curl_getinfo($ch_alt, CURLINFO_HTTP_CODE);
    curl_close($ch_alt);
    
    echo "HTTP Code: $alt_http_code<br>";
    echo "Response: <pre>" . htmlspecialchars($alt_response) . "</pre>";
}
?>


// Test script to debug Admitad API connection issues
require 'config.php';
require 'admin/functions.php';

$connect = connect($database);

// Get Admitad settings from database
$stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = 'Admitad'");
$stmt->execute();
$program = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$program) {
    die("Admitad program not found in database. Please configure it first in admin panel.");
}

echo "<h2>Admitad API Debug Test</h2>";
echo "<h3>Current Settings:</h3>";
echo "API Key (Client ID): " . (empty($program['api_key']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_key'], 0, 10) . '...') . "<br>";
echo "API Secret (Client Secret): " . (empty($program['api_secret']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_secret'], 0, 10) . '...') . "<br>";
echo "Base64 Credentials: " . (empty($program['base64_credentials']) ? '<span style="color:red">NOT SET</span>' : substr($program['base64_credentials'], 0, 20) . '...') . "<br>";
echo "Status: " . ($program['status'] ? 'Enabled' : 'Disabled') . "<br><br>";

if (empty($program['api_key']) || empty($program['api_secret'])) {
    die("<span style='color:red'>Error: API Key or Secret is not configured. Please set them in the admin panel first.</span>");
}

// Test 1: Basic token request
echo "<h3>Test 1: Basic Token Request</h3>";
$token_url = "https://api.admitad.com/token/";
$credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);

echo "Token URL: $token_url<br>";
echo "Credentials (Base64): " . substr($credentials, 0, 20) . "...<br>";

$token_data = [
    'grant_type' => 'client_credentials',
    'scope' => 'coupons'
];

$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/x-www-form-urlencoded'
];

echo "Headers: " . implode(', ', $headers) . "<br>";
echo "POST Data: " . http_build_query($token_data) . "<br><br>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $token_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$token_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
$curl_info = curl_getinfo($ch);
curl_close($ch);

echo "<strong>Response:</strong><br>";
echo "HTTP Code: $http_code<br>";
if ($curl_error) {
    echo "cURL Error: $curl_error<br>";
}
echo "Response Body: <pre>" . htmlspecialchars($token_response) . "</pre>";

if ($http_code == 200) {
    $token_data = json_decode($token_response, true);
    if (isset($token_data['access_token'])) {
        echo "<span style='color:green'>✅ SUCCESS: Token obtained!</span><br>";
        echo "Access Token: " . substr($token_data['access_token'], 0, 20) . "...<br>";
        echo "Token Type: " . ($token_data['token_type'] ?? 'N/A') . "<br>";
        echo "Expires In: " . ($token_data['expires_in'] ?? 'N/A') . " seconds<br>";
        
        // Test 2: Use token to access coupons API
        echo "<h3>Test 2: Access Coupons API with Token</h3>";
        $coupons_url = "https://api.admitad.com/coupons/";
        $token_headers = [
            'Authorization: Bearer ' . $token_data['access_token'],
            'Accept: application/json'
        ];
        
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $coupons_url);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, $token_headers);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
        
        $coupons_response = curl_exec($ch2);
        $coupons_http_code = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        curl_close($ch2);
        
        echo "Coupons API Response:<br>";
        echo "HTTP Code: $coupons_http_code<br>";
        echo "Response: <pre>" . htmlspecialchars($coupons_response) . "</pre>";
        
    } else {
        echo "<span style='color:red'>❌ FAILED: No access token in response</span><br>";
    }
} else {
    echo "<span style='color:red'>❌ FAILED: HTTP $http_code</span><br>";
    
    // Try to decode error response
    $error_data = json_decode($token_response, true);
    if ($error_data) {
        echo "Error Details:<br>";
        echo "Error: " . ($error_data['error'] ?? 'Unknown') . "<br>";
        echo "Error Description: " . ($error_data['error_description'] ?? 'No description') . "<br>";
    }
}

echo "<h3>Common Issues and Solutions:</h3>";
echo "<ul>";
echo "<li><strong>Invalid Credentials:</strong> Make sure your Client ID and Client Secret are correct</li>";
echo "<li><strong>Wrong Scope:</strong> Try different scopes like 'advcampaigns', 'websites', or 'advertisers'</li>";
echo "<li><strong>Account Status:</strong> Ensure your Admitad account is active and approved</li>";
echo "<li><strong>API Access:</strong> Check if API access is enabled in your Admitad account settings</li>";
echo "<li><strong>Rate Limiting:</strong> You might be hitting rate limits - try again later</li>";
echo "</ul>";

echo "<h3>Alternative Scopes to Try:</h3>";
$alternative_scopes = ['advcampaigns', 'websites', 'advertisers', 'banners', 'statistics'];
foreach ($alternative_scopes as $scope) {
    echo "<a href='?test_scope=$scope'>Test with scope: $scope</a><br>";
}

// Test alternative scope if requested
if (isset($_GET['test_scope'])) {
    $test_scope = $_GET['test_scope'];
    echo "<h3>Testing with scope: $test_scope</h3>";
    
    $token_data_alt = [
        'grant_type' => 'client_credentials',
        'scope' => $test_scope
    ];
    
    $ch_alt = curl_init();
    curl_setopt($ch_alt, CURLOPT_URL, $token_url);
    curl_setopt($ch_alt, CURLOPT_POST, true);
    curl_setopt($ch_alt, CURLOPT_POSTFIELDS, http_build_query($token_data_alt));
    curl_setopt($ch_alt, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch_alt, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_alt, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch_alt, CURLOPT_TIMEOUT, 30);
    
    $alt_response = curl_exec($ch_alt);
    $alt_http_code = curl_getinfo($ch_alt, CURLINFO_HTTP_CODE);
    curl_close($ch_alt);
    
    echo "HTTP Code: $alt_http_code<br>";
    echo "Response: <pre>" . htmlspecialchars($alt_response) . "</pre>";
}
?>

// Test script to debug Admitad API connection issues
require 'config.php';
require 'admin/functions.php';

$connect = connect($database);

// Get Admitad settings from database
$stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = 'Admitad'");
$stmt->execute();
$program = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$program) {
    die("Admitad program not found in database. Please configure it first in admin panel.");
}

echo "<h2>Admitad API Debug Test</h2>";
echo "<h3>Current Settings:</h3>";
echo "API Key (Client ID): " . (empty($program['api_key']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_key'], 0, 10) . '...') . "<br>";
echo "API Secret (Client Secret): " . (empty($program['api_secret']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_secret'], 0, 10) . '...') . "<br>";
echo "Base64 Credentials: " . (empty($program['base64_credentials']) ? '<span style="color:red">NOT SET</span>' : substr($program['base64_credentials'], 0, 20) . '...') . "<br>";
echo "Status: " . ($program['status'] ? 'Enabled' : 'Disabled') . "<br><br>";

if (empty($program['api_key']) || empty($program['api_secret'])) {
    die("<span style='color:red'>Error: API Key or Secret is not configured. Please set them in the admin panel first.</span>");
}

// Test 1: Basic token request
echo "<h3>Test 1: Basic Token Request</h3>";
$token_url = "https://api.admitad.com/token/";
$credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);

echo "Token URL: $token_url<br>";
echo "Credentials (Base64): " . substr($credentials, 0, 20) . "...<br>";

$token_data = [
    'grant_type' => 'client_credentials',
    'scope' => 'coupons'
];

$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/x-www-form-urlencoded'
];

echo "Headers: " . implode(', ', $headers) . "<br>";
echo "POST Data: " . http_build_query($token_data) . "<br><br>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $token_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$token_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
$curl_info = curl_getinfo($ch);
curl_close($ch);

echo "<strong>Response:</strong><br>";
echo "HTTP Code: $http_code<br>";
if ($curl_error) {
    echo "cURL Error: $curl_error<br>";
}
echo "Response Body: <pre>" . htmlspecialchars($token_response) . "</pre>";

if ($http_code == 200) {
    $token_data = json_decode($token_response, true);
    if (isset($token_data['access_token'])) {
        echo "<span style='color:green'>✅ SUCCESS: Token obtained!</span><br>";
        echo "Access Token: " . substr($token_data['access_token'], 0, 20) . "...<br>";
        echo "Token Type: " . ($token_data['token_type'] ?? 'N/A') . "<br>";
        echo "Expires In: " . ($token_data['expires_in'] ?? 'N/A') . " seconds<br>";
        
        // Test 2: Use token to access coupons API
        echo "<h3>Test 2: Access Coupons API with Token</h3>";
        $coupons_url = "https://api.admitad.com/coupons/";
        $token_headers = [
            'Authorization: Bearer ' . $token_data['access_token'],
            'Accept: application/json'
        ];
        
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $coupons_url);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, $token_headers);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
        
        $coupons_response = curl_exec($ch2);
        $coupons_http_code = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        curl_close($ch2);
        
        echo "Coupons API Response:<br>";
        echo "HTTP Code: $coupons_http_code<br>";
        echo "Response: <pre>" . htmlspecialchars($coupons_response) . "</pre>";
        
    } else {
        echo "<span style='color:red'>❌ FAILED: No access token in response</span><br>";
    }
} else {
    echo "<span style='color:red'>❌ FAILED: HTTP $http_code</span><br>";
    
    // Try to decode error response
    $error_data = json_decode($token_response, true);
    if ($error_data) {
        echo "Error Details:<br>";
        echo "Error: " . ($error_data['error'] ?? 'Unknown') . "<br>";
        echo "Error Description: " . ($error_data['error_description'] ?? 'No description') . "<br>";
    }
}

echo "<h3>Common Issues and Solutions:</h3>";
echo "<ul>";
echo "<li><strong>Invalid Credentials:</strong> Make sure your Client ID and Client Secret are correct</li>";
echo "<li><strong>Wrong Scope:</strong> Try different scopes like 'advcampaigns', 'websites', or 'advertisers'</li>";
echo "<li><strong>Account Status:</strong> Ensure your Admitad account is active and approved</li>";
echo "<li><strong>API Access:</strong> Check if API access is enabled in your Admitad account settings</li>";
echo "<li><strong>Rate Limiting:</strong> You might be hitting rate limits - try again later</li>";
echo "</ul>";

echo "<h3>Alternative Scopes to Try:</h3>";
$alternative_scopes = ['advcampaigns', 'websites', 'advertisers', 'banners', 'statistics'];
foreach ($alternative_scopes as $scope) {
    echo "<a href='?test_scope=$scope'>Test with scope: $scope</a><br>";
}

// Test alternative scope if requested
if (isset($_GET['test_scope'])) {
    $test_scope = $_GET['test_scope'];
    echo "<h3>Testing with scope: $test_scope</h3>";
    
    $token_data_alt = [
        'grant_type' => 'client_credentials',
        'scope' => $test_scope
    ];
    
    $ch_alt = curl_init();
    curl_setopt($ch_alt, CURLOPT_URL, $token_url);
    curl_setopt($ch_alt, CURLOPT_POST, true);
    curl_setopt($ch_alt, CURLOPT_POSTFIELDS, http_build_query($token_data_alt));
    curl_setopt($ch_alt, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch_alt, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_alt, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch_alt, CURLOPT_TIMEOUT, 30);
    
    $alt_response = curl_exec($ch_alt);
    $alt_http_code = curl_getinfo($ch_alt, CURLINFO_HTTP_CODE);
    curl_close($ch_alt);
    
    echo "HTTP Code: $alt_http_code<br>";
    echo "Response: <pre>" . htmlspecialchars($alt_response) . "</pre>";
}
?>


// Test script to debug Admitad API connection issues
require 'config.php';
require 'admin/functions.php';

$connect = connect($database);

// Get Admitad settings from database
$stmt = $connect->prepare("SELECT * FROM affiliate_programs WHERE program_name = 'Admitad'");
$stmt->execute();
$program = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$program) {
    die("Admitad program not found in database. Please configure it first in admin panel.");
}

echo "<h2>Admitad API Debug Test</h2>";
echo "<h3>Current Settings:</h3>";
echo "API Key (Client ID): " . (empty($program['api_key']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_key'], 0, 10) . '...') . "<br>";
echo "API Secret (Client Secret): " . (empty($program['api_secret']) ? '<span style="color:red">NOT SET</span>' : substr($program['api_secret'], 0, 10) . '...') . "<br>";
echo "Base64 Credentials: " . (empty($program['base64_credentials']) ? '<span style="color:red">NOT SET</span>' : substr($program['base64_credentials'], 0, 20) . '...') . "<br>";
echo "Status: " . ($program['status'] ? 'Enabled' : 'Disabled') . "<br><br>";

if (empty($program['api_key']) || empty($program['api_secret'])) {
    die("<span style='color:red'>Error: API Key or Secret is not configured. Please set them in the admin panel first.</span>");
}

// Test 1: Basic token request
echo "<h3>Test 1: Basic Token Request</h3>";
$token_url = "https://api.admitad.com/token/";
$credentials = base64_encode($program['api_key'] . ':' . $program['api_secret']);

echo "Token URL: $token_url<br>";
echo "Credentials (Base64): " . substr($credentials, 0, 20) . "...<br>";

$token_data = [
    'grant_type' => 'client_credentials',
    'scope' => 'coupons'
];

$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/x-www-form-urlencoded'
];

echo "Headers: " . implode(', ', $headers) . "<br>";
echo "POST Data: " . http_build_query($token_data) . "<br><br>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $token_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($token_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$token_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
$curl_info = curl_getinfo($ch);
curl_close($ch);

echo "<strong>Response:</strong><br>";
echo "HTTP Code: $http_code<br>";
if ($curl_error) {
    echo "cURL Error: $curl_error<br>";
}
echo "Response Body: <pre>" . htmlspecialchars($token_response) . "</pre>";

if ($http_code == 200) {
    $token_data = json_decode($token_response, true);
    if (isset($token_data['access_token'])) {
        echo "<span style='color:green'>✅ SUCCESS: Token obtained!</span><br>";
        echo "Access Token: " . substr($token_data['access_token'], 0, 20) . "...<br>";
        echo "Token Type: " . ($token_data['token_type'] ?? 'N/A') . "<br>";
        echo "Expires In: " . ($token_data['expires_in'] ?? 'N/A') . " seconds<br>";
        
        // Test 2: Use token to access coupons API
        echo "<h3>Test 2: Access Coupons API with Token</h3>";
        $coupons_url = "https://api.admitad.com/coupons/";
        $token_headers = [
            'Authorization: Bearer ' . $token_data['access_token'],
            'Accept: application/json'
        ];
        
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $coupons_url);
        curl_setopt($ch2, CURLOPT_HTTPHEADER, $token_headers);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
        
        $coupons_response = curl_exec($ch2);
        $coupons_http_code = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        curl_close($ch2);
        
        echo "Coupons API Response:<br>";
        echo "HTTP Code: $coupons_http_code<br>";
        echo "Response: <pre>" . htmlspecialchars($coupons_response) . "</pre>";
        
    } else {
        echo "<span style='color:red'>❌ FAILED: No access token in response</span><br>";
    }
} else {
    echo "<span style='color:red'>❌ FAILED: HTTP $http_code</span><br>";
    
    // Try to decode error response
    $error_data = json_decode($token_response, true);
    if ($error_data) {
        echo "Error Details:<br>";
        echo "Error: " . ($error_data['error'] ?? 'Unknown') . "<br>";
        echo "Error Description: " . ($error_data['error_description'] ?? 'No description') . "<br>";
    }
}

echo "<h3>Common Issues and Solutions:</h3>";
echo "<ul>";
echo "<li><strong>Invalid Credentials:</strong> Make sure your Client ID and Client Secret are correct</li>";
echo "<li><strong>Wrong Scope:</strong> Try different scopes like 'advcampaigns', 'websites', or 'advertisers'</li>";
echo "<li><strong>Account Status:</strong> Ensure your Admitad account is active and approved</li>";
echo "<li><strong>API Access:</strong> Check if API access is enabled in your Admitad account settings</li>";
echo "<li><strong>Rate Limiting:</strong> You might be hitting rate limits - try again later</li>";
echo "</ul>";

echo "<h3>Alternative Scopes to Try:</h3>";
$alternative_scopes = ['advcampaigns', 'websites', 'advertisers', 'banners', 'statistics'];
foreach ($alternative_scopes as $scope) {
    echo "<a href='?test_scope=$scope'>Test with scope: $scope</a><br>";
}

// Test alternative scope if requested
if (isset($_GET['test_scope'])) {
    $test_scope = $_GET['test_scope'];
    echo "<h3>Testing with scope: $test_scope</h3>";
    
    $token_data_alt = [
        'grant_type' => 'client_credentials',
        'scope' => $test_scope
    ];
    
    $ch_alt = curl_init();
    curl_setopt($ch_alt, CURLOPT_URL, $token_url);
    curl_setopt($ch_alt, CURLOPT_POST, true);
    curl_setopt($ch_alt, CURLOPT_POSTFIELDS, http_build_query($token_data_alt));
    curl_setopt($ch_alt, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch_alt, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_alt, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch_alt, CURLOPT_TIMEOUT, 30);
    
    $alt_response = curl_exec($ch_alt);
    $alt_http_code = curl_getinfo($ch_alt, CURLINFO_HTTP_CODE);
    curl_close($ch_alt);
    
    echo "HTTP Code: $alt_http_code<br>";
    echo "Response: <pre>" . htmlspecialchars($alt_response) . "</pre>";
}
?>

