# Author Photo Upload - Complete Guide

## ✅ Feature Added Successfully!

You can now upload and manage author profile photos from the admin panel.

---

## 📸 How to Upload Author Photo

### Step 1: Access Author Profile
1. Login to admin panel
2. Go to **Blog** → **Author Profile** (in sidebar)

### Step 2: Upload Photo
1. Click on **"Choose photo..."** button under "Profile Photo"
2. Select an image from your computer
   - Supported formats: JPG, PNG, GIF, WebP
   - Recommended size: 400x400 pixels (square)
   - File will be automatically renamed and saved

3. You'll see a preview of your photo immediately

### Step 3: Complete Your Profile
1. Add/update your bio
2. Add social media links (optional)
3. Click **"Update Profile"** button

### Step 4: View Results
- Click **"View Author Page"** to see your public profile
- Your photo will appear on:
  - All your blog posts (author box)
  - Author page
  - Blog post meta (small avatar)

---

## 🎨 Photo Recommendations

### Best Practices:
- **Size**: 400x400 pixels (square format)
- **Format**: JPG or PNG for best quality
- **File Size**: Keep under 500KB for fast loading
- **Content**: Professional headshot or logo
- **Background**: Clean, simple background works best

### Image Tips:
- Use good lighting
- Center your face in the frame
- Smile and look professional
- Avoid busy backgrounds
- Use high-resolution images

---

## 🔧 Technical Details

### File Handling:
- Files are uploaded to `/images/` folder
- Naming format: `avatar_{user_id}_{timestamp}.{extension}`
- Old avatars are automatically deleted when uploading new ones
- Default avatar: `avatar.png` (if no photo uploaded)

### Security:
- Only image files allowed (JPG, PNG, GIF, WebP)
- File type validation on server side
- Secure file naming prevents conflicts
- Old files cleaned up automatically

### Database:
- Stored in `users` table
- Column: `user_avatar`
- Default value: `avatar.png`

---

## 📍 Where Photos Appear

### 1. Blog Post Page (Single Post)
- Large avatar in author card (88px circle)
- Small avatar in post meta (48px circle)
- Displayed with author bio and social links

### 2. Blog Listing Page
- Author avatar in post cards (if shown)
- Featured post author info

### 3. Author Page
- Large profile photo at top
- Shows all posts by that author

### 4. Admin Panel
- Preview in Author Profile page
- Shows current photo with live preview

---

## 🐛 Troubleshooting

### Photo Not Uploading?
1. Check file format (must be JPG, PNG, GIF, or WebP)
2. Ensure file size is reasonable (under 5MB)
3. Check folder permissions on `/images/` directory
4. Look for error messages after clicking "Update Profile"

### Photo Not Showing?
1. Clear browser cache (Ctrl+F5)
2. Check if file exists in `/images/` folder
3. Verify database has correct filename
4. Check file permissions (should be readable)

### Photo Quality Issues?
1. Upload higher resolution image (at least 400x400px)
2. Use JPG format for photos, PNG for logos
3. Compress image before upload using tools like TinyPNG
4. Avoid uploading very large files (over 2MB)

---

## 💡 Tips for Best Results

### For Personal Blogs:
- Use a professional headshot
- Smile and look approachable
- Update photo every 1-2 years
- Keep consistent across all platforms

### For Business Blogs:
- Use company logo as avatar
- Ensure logo is square format
- Use high-contrast colors
- Keep branding consistent

### For Multiple Authors:
- Each author can upload their own photo
- Encourage all authors to add photos
- Set guidelines for photo style
- Consider using same background/style for consistency

---

## 🔄 Updating Your Photo

To change your photo:
1. Go to **Blog** → **Author Profile**
2. Click **"Choose photo..."**
3. Select new image
4. Click **"Update Profile"**
5. Old photo is automatically deleted

---

## ✨ Features Included

✅ **Live Preview** - See photo before saving
✅ **Auto Cleanup** - Old photos deleted automatically
✅ **File Validation** - Only images allowed
✅ **Responsive Display** - Looks great on all devices
✅ **Circular Avatars** - Modern, professional look
✅ **Multiple Sizes** - Optimized for different contexts
✅ **Easy Management** - Simple upload interface

---

## 📝 Notes

- Default avatar (`avatar.png`) is used if no photo uploaded
- Photos are stored in `/images/` folder with other site images
- Each user can only have one avatar at a time
- File naming includes user ID to prevent conflicts
- Supported by all modern browsers

**Your author profiles are now complete with photo upload functionality! 🎉**
