# 📰 Blog System Installation Guide

## Complete WordPress-Style Blogging System for Your Coupon Site

### Features:
✅ Rich Text Editor (TinyMCE - like WordPress)
✅ Featured Images with CDN support
✅ Categories & Tags
✅ SEO Settings (Title, Description, Meta Tags)
✅ Draft, Published, Scheduled status
✅ Featured Posts
✅ View Counter
✅ Related Posts
✅ Social Sharing
✅ Responsive Design
✅ Image Upload
✅ Admin Dashboard

---

## Step 1: Install Database Tables

1. Open phpMyAdmin
2. Select your database
3. Go to SQL tab
4. Copy and paste the contents of `blog_system_setup.sql`
5. Click "Execute"

This will create:
- `blog_posts` table
- `blog_categories` table  
- `blog_comments` table (for future use)
- Default categories (Tech News, Shopping Tips, Deal Alerts, etc.)
- Sample welcome post

---

## Step 2: Update Routes (Add Blog URLs)

Open `routes.php` and add these routes:

```php
// Blog Routes
$urlPath->blog = function() {
    return SITE_URL . '/blog';
};

$urlPath->blogPost = function($slug) {
    return SITE_URL . '/blog/' . $slug;
};
```

---

## Step 3: Add Blog Link to Navigation

### Option A: Add to Header Menu

Open `header.php` or your navigation file and add:

```php
<li><a href="<?php echo SITE_URL; ?>/blog">Blog</a></li>
```

### Option B: Add to Footer

Open `footer.php` and add:

```php
<li><a href="<?php echo SITE_URL; ?>/blog">Blog</a></li>
```

---

## Step 4: Add Admin Menu Item

Open `admin/views/sidebar.view.php` (or your admin sidebar) and add:

```php
<li>
    <a href="<?php echo ADMIN_URL; ?>/blog">
        <i class="ti ti-article"></i>
        <span>Blog</span>
    </a>
</li>
```

---

## Step 5: Create Admin Routes

Open `admin/index.php` and add these routes:

```php
// Blog Management
case 'blog':
    require './controller/blog.posts.php';
    break;

case 'blog/new':
    require './controller/blog.editor.php';
    break;

case 'blog/edit':
    require './controller/blog.editor.php';
    break;

case 'blog/delete':
    $post_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    if ($post_id > 0) {
        $connect->prepare("DELETE FROM blog_posts WHERE post_id = :id")->execute([':id' => $post_id]);
    }
    header('Location: ' . ADMIN_URL . '/blog');
    exit;
    break;
```

---

## Step 6: Update .htaccess for Clean URLs

Add these rules to your `.htaccess` file:

```apache
# Blog Routes
RewriteRule ^blog$ blog.php [L]
RewriteRule ^blog/([a-zA-Z0-9-]+)$ single-blog.php?slug=$1 [L]
```

---

## Step 7: Test the System

### Frontend:
1. Visit: `http://localhost/alone/blog`
2. You should see the blog listing page
3. Click on the sample post to view single post page

### Admin:
1. Login to admin panel
2. Go to Blog → Posts
3. Click "New Post"
4. Create a test post with:
   - Title
   - Content (use the rich editor)
   - Featured image
   - Category
   - Status: Published
5. Save and view on frontend

---

## Usage Guide

### Creating a New Post:

1. **Admin → Blog → New Post**
2. **Enter Title** - Auto-generates URL slug
3. **Write Content** - Use the rich text editor:
   - Bold, Italic, Underline
   - Headings (H2, H3, H4)
   - Lists (Bullet, Numbered)
   - Links
   - Images
   - Code blocks
   - Tables
4. **Add Featured Image** - Upload or use CDN URL
5. **Select Category** - Tech News, Shopping Tips, etc.
6. **Set Status**:
   - Draft: Save without publishing
   - Published: Live immediately
   - Scheduled: Publish later (future feature)
7. **SEO Settings** - Custom title, description, tags
8. **Click Publish**

### Managing Categories:

Categories are pre-created:
- Tech News
- Shopping Tips
- Deal Alerts
- Product Reviews
- Lifestyle

To add more, insert into `blog_categories` table or create an admin interface.

---

## Customization

### Change Blog URL:
Edit `routes.php` and `.htaccess` to use `/news` or `/articles` instead of `/blog`

### Styling:
- Edit `views/blog.view.php` for blog listing
- Edit `views/single-blog.view.php` for single post
- Uses UIkit CSS framework (already in your theme)

### Editor:
- Uses TinyMCE (free, no API key needed for basic features)
- To get advanced features, sign up at tiny.cloud and replace the API key

---

## Features Explained

### 1. Rich Text Editor
- WordPress-style WYSIWYG editor
- Insert images, videos, links
- Format text with headings, lists, quotes
- Code view for HTML editing

### 2. Featured Images
- Upload from computer
- Or use CDN URL
- Displayed in listings and single post

### 3. SEO Optimization
- Custom SEO title & description
- Auto-generated from post title if empty
- Tags for better categorization

### 4. View Counter
- Tracks how many times post is viewed
- Displayed in admin and frontend

### 5. Featured Posts
- Mark posts as featured
- Displayed in slider on blog homepage

### 6. Related Posts
- Automatically shows 3 related posts
- Based on same category

### 7. Social Sharing
- Facebook, Twitter, LinkedIn, WhatsApp
- One-click sharing buttons

---

## Troubleshooting

### Blog page shows 404:
- Check `.htaccess` rules are added
- Verify `blog.php` exists in root
- Clear browser cache

### Editor not loading:
- Check internet connection (TinyMCE loads from CDN)
- Or download TinyMCE locally

### Images not uploading:
- Check `images/` folder permissions (755 or 777)
- Verify PHP upload_max_filesize setting

### Posts not showing:
- Check post status is "Published"
- Verify database tables were created
- Check `published_at` date is not in future

---

## Next Steps

### Add Comments System:
The `blog_comments` table is ready. Create:
- Comment form on single post page
- Admin moderation interface
- Email notifications

### Add Newsletter:
- Integrate with your existing newsletter system
- Or use Mailchimp/SendGrid API

### Add Search:
- Create blog search functionality
- Filter by category, tags, date

---

## File Structure

```
/blog.php                           - Blog listing page
/single-blog.php                    - Single post page
/views/blog.view.php                - Blog listing template
/views/single-blog.view.php         - Single post template
/admin/controller/blog.posts.php    - Admin posts list
/admin/controller/blog.editor.php   - Admin post editor
/admin/views/blog.posts.view.php    - Admin posts list template
/admin/views/blog.editor.view.php   - Admin editor template
/blog_system_setup.sql              - Database tables
```

---

## Support

If you encounter any issues:
1. Check error logs
2. Verify all files are uploaded
3. Ensure database tables exist
4. Test with a simple post first

---

**Enjoy your new blogging system! 🎉**
