-- ============================================
-- ADD CDN FIELDS TO SLIDERS TABLE
-- ============================================

-- Check if columns exist before adding
ALTER TABLE `sliders` 
ADD COLUMN IF NOT EXISTS `slider_image_cdn_url` VARCHAR(500) DEFAULT '' COMMENT 'CDN image URL',
ADD COLUMN IF NOT EXISTS `slider_use_cdn` TINYINT(1) DEFAULT 0 COMMENT 'Use CDN image (1=yes, 0=no)';

-- For MySQL versions that don't support IF NOT EXISTS, use this instead:
-- ALTER TABLE `sliders` ADD COLUMN `slider_image_cdn_url` VARCHAR(500) DEFAULT '' COMMENT 'CDN image URL';
-- ALTER TABLE `sliders` ADD COLUMN `slider_use_cdn` TINYINT(1) DEFAULT 0 COMMENT 'Use CDN image (1=yes, 0=no)';

-- Verify the columns were added
SELECT 'CDN fields added to sliders table successfully!' as status;

-- Check the table structure
DESCRIBE sliders;
