<?php require'sidebar.php'; ?>

<section class="page-container">
<div class="page-content-wrapper">

<div class="content sm-gutter">
<div class="container-fluid padding-25 sm-padding-10">

<div class="row">
<div class="col-12">
<div class="section-title">
  <h5><i class="fas fa-ban"></i> Ban IP Address</h5>
</div>
</div>
</div>

<div class="row">
<div class="col-md-8">
<div class="card">
<div class="card-body">
<form method="POST" action="">
<div class="form-group">
<label>IP Address <span class="text-danger">*</span></label>
<input type="text" name="ip_address" class="form-control" value="<?php echo htmlspecialchars($ip_address); ?>" required placeholder="192.168.1.1">
<small class="form-text text-muted">Enter the IP address to ban</small>
</div>

<div class="form-group">
<label>Reason</label>
<textarea name="reason" class="form-control" rows="3" placeholder="Reason for banning this IP..."></textarea>
</div>

<div class="form-group">
<label>Ban Type <span class="text-danger">*</span></label>
<select name="ban_type" id="ban_type" class="form-control" required>
<option value="permanent">Permanent Ban</option>
<option value="temporary">Temporary Ban</option>
</select>
</div>

<div class="form-group" id="duration_field" style="display: none;">
<label>Duration (Days)</label>
<input type="number" name="duration_days" class="form-control" min="1" max="365" value="30">
<small class="form-text text-muted">Number of days to ban this IP</small>
</div>

<div class="form-group">
<button type="submit" class="btn btn-danger">Ban IP Address</button>
<a href="./banned_ips.php" class="btn btn-secondary">Cancel</a>
</div>
</form>
</div>
</div>
</div>

<div class="col-md-4">
<div class="card bg-light">
<div class="card-body">
<h6><i class="fas fa-info-circle"></i> Information</h6>
<p class="small mb-2"><strong>Permanent Ban:</strong> The IP will be blocked indefinitely until manually unbanned.</p>
<p class="small mb-0"><strong>Temporary Ban:</strong> The IP will be automatically unbanned after the specified duration.</p>
</div>
</div>
</div>
</div>

</div>
</div>

</section>

<script>
document.getElementById('ban_type').addEventListener('change', function() {
    const durationField = document.getElementById('duration_field');
    if (this.value === 'temporary') {
        durationField.style.display = 'block';
    } else {
        durationField.style.display = 'none';
    }
});
</script>
