<?php require'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="ti ti-shopping-bag"></i> <?php echo _EDITITEM; ?> Product</h5>
            </div>
          </div>

          <div class="col-md-12">

            <div>
              <table>
                <tr>
                  <td><p><b><?php echo _PUBLISHED; ?> </b> <?php echo FormatDate($connect, $product['product_created']); ?></p></td>
                  <td><p><b><?php echo _UPDATED; ?> </b> <?php echo FormatDate($connect, $product['product_updated']); ?></p></td>
                </tr>
              </table>
            </div>

            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?id=<?php echo $product['product_id']; ?>" method="post">

               <input type="hidden" value="<?php echo $product['product_id']; ?>" name="product_id">

               <div class="form-row">
                <div class="form-group col-md-9">
                  <div class="block col-md-12">

                    <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                    <input type="text" value="<?php echo htmlspecialchars($product['product_title']); ?>" name="product_title" class="form-control" required="">

                    <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>
                    <textarea type="text" class="form-control" name="product_description" rows="4"><?php echo htmlspecialchars($product['product_description']); ?></textarea>

                    <label class="control-label required"><?php echo _TABLEFIELDSTORE; ?></label>
                    <select class="custom-select form-control" name="product_store" required="">
                      <option value="">--- Select Store ---</option>
                      <?php
                        foreach($stores as $item){
                          if($product['product_store'] == $item['store_id']){
                            echo '<option value="'.$product['product_store'].'" selected="selected">'.$item['store_title'].'</option>';
                          }else{
                            echo '<option value="'.$item['store_id'].'">'.$item['store_title'].'</option>';
                          }
                        }
                      ?>
                    </select>

                    <label><?php echo _TABLEFIELDCATEGORY; ?></label>
                    <select class="custom-select form-control" name="product_category">
                      <option value="">--- Select Category (Optional) ---</option>
                      <?php
                        foreach($categories as $item){
                          if($product['product_category'] == $item['category_id']){
                            echo '<option value="'.$product['product_category'].'" selected="selected">'.$item['category_title'].'</option>';
                          }else{
                            echo '<option value="'.$item['category_id'].'">'.$item['category_title'].'</option>';
                          }
                        }
                      ?>
                    </select>

                    <div class="row">

                    <div class="col-6">
                      <label>Original Price (₹)</label>
                      <input class="form-control" value="<?php echo $product['product_original_price']; ?>" name="product_original_price" type="number" step="0.01" id="original_price">
                    </div>

                    <div class="col-6">
                      <label>Sale Price (₹)</label>
                      <input class="form-control" value="<?php echo $product['product_sale_price']; ?>" name="product_sale_price" type="number" step="0.01" id="sale_price">
                    </div>

                    </div>

                    <div class="row">
                      <div class="col-6">
                        <label>Discount %</label>
                        <input type="text" value="<?php echo $product['product_discount_percentage'] ? $product['product_discount_percentage'].'%' : ''; ?>" name="product_discount_percentage" class="form-control" id="discount_percentage" readonly style="background: #f5f5f5;">
                        <small class="text-muted">Auto-calculated from prices</small>
                      </div>

                      <div class="col-6">
                        <label>Cashback Info</label>
                        <input type="text" value="<?php echo htmlspecialchars($product['product_cashback']); ?>" name="product_cashback" class="form-control">
                      </div>
                    </div>

                    <label>Affiliate Link</label>
                    <input type="text" value="<?php echo htmlspecialchars($product['product_affiliate_link']); ?>" name="product_affiliate_link" class="form-control">

                    <div class="row">

                    <div class="col-4">

                    <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>

                    <select class="custom-select form-control" name="product_featured">
                      <?php
                      if($product['product_featured'] == 1)
                      {
                        echo '<option value="1" selected="selected">'._YESTEXT.'</option>';
                        echo '<option value="0">'._NOTEXT.'</option>';

                      }
                      else {
                        echo '<option value="0" selected="selected">'._NOTEXT.'</option>';
                        echo '<option value="1">'._YESTEXT.'</option>';
                      }
                      ?>
                    </select>
                    </div>

                    <div class="col-4">
                      <label class="control-label">Display Order</label>
                      <input type="number" name="product_order" class="form-control" value="<?php echo $product['product_order']; ?>">
                      <small class="text-muted">Lower numbers appear first</small>
                    </div>

                    </div>

                  </div>
                </div>
                <div class="form-group col-md-3 sidebar">

                 <div class="block col-md-12">
                   <label><?php echo _TABLEFIELDSTATUS; ?></label>

                   <select class="custom-select form-control" name="product_status" required="">
                    <?php
                    if($product['product_status'] == 1)
                    {
                      echo '<option value="1" selected="selected">'._ENABLED.'</option>';
                      echo '<option value="0">'._DISABLED.'</option>';
                    }
                    else {
                      echo '<option value="0" selected="selected">'._DISABLED.'</option>';
                      echo '<option value="1">'._ENABLED.'</option>';
                    }
                    ?>
                  </select>

                </div>

                <div class="block col-md-12">
                  <label><?php echo _TABLEFIELDIMAGE; ?></label>

                  <input type="hidden" value="<?php echo $product['product_image']; ?>" name="product_image_save">

                  <?php if($product['product_use_cdn'] && $product['product_image_cdn_url']): ?>
                    <div class="edit-image">
                      <img src="<?php echo $product['product_image_cdn_url']; ?>" id="image-preview-edit">
                    </div>
                  <?php elseif($product['product_image']): ?>
                    <div class="edit-image">
                      <img src="<?php echo IMAGES_FOLDER.$product['product_image']; ?>" id="image-preview-edit">
                    </div>
                  <?php else: ?>
                    <div class="edit-image">
                      <img src="../assets/images/no-image.png" id="image-preview-edit">
                    </div>
                  <?php endif; ?>

                  <div class="new-image" id="image-preview">
                    <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                    <input type="file" name="product_image" id="image-upload" accept="image/*" />
                  </div>

                  <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>500 x 500</b> </span>
                  <br/>
                </div>

                <div class="block col-md-12 mt-3">
                  <label>CDN Image URL</label>
                  <input type="text" name="product_image_cdn_url" class="form-control" value="<?php echo htmlspecialchars($product['product_image_cdn_url']); ?>" placeholder="https://cdn.example.com/image.jpg">
                  <small class="text-muted">Or use external CDN URL</small>
                  
                  <div class="mt-2">
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="checkbox" name="product_use_cdn" value="1" <?php echo $product['product_use_cdn'] ? 'checked' : ''; ?> style="width: 18px; height: 18px; margin-right: 8px;">
                      <span>Use CDN URL</span>
                    </label>
                    <small class="text-muted">Check to use CDN URL instead of uploaded image</small>
                  </div>
                </div>

                <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

              </div>

            </div>
          </form>

        </div>
      </div>
    </div>
  </div>
</div>
</div>
</section>

<script>
// Auto-calculate discount percentage
document.getElementById('original_price').addEventListener('input', calculateDiscount);
document.getElementById('sale_price').addEventListener('input', calculateDiscount);

function calculateDiscount() {
  const original = parseFloat(document.getElementById('original_price').value) || 0;
  const sale = parseFloat(document.getElementById('sale_price').value) || 0;
  
  if (original > 0 && sale > 0 && sale < original) {
    const discount = Math.round(((original - sale) / original) * 100);
    document.getElementById('discount_percentage').value = discount + '%';
  } else {
    document.getElementById('discount_percentage').value = '';
  }
}
</script>
