<?php 
// Get user information for sidebar
$user = get_user_information($connect);
$user = $user[0];

require 'sidebar.view.php'; 
?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="fa fa-search"></i> SEO Tools & Sitemap Management</h5>
            </div>
          </div>

          <?php if(isset($success)): ?>
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show">
              <i class="fa fa-check-circle"></i> <?php echo $success; ?>
              <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
            </div>
          </div>
          <?php endif; ?>

          <?php if(isset($error)): ?>
          <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show">
              <i class="fa fa-exclamation-triangle"></i> <?php echo $error; ?>
              <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
            </div>
          </div>
          <?php endif; ?>

          <!-- Stats -->
          <div class="col-md-12 mb-4">
            <div class="card">
              <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fa fa-sitemap"></i> Sitemap Statistics</h6>
              </div>
              <div class="card-body">
                <div class="row text-center">
                  <div class="col-md-3 mb-3">
                    <h3 class="text-primary"><?php echo number_format($totalUrls); ?></h3>
                    <small>Total URLs</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-success"><?php echo number_format($totalPosts); ?></h3>
                    <small>Blog Posts</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-info"><?php echo number_format($totalStores); ?></h3>
                    <small>Stores</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-warning"><?php echo number_format($totalCoupons); ?></h3>
                    <small>Coupons</small>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Actions -->
          <div class="col-md-6 mb-4">
            <div class="card">
              <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fa fa-cog"></i> Sitemap Actions</h6>
              </div>
              <div class="card-body">
                <form method="post">
                  <input type="hidden" name="action" value="generate_sitemap">
                  <button type="submit" class="btn btn-success btn-block mb-3">
                    <i class="fa fa-sync"></i> Generate Sitemap
                  </button>
                </form>
                
                <form method="post">
                  <input type="hidden" name="action" value="submit_sitemap">
                  <button type="submit" class="btn btn-primary btn-block mb-3">
                    <i class="fa fa-paper-plane"></i> Submit to Search Engines (Ping)
                  </button>
                </form>
                
                <a href="<?php echo SITE_URL; ?>/sitemap.xml" target="_blank" class="btn btn-info btn-block mb-3">
                  <i class="fa fa-eye"></i> View Sitemap
                </a>
                
                <button type="button" class="btn btn-secondary btn-block" data-toggle="modal" data-target="#apiInfoModal">
                  <i class="fa fa-info-circle"></i> API Integration Info
                </button>
              </div>
            </div>
          </div>

          <!-- Robots.txt -->
          <div class="col-md-6 mb-4">
            <div class="card">
              <div class="card-header bg-warning text-white">
                <h6 class="mb-0"><i class="fa fa-robot"></i> robots.txt Editor</h6>
              </div>
              <div class="card-body">
                <form method="post">
                  <input type="hidden" name="action" value="update_robots">
                  <textarea name="robots_content" class="form-control" rows="10" style="font-family: monospace;"><?php echo htmlspecialchars($robotsContent); ?></textarea>
                  <button type="submit" class="btn btn-warning btn-block mt-3">
                    <i class="fa fa-save"></i> Update robots.txt
                  </button>
                </form>
              </div>
            </div>
          </div>

          <!-- SEO API Configuration -->
          <div class="col-md-12 mb-4">
            <div class="card">
              <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="fa fa-key"></i> Search Engine API Configuration (Optional)</h6>
              </div>
              <div class="card-body">
                <div class="alert alert-info">
                  <strong>Current Method:</strong> Using public ping endpoints (no authentication required)<br>
                  <strong>Upgrade:</strong> Configure API credentials below for advanced features like indexing status, crawl errors, and detailed reports.
                </div>
                
                <form method="post">
                  <input type="hidden" name="action" value="save_api_config">
                  
                  <div class="row">
                    <div class="col-md-6">
                      <h6>Google Search Console API</h6>
                      <div class="form-group">
                        <label>Service Account JSON</label>
                        <textarea name="google_service_account" class="form-control" rows="4" placeholder='{"type": "service_account", "project_id": "..."}'><?php echo isset($apiConfig['google_service_account']) ? htmlspecialchars($apiConfig['google_service_account']) : ''; ?></textarea>
                        <small class="form-text text-muted">
                          <a href="https://console.cloud.google.com/apis/credentials" target="_blank">Get credentials</a>
                        </small>
                      </div>
                    </div>
                    
                    <div class="col-md-6">
                      <h6>Bing Webmaster API</h6>
                      <div class="form-group">
                        <label>API Key</label>
                        <input type="text" name="bing_api_key" class="form-control" value="<?php echo isset($apiConfig['bing_api_key']) ? htmlspecialchars($apiConfig['bing_api_key']) : ''; ?>" placeholder="Enter Bing API Key">
                        <small class="form-text text-muted">
                          <a href="https://www.bing.com/webmasters" target="_blank">Get API key</a>
                        </small>
                      </div>
                    </div>
                  </div>
                  
                  <button type="submit" class="btn btn-info">
                    <i class="fa fa-save"></i> Save API Configuration
                  </button>
                </form>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>

<!-- API Info Modal -->
<div class="modal fade" id="apiInfoModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Sitemap Submission Methods</h5>
        <button type="button" class="close" data-dismiss="modal">
          <span>&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6>Current Method: Public Ping Endpoints</h6>
        <p>The system currently uses free public endpoints that don't require authentication:</p>
        <ul>
          <li><strong>Google:</strong> https://www.google.com/ping?sitemap=YOUR_URL</li>
          <li><strong>Bing:</strong> https://www.bing.com/ping?sitemap=YOUR_URL</li>
        </ul>
        
        <div class="alert alert-warning">
          <strong>Limitations:</strong>
          <ul class="mb-0">
            <li>No confirmation of successful submission</li>
            <li>No indexing status reports</li>
            <li>No crawl error notifications</li>
            <li>Limited to sitemap submission only</li>
          </ul>
        </div>
        
        <hr>
        
        <h6>Upgrade to API Integration</h6>
        <p>For advanced features, configure API credentials:</p>
        
        <div class="row">
          <div class="col-md-6">
            <h6 class="text-primary">Google Search Console API</h6>
            <p><strong>Benefits:</strong></p>
            <ul>
              <li>Submit individual URLs for indexing</li>
              <li>Check indexing status</li>
              <li>View crawl errors</li>
              <li>Get search analytics data</li>
              <li>Monitor Core Web Vitals</li>
            </ul>
            <p><strong>Setup:</strong></p>
            <ol>
              <li>Go to <a href="https://console.cloud.google.com" target="_blank">Google Cloud Console</a></li>
              <li>Create a project and enable Search Console API</li>
              <li>Create a Service Account</li>
              <li>Download JSON key file</li>
              <li>Add service account email to Search Console</li>
            </ol>
          </div>
          
          <div class="col-md-6">
            <h6 class="text-info">Bing Webmaster API</h6>
            <p><strong>Benefits:</strong></p>
            <ul>
              <li>Submit URLs for crawling</li>
              <li>Get crawl stats</li>
              <li>View keyword data</li>
              <li>Monitor site health</li>
              <li>Access SEO reports</li>
            </ul>
            <p><strong>Setup:</strong></p>
            <ol>
              <li>Go to <a href="https://www.bing.com/webmasters" target="_blank">Bing Webmaster Tools</a></li>
              <li>Add and verify your site</li>
              <li>Go to Settings → API Access</li>
              <li>Generate API Key</li>
              <li>Copy and save the key</li>
            </ol>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
