// Initialize Swiper Hero Slider
document.addEventListener('DOMContentLoaded', function() {
    var heroSwiper = new Swiper(".heroSwiper", {
        slidesPerView: 1,
        spaceBetween: 0,
        loop: true,
        loopAdditionalSlides: 2,
        autoplay: {
            delay: 5000,
            disableOnInteraction: false,
        },
        speed: 800,
        effect: 'slide',
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
            dynamicBullets: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        keyboard: {
            enabled: true,
        },
        mousewheel: false,
        grabCursor: true,
    });

    // Initialize Campaigns Slider
    var campaignsSwiper = new Swiper(".campaigns-swiper", {
        slidesPerView: 2, // 2 images on mobile
        spaceBetween: 15,
        loop: false,
        speed: 600,
        autoplay: {
            delay: 3000,
            disableOnInteraction: false,
            pauseOnMouseEnter: true,
        },
        pagination: {
            el: ".campaigns-pagination",
            clickable: true,
            dynamicBullets: false,
        },
        keyboard: {
            enabled: true,
        },
        grabCursor: true,
        breakpoints: {
            640: {
                slidesPerView: 2,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 3, // 3 images on tablet
                spaceBetween: 20,
            },
            960: {
                slidesPerView: 3, // 3 images on small desktop
                spaceBetween: 24,
            },
            1200: {
                slidesPerView: 4, // 4 images on large desktop
                spaceBetween: 24,
            },
        },
    });

    // Initialize Categories Slider
    var categoriesSwiper = new Swiper(".categories-swiper", {
        slidesPerView: 2,
        spaceBetween: 20,
        loop: false,
        speed: 600,
        autoplay: {
            delay: 3500,
            disableOnInteraction: false,
            pauseOnMouseEnter: true,
        },
        pagination: {
            el: ".categories-pagination",
            clickable: true,
            dynamicBullets: false,
        },
        keyboard: {
            enabled: true,
        },
        grabCursor: true,
        breakpoints: {
            480: {
                slidesPerView: 2,
                spaceBetween: 16,
            },
            640: {
                slidesPerView: 3,
                spaceBetween: 18,
            },
            960: {
                slidesPerView: 4,
                spaceBetween: 20,
            },
            1200: {
                slidesPerView: 5,
                spaceBetween: 24,
            },
        },
    });
});
