<!-- Collapsible Categories Section -->
<div class="uk-margin-medium-top">
    <hr class="uk-margin-medium-top uk-margin-medium-bottom">
    
    <!-- CSS loaded in header-css.php -->
    
    <div class="footer-categories-section">
        <div class="uk-container">
            <h3 class="footer-categories-title">Categories</h3>
            <div class="footer-categories-grid uk-grid-small" uk-grid>
            <?php 
            foreach($getCategories as $category): 
                $subcategories = getSubCategories($connect, $category['category_id']);
                $hasSubcategories = is_array($subcategories) && count($subcategories) > 0;
            ?>
            <div class="uk-width-1-1 uk-width-1-2@s uk-width-1-3@m uk-width-1-5@l">
                <div class="footer-category-item">
                    <div class="footer-category-header">
                        <a href="<?php echo $urlPath->category($category['category_slug']); ?>" class="footer-category-title">
                            <?php echo echoOutput($category['category_title']); ?>
                            <span class="category-count-badge"><?php echo isset($category['total_items']) ? (int)$category['total_items'] : 0; ?></span>
                        </a>
                        <?php if($hasSubcategories): ?>
                        <button class="footer-category-toggle" type="button" aria-label="Toggle subcategories">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor">
                                <path d="M8 11L3 6h10l-5 5z"/>
                            </svg>
                        </button>
                        <?php endif; ?>
                    </div>
                    <?php if($hasSubcategories): ?>
                    <ul class="footer-subcategories">
                        <?php foreach($subcategories as $subcategory): ?>
                        <li>
                            <a href="<?php echo $urlPath->subcategory($subcategory['subcategory_slug'], $category['category_slug']); ?>">
                                <?php echo echoOutput($subcategory['subcategory_title']); ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<script>
// Footer Categories Toggle Functionality
document.addEventListener('DOMContentLoaded', function() {
    const toggleButtons = document.querySelectorAll('.footer-category-toggle');
    
    toggleButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const categoryItem = this.closest('.footer-category-item');
            const subcategories = categoryItem.querySelector('.footer-subcategories');
            
            if (subcategories) {
                // Toggle active class
                this.classList.toggle('active');
                subcategories.classList.toggle('active');
            }
        });
    });
});
</script>
