<?php

require "core.php";
require "includes/breadcrumb_schema.php";
require "includes/advanced_seo_system.php";
require "includes/image_seo_optimizer.php";
require "includes/internal_linking_engine.php";
require "includes/performance_optimizer.php";

// Get Item Slug
$itemId = clearGetData(getItemId());

if(empty($itemId)){

	header('Location: '. $urlPath->home());
}

// Page Details
$itemDetails = getCouponById($connect, $itemId);

if(empty($itemDetails)){

	header('Location: '. $urlPath->error());
}

$itemsGallery = getItemsGallery($connect, $itemId);

// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['coupon_seotitle']) ? $itemDetails['coupon_title'] : $itemDetails['coupon_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['coupon_description'], $itemDetails['coupon_seodescription']);

// Canonical URL
$canonicalUrl = SITE_URL . '/coupon/' . $itemDetails['coupon_slug'];

// Generate Breadcrumb Schema
$storeName = '';
$storeSlug = '';
if (!empty($itemDetails['store_id'])) {
    $storeData = $connect->query("SELECT store_title, store_slug FROM stores WHERE store_id = " . $itemDetails['store_id'])->fetch(PDO::FETCH_ASSOC);
    if ($storeData) {
        $storeName = $storeData['store_title'];
        $storeSlug = $storeData['store_slug'];
    }
}

$breadcrumb = BreadcrumbSchema::forCoupon(
    $itemDetails['coupon_title'],
    $itemDetails['coupon_slug'],
    $storeName,
    $storeSlug
);

// Initialize SEO System
$seo = new AdvancedSEOSystem($connect, 'https://alonedeals.com');

// Initialize SEO Optimizers
$imageSEO = new ImageSEOOptimizer($connect);
$linkEngine = new InternalLinkingEngine($connect);
$perfOptimizer = new PerformanceOptimizer();

// Optimize coupon description
$itemDetails['coupon_description'] = $imageSEO->optimizeContentImages(
    $itemDetails['coupon_description'],
    [
        'title' => $itemDetails['coupon_title'],
        'store' => $storeName
    ]
);

// Generate related content widget
$relatedContentWidget = $linkEngine->generateRelatedWidget(
    $itemDetails['coupon_id'],
    'coupon',
    $itemDetails['coupon_title'] . ' ' . $itemDetails['coupon_description']
);


// Page Title
$pageTitle = $itemDetails['coupon_title'];

if (isLogged()) {

$isFav = isInFav($connect, $userInfo['user_id'], $itemId);

}

include './header.php';
require './views/single-coupon.view.php';
include './footer.php';

?>