<?php

require "core.php";
require "includes/breadcrumb_schema.php";
require "includes/advanced_seo_system.php";
require "includes/image_seo_optimizer.php";
require "includes/internal_linking_engine.php";
require "includes/performance_optimizer.php";

$slugItem = clearGetData(getSlugItem());

if(empty($slugItem) && !isset($slugItem)){

	header('Location: '. $urlPath->home());
}

// Get ID By Slug
$itemDetails = getStoreBySlug($connect, $slugItem);

if(empty($itemDetails)){

	header('Location: '. $urlPath->home());
	
}

$getResults = getCouponsByStore($connect, $site_config['page_limit'], $itemDetails['store_id']);

$items = $getResults['items'];
$total = $getResults['total'];

$numPages = numTotalPages($total, $site_config['page_limit']);

// Get campaigns for this store
$storeCampaigns = getCampaignsByStore($connect, $itemDetails['store_id']);

// Generate Breadcrumb Schema
$breadcrumb = BreadcrumbSchema::forStore(
    $itemDetails['store_title'],
    $itemDetails['store_slug']
);

// Initialize SEO System
$seo = new AdvancedSEOSystem($connect, 'https://alonedeals.com');

// Initialize SEO Optimizers
$imageSEO = new ImageSEOOptimizer($connect);
$linkEngine = new InternalLinkingEngine($connect);
$perfOptimizer = new PerformanceOptimizer();

// Optimize store description
$itemDetails['store_description'] = $imageSEO->optimizeContentImages(
    $itemDetails['store_description'],
    [
        'title' => $itemDetails['store_title'],
        'store' => $itemDetails['store_title']
    ]
);

// Generate related content widget
$relatedContentWidget = $linkEngine->generateRelatedWidget(
    $itemDetails['store_id'],
    'store',
    $itemDetails['store_title'] . ' ' . $itemDetails['store_description']
);


// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['store_seotitle']) ? $itemDetails['store_title'] : $itemDetails['store_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['store_description'], $itemDetails['store_seodescription']);

// Canonical URL
$canonicalUrl = SITE_URL . '/store/' . $itemDetails['store_slug'];

// Page Title
$pageTitle = $itemDetails['store_title'];

include './header.php';
require './views/single-store.view.php';
include './footer.php';

?>