<?php
header('Content-Type: application/xml; charset=utf-8');

require './core.php';
$connect = connect($database);

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">
    
    <!-- Homepage -->
    <url>
        <loc><?php echo SITE_URL; ?></loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    
    <!-- Static Pages -->
    <url>
        <loc><?php echo SITE_URL; ?>/stores</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>
    <url>
        <loc><?php echo SITE_URL; ?>/categories</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>
    
    <!-- Stores -->
    <?php
    $stores = $connect->query("SELECT store_slug, store_image, store_updated FROM stores WHERE store_status = 1 ORDER BY store_id DESC")->fetchAll();
    foreach ($stores as $store):
        $lastmod = $store['store_updated'] ? date('Y-m-d', strtotime($store['store_updated'])) : date('Y-m-d');
    ?>
    <url>
        <loc><?php echo SITE_URL . '/store/' . htmlspecialchars($store['store_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
        <?php if (!empty($store['store_image'])): ?>
        <image:image>
            <image:loc><?php echo SITE_URL . '/images/' . htmlspecialchars($store['store_image']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($store['store_slug']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Categories -->
    <?php
    $categories = $connect->query("SELECT category_slug, category_image, category_title FROM categories WHERE category_status = 1 ORDER BY category_id DESC")->fetchAll();
    foreach ($categories as $category):
    ?>
    <url>
        <loc><?php echo SITE_URL . '/category/' . htmlspecialchars($category['category_slug']); ?></loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
        <?php if (!empty($category['category_image'])): ?>
        <image:image>
            <image:loc><?php echo SITE_URL . '/images/' . htmlspecialchars($category['category_image']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($category['category_title']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Active Coupons (Limited to 1000 for performance) -->
    <?php
    $coupons = $connect->query("SELECT coupon_slug, coupon_updated FROM coupons WHERE coupon_status = 1 AND (coupon_expire IS NULL OR coupon_expire >= CURDATE()) ORDER BY coupon_id DESC LIMIT 1000")->fetchAll();
    foreach ($coupons as $coupon):
        $lastmod = $coupon['coupon_updated'] ? date('Y-m-d', strtotime($coupon['coupon_updated'])) : date('Y-m-d');
    ?>
    <url>
        <loc><?php echo SITE_URL . '/coupon/' . htmlspecialchars($coupon['coupon_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    <?php endforeach; ?>
    
</urlset>
