<?php
// Enable all error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "Step 1: Starting script<br>";

session_start();
echo "Step 2: Session started<br>";

require '../../config.php';
echo "Step 3: Config loaded<br>";

require '../admin_config.php';
echo "Step 4: Admin config loaded<br>";

require '../functions.php';
echo "Step 5: Functions loaded<br>";

echo "Step 6: Checking session - ";
if (isset($_SESSION['user_email'])){
    echo "User logged in: " . $_SESSION['user_email'] . "<br>";
} else {
    echo "No user session<br>";
    die("Please login first");
}

echo "Step 7: Connecting to database<br>";
try {
    $connect = connect($database);
    echo "Step 8: Database connected<br>";
} catch (Exception $e) {
    die("Database error: " . $e->getMessage());
}

if(!$connect){
    die("Database connection failed");
}

echo "Step 9: Checking access<br>";
$check_access = check_access($connect);
echo "Step 10: User role: " . $check_access['user_role'] . "<br>";

if ($check_access['user_role'] == 1){
    echo "Step 11: Admin access confirmed<br>";
    
    echo "Step 12: Counting pages...<br>";
    try {
        $totalPages = $connect->query("SELECT COUNT(*) FROM pages WHERE page_status = 1")->fetchColumn();
        echo "Total pages: $totalPages<br>";
    } catch (Exception $e) {
        echo "Error counting pages: " . $e->getMessage() . "<br>";
        $totalPages = 0;
    }
    
    echo "Step 13: Counting posts...<br>";
    try {
        $totalPosts = $connect->query("SELECT COUNT(*) FROM blog_posts WHERE post_status = 'published'")->fetchColumn();
        echo "Total posts: $totalPosts<br>";
    } catch (Exception $e) {
        echo "Error counting posts: " . $e->getMessage() . "<br>";
        $totalPosts = 0;
    }
    
    echo "Step 14: Getting robots.txt<br>";
    $robotsContent = file_exists('../../robots.txt') ? file_get_contents('../../robots.txt') : '';
    echo "Robots.txt length: " . strlen($robotsContent) . "<br>";
    
    $totalUrls = $totalPages + $totalPosts + 10;
    
    echo "Step 15: About to include header.view.php<br>";
    require '../views/header.view.php';
    echo "Step 16: Header included<br>";
    
    echo "Step 17: About to include seo_tools.view.php<br>";
    require '../views/seo_tools.view.php';
    echo "Step 18: SEO tools view included<br>";
    
    echo "Step 19: About to include footer<br>";
    require '../views/footer.view.php';
    echo "Step 20: Footer included<br>";
    
} else {
    echo "Access denied - not admin<br>";
}

echo "Step 21: Script completed<br>";
?>
