<?php
// Blog Posts View
require 'sidebar.php';
?>

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
     "bProcessing": true,
     "sAjaxSource": "../controller/get_blog_posts.php",
     "responsive": true,
     "bPaginate":true,
     "sPaginationType":"full_numbers",
     "iDisplayLength": 10,
     "aoColumns": [
     { mData: 'post_id', "width": "5%", "className": "text-center" },
     { "mData": null, "width": "8%", "className": "text-center",
       "mRender": function(data) {
         if (data.post_featured_image) {
           var imgSrc = data.post_use_cdn == 1 && data.post_featured_image_cdn_url 
             ? data.post_featured_image_cdn_url 
             : '../../images/' + data.post_featured_image;
           return '<img src="' + imgSrc + '" style="width:60px;height:60px;object-fit:cover;border-radius:4px;">';
         }
         return '<div style="width:60px;height:60px;background:#f0f0f0;border-radius:4px;display:flex;align-items:center;justify-content:center;"><i class="fa fa-image" style="color:#999;"></i></div>';
       }
     },
     { "mData": null,
       "mRender": function(data) {
         var featured = data.post_featured == 1 ? '<span class="badge badge-warning ml-2">Featured</span>' : '';
         return '<strong>' + data.post_title + '</strong>' + featured;
       }
     },
     { mData: 'blog_cat_name', "width": "12%" },
     { mData: 'user_name', "width": "10%" },
     { "mData": null, "width": "10%", "className": "text-center",
       "mRender": function(data) {
         if (data.post_status == 'published') {
           return '<span class="badge badge-pill bg-success">Published</span>';
         } else if (data.post_status == 'draft') {
           return '<span class="badge badge-pill bg-secondary">Draft</span>';
         } else {
           return '<span class="badge badge-pill bg-warning">Scheduled</span>';
         }
       }
     },
     { "mData": null, "width": "8%", "className": "text-center",
       "mRender": function(data) {
         return data.post_views.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
       }
     },
     { "mData": null, "width": "10%", "className": "text-center",
       "mRender": function(data) {
         var date = new Date(data.created_at);
         return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
       }
     },
     { "mData": null,
       "width": "15%",
       "className": "text-center",
       'orderable': false,
       'searchable': false,
       "mRender": function(data) {
         var buttons = "<a class='btn btn-small btn-primary' href='../controller/edit_blog.php?id=" + data.post_id + "' title='Edit'><i class='fa fa-edit'></i></a> ";
         buttons += "<a class='btn btn-small btn-info' href='../controller/blog_preview.php?id=" + data.post_id + "' target='_blank' title='Preview'><i class='fa fa-eye'></i></a> ";
         if (data.post_status == 'published') {
           buttons += "<a class='btn btn-small btn-success' href='<?php echo SITE_URL; ?>/blog/" + data.post_slug + "' target='_blank' title='View Live'><i class='fa fa-external-link-alt'></i></a> ";
         }
         buttons += "<a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_blog.php?id=" + data.post_id + "' title='Delete'><i class='fa fa-trash'></i></a>";
         return buttons;
       }
     }
     ]
    });
  });
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><i class="dripicons-article"></i> Blog Posts</h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_blog.php">
              <i class="fa fa-plus add-new-i"></i> New Post
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th>ID</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Category</th>
                        <th>Author</th>
                        <th>Status</th>
                        <th>Views</th>
                        <th>Date</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
