<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fetch CueLinks Coupons - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/uikit.min.css">
    <link rel="stylesheet" href="../assets/css/tabler-icons.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .coupon-preview-card {
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        .coupon-preview-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            border-color: #ed174f;
        }
        .coupon-preview-card.selected {
            background: #fff3f6;
            border-color: #ed174f;
        }
        .coupon-image-preview {
            width: 100px;
            height: 60px;
            object-fit: cover;
            border-radius: 4px;
        }
        .stats-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
        }
        .stats-box h3 {
            margin: 0;
            font-size: 32px;
        }
        .stats-box p {
            margin: 5px 0 0 0;
        }
        .action-buttons {
            position: sticky;
            top: 20px;
            background: white;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>

<?php require '../views/sidebar.view.php'; ?>

<div class="tas-content">
    <?php require '../views/header.view.php'; ?>

    <div class="uk-container uk-container-large uk-margin-top">
        <h2><i class="ti ti-download"></i> Fetch CueLinks Coupons</h2>

        <?php if ($message): ?>
        <div class="uk-alert-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><i class="ti ti-check"></i> <?php echo htmlspecialchars($message); ?></p>
        </div>
        <?php endif; ?>

        <?php if ($error): ?>
        <div class="uk-alert-danger" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><i class="ti ti-alert-circle"></i> <?php echo htmlspecialchars($error); ?></p>
        </div>
        <?php endif; ?>

        <div class="uk-grid-medium" uk-grid>
            <div class="uk-width-2-3@m">
                <?php if (empty($fetched_coupons)): ?>
                <div class="uk-card uk-card-default uk-card-body uk-text-center">
                    <i class="ti ti-cloud-download" style="font-size: 64px; color: #ccc;"></i>
                    <h3>No Coupons Fetched Yet</h3>
                    <p>Click the "Fetch Coupons" button to retrieve offers from CueLinks API</p>
                    
                    <form method="POST">
                        <input type="hidden" name="action" value="fetch">
                        <button class="uk-button uk-button-primary uk-button-large" type="submit">
                            <i class="ti ti-refresh"></i> Fetch Coupons from CueLinks
                        </button>
                    </form>
                </div>
                <?php else: ?>
                <div class="uk-card uk-card-default uk-card-body">
                    <h3>Fetched Coupons (<?php echo count($fetched_coupons); ?>)</h3>
                    <p class="uk-text-muted">Select coupons to import into your database</p>

                    <div id="coupons-list">
                        <?php foreach ($fetched_coupons as $index => $coupon): ?>
                        <div class="coupon-preview-card" data-index="<?php echo $index; ?>">
                            <label class="uk-width-1-1" style="cursor: pointer;">
                                <div class="uk-grid-small uk-flex-middle" uk-grid>
                                    <div class="uk-width-auto">
                                        <input class="uk-checkbox coupon-checkbox" type="checkbox" 
                                               value="<?php echo $index; ?>" checked>
                                    </div>
                                    <?php if (!empty($coupon['image'])): ?>
                                    <div class="uk-width-auto">
                                        <img src="<?php echo htmlspecialchars($coupon['image']); ?>" 
                                             class="coupon-image-preview" alt="Coupon">
                                    </div>
                                    <?php endif; ?>
                                    <div class="uk-width-expand">
                                        <h4 class="uk-margin-remove"><?php echo htmlspecialchars($coupon['title'] ?? 'Untitled Offer'); ?></h4>
                                        <p class="uk-text-small uk-text-muted uk-margin-remove">
                                            <?php echo htmlspecialchars($coupon['merchant'] ?? 'Unknown Store'); ?>
                                        </p>
                                        <?php if (!empty($coupon['code'])): ?>
                                        <span class="uk-badge">Code: <?php echo htmlspecialchars($coupon['code']); ?></span>
                                        <?php else: ?>
                                        <span class="uk-badge uk-badge-success">Deal</span>
                                        <?php endif; ?>
                                        <?php if (!empty($coupon['end_date'])): ?>
                                        <span class="uk-text-small">
                                            <i class="ti ti-clock"></i> Expires: <?php echo htmlspecialchars($coupon['end_date']); ?>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </label>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <div class="uk-width-1-3@m">
                <div class="action-buttons">
                    <?php if (!empty($fetched_coupons)): ?>
                    <div class="stats-box uk-margin-bottom">
                        <h3 id="selected-count"><?php echo count($fetched_coupons); ?></h3>
                        <p>Coupons Selected</p>
                    </div>

                    <button class="uk-button uk-button-primary uk-width-1-1 uk-margin-small-bottom" 
                            onclick="importSelected()">
                        <i class="ti ti-upload"></i> Import Selected
                    </button>

                    <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom" 
                            onclick="selectAll()">
                        <i class="ti ti-checkbox"></i> Select All
                    </button>

                    <button class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom" 
                            onclick="deselectAll()">
                        <i class="ti ti-square"></i> Deselect All
                    </button>
                    <?php endif; ?>

                    <form method="POST" class="uk-margin-top">
                        <input type="hidden" name="action" value="fetch">
                        <button class="uk-button uk-button-secondary uk-width-1-1" type="submit">
                            <i class="ti ti-refresh"></i> Fetch New Coupons
                        </button>
                    </form>

                    <a href="../controller/cuelinks_config.php" class="uk-button uk-button-default uk-width-1-1 uk-margin-small-top">
                        <i class="ti ti-settings"></i> Configuration
                    </a>
                </div>

                <?php if ($import_stats['total'] > 0): ?>
                <div class="uk-card uk-card-default uk-card-body uk-margin-top">
                    <h4>Import Statistics</h4>
                    <ul class="uk-list">
                        <li><i class="ti ti-check" style="color: green;"></i> Imported: <?php echo $import_stats['imported']; ?></li>
                        <li><i class="ti ti-minus" style="color: orange;"></i> Skipped: <?php echo $import_stats['skipped']; ?></li>
                        <li><i class="ti ti-x" style="color: red;"></i> Errors: <?php echo $import_stats['errors']; ?></li>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<form id="import-form" method="POST" style="display: none;">
    <input type="hidden" name="action" value="import">
    <input type="hidden" name="selected_coupons" id="selected-coupons-data">
</form>

<script src="../assets/js/uikit.min.js"></script>
<script>
const couponsData = <?php echo json_encode($fetched_coupons); ?>;

function updateSelectedCount() {
    const checked = document.querySelectorAll('.coupon-checkbox:checked').length;
    document.getElementById('selected-count').textContent = checked;
}

function selectAll() {
    document.querySelectorAll('.coupon-checkbox').forEach(cb => {
        cb.checked = true;
        cb.closest('.coupon-preview-card').classList.add('selected');
    });
    updateSelectedCount();
}

function deselectAll() {
    document.querySelectorAll('.coupon-checkbox').forEach(cb => {
        cb.checked = false;
        cb.closest('.coupon-preview-card').classList.remove('selected');
    });
    updateSelectedCount();
}

function importSelected() {
    const selected = [];
    document.querySelectorAll('.coupon-checkbox:checked').forEach(cb => {
        const index = parseInt(cb.value);
        selected.push(couponsData[index]);
    });
    
    if (selected.length === 0) {
        UIkit.notification('Please select at least one coupon to import', {status: 'warning'});
        return;
    }
    
    document.getElementById('selected-coupons-data').value = JSON.stringify(selected);
    document.getElementById('import-form').submit();
}

// Handle checkbox changes
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.coupon-checkbox').forEach(cb => {
        cb.addEventListener('change', function() {
            const card = this.closest('.coupon-preview-card');
            if (this.checked) {
                card.classList.add('selected');
            } else {
                card.classList.remove('selected');
            }
            updateSelectedCount();
        });
        
        // Initialize selected state
        if (cb.checked) {
            cb.closest('.coupon-preview-card').classList.add('selected');
        }
    });
});
</script>

</body>
</html>
