<?php require'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _ADDITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">

                <div class="form-row">
                  <div class="form-group col-md-9">
                    <div class="block col-md-12">

                      <label class="required"><?php echo _TABLEFIELDTITLE; ?></label>
                      <input type="text" placeholder="" name="store_title" class="form-control" required="">

                      <label><?php echo _TABLEFIELDDESCRIPTION; ?></label>

                      <textarea type="text" class="mceNoEditor form-control" name="store_description"></textarea>

                   <label class="control-label"><?php echo _TABLEFIELDFEATURED; ?></label>
                   <select class="custom-select form-control" name="store_featured">
                     <option value="0"><?php echo _NOTEXT; ?></option>
                     <option value="1"><?php echo _YESTEXT; ?></option>
                   </select>

                      <br>
                      <br>

                      <fieldset>
                        <legend><?php echo _SEO; ?></legend>

                        <label class="no-margin-top"><?php echo _SEOTITLE; ?></label>
                        <input type="text" name="store_seotitle" class="form-control">

                        <label><?php echo _SEODESCRIPTION; ?></label>
                        <textarea type="text" class="mceNoEditor form-control" name="store_seodescription"></textarea>

                      </fieldset>

                    </div>
                  </div>
                  <div class="form-group col-md-3 sidebar">

               <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDSTATUS; ?></label>

                 <select class="custom-select form-control" name="store_status">
                  <option value="1" selected=""><?php echo _ENABLED; ?></option>
                  <option value="0"><?php echo _DISABLED; ?></option>
                </select>

              </div>

              <div class="block col-md-12">
                 <label><?php echo _TABLEFIELDCATEGORY; ?></label>
                 
                 <?php 
                 // Group subcategories by parent
                 $subcategories_by_parent = array();
                 foreach($all_subcategories as $sub) {
                   if (!isset($subcategories_by_parent[$sub['subcategory_parent']])) {
                     $subcategories_by_parent[$sub['subcategory_parent']] = array();
                   }
                   $subcategories_by_parent[$sub['subcategory_parent']][] = $sub;
                 }
                 ?>
                 
                 <label>Parent Category</label>
                 <select class="form-control" name="parent_category" id="parent_category" onchange="updateSubcategories()" required>
                   <option value="">-- Select Parent Category --</option>
                   <?php foreach($categories as $category): ?>
                     <option value="<?php echo $category['category_id']; ?>">
                       <?php echo htmlspecialchars($category['category_title']); ?>
                     </option>
                   <?php endforeach; ?>
                 </select>
                 
                 <label class="mt-3">Subcategory (Optional)</label>
                 <select class="form-control" name="subcategory" id="subcategory">
                   <option value="">-- No Subcategory --</option>
                 </select>
                 
                 <small class="form-text text-muted mt-2">
                   <i class="fa fa-info-circle"></i> Select a parent category first, then optionally select a subcategory. The store will be assigned to both.
                 </small>
                 
                 <script>
                 // Subcategory data
                 var subcategoryData = <?php echo json_encode($subcategories_by_parent); ?>;
                 
                 function updateSubcategories() {
                   var parentId = document.getElementById('parent_category').value;
                   var subcategorySelect = document.getElementById('subcategory');
                   
                   // Clear existing options
                   subcategorySelect.innerHTML = '<option value="">-- No Subcategory --</option>';
                   
                   // Add subcategories for selected parent
                   if (parentId && subcategoryData[parentId]) {
                     subcategoryData[parentId].forEach(function(sub) {
                       var option = document.createElement('option');
                       option.value = sub.subcategory_id;
                       option.textContent = sub.subcategory_title;
                       subcategorySelect.appendChild(option);
                     });
                   }
                 }
                 </script>

              </div>

                    <div class="block col-md-12">
                      <label class="required"><?php echo _TABLEFIELDIMAGE; ?></label>

                      <div class="uk-margin-small">
                        <label class="uk-form-label" style="font-weight: normal; font-size: 13px;">
                          <input type="radio" name="image_type" value="upload" class="uk-radio" checked onchange="toggleImageInput()"> Upload File
                        </label>
                        <label class="uk-form-label" style="font-weight: normal; font-size: 13px; margin-left: 15px;">
                          <input type="radio" name="image_type" value="url" class="uk-radio" onchange="toggleImageInput()"> Image URL
                        </label>
                      </div>

                      <div id="upload-section">
                        <div class="new-image" id="image-preview">
                          <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                          <input type="file" name="store_image" id="image-upload" />
                        </div>
                      </div>

                      <div id="url-section" style="display: none;">
                        <input type="url" name="image_url" id="image_url" class="form-control" placeholder="https://example.com/logo.png" onkeyup="previewImageUrl()">
                        <div id="url-preview" style="margin-top: 10px; text-align: center;"></div>
                      </div>

                      <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>350 x 350</b> </span>
                      <br/>
                    </div>

                    <script>
                    function toggleImageInput() {
                      const uploadSection = document.getElementById('upload-section');
                      const urlSection = document.getElementById('url-section');
                      const imageUpload = document.getElementById('image-upload');
                      const imageUrl = document.getElementById('image_url');
                      
                      if (document.querySelector('input[name="image_type"]:checked').value === 'url') {
                        uploadSection.style.display = 'none';
                        urlSection.style.display = 'block';
                        imageUpload.removeAttribute('required');
                        imageUrl.setAttribute('required', 'required');
                      } else {
                        uploadSection.style.display = 'block';
                        urlSection.style.display = 'none';
                        imageUpload.setAttribute('required', 'required');
                        imageUrl.removeAttribute('required');
                      }
                    }
                    
                    function previewImageUrl() {
                      const url = document.getElementById('image_url').value;
                      const preview = document.getElementById('url-preview');
                      
                      if (url && isValidImageUrl(url)) {
                        preview.innerHTML = '<img src="' + url + '" style="max-width: 200px; max-height: 200px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">';
                      } else {
                        preview.innerHTML = '';
                      }
                    }
                    
                    function isValidImageUrl(url) {
                      return url.match(/\.(jpeg|jpg|gif|png|webp|svg)$/i) != null || url.includes('image');
                    }
                    </script>

                    <button class="btn btn-primary" type="submit" name="save"><?php echo _SAVECHANGES; ?></button>

                  </div>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>