<?php 
// Get user information for sidebar
$user = get_user_information($connect);
$user = $user[0];

require 'sidebar.view.php'; 
?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><i class="fa fa-search"></i> SEO Tools & Sitemap Management</h5>
            </div>
          </div>

          <?php if(isset($success)): ?>
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show">
              <i class="fa fa-check-circle"></i> <?php echo $success; ?>
              <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
            </div>
          </div>
          <?php endif; ?>

          <?php if(isset($error)): ?>
          <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show">
              <i class="fa fa-exclamation-triangle"></i> <?php echo $error; ?>
              <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
            </div>
          </div>
          <?php endif; ?>

          <!-- Stats -->
          <div class="col-md-12 mb-4">
            <div class="card">
              <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fa fa-sitemap"></i> Sitemap Statistics</h6>
              </div>
              <div class="card-body">
                <div class="row text-center">
                  <div class="col-md-3 mb-3">
                    <h3 class="text-primary"><?php echo number_format($totalUrls); ?></h3>
                    <small>Total URLs</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-success"><?php echo number_format($totalPosts); ?></h3>
                    <small>Blog Posts</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-info"><?php echo number_format($totalStores); ?></h3>
                    <small>Stores</small>
                  </div>
                  <div class="col-md-3 mb-3">
                    <h3 class="text-warning"><?php echo number_format($totalCoupons); ?></h3>
                    <small>Coupons</small>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Actions -->
          <div class="col-md-6 mb-4">
            <div class="card">
              <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fa fa-cog"></i> Sitemap Actions</h6>
              </div>
              <div class="card-body">
                <form method="post">
                  <input type="hidden" name="action" value="generate_sitemap">
                  <button type="submit" class="btn btn-success btn-block mb-3">
                    <i class="fa fa-sync"></i> Generate Sitemap
                  </button>
                </form>
                
                <form method="post">
                  <input type="hidden" name="action" value="submit_sitemap">
                  <button type="submit" class="btn btn-primary btn-block mb-3">
                    <i class="fa fa-paper-plane"></i> Submit to Search Engines
                  </button>
                </form>
                
                <a href="<?php echo SITE_URL; ?>/sitemap.xml" target="_blank" class="btn btn-info btn-block">
                  <i class="fa fa-eye"></i> View Sitemap
                </a>
              </div>
            </div>
          </div>

          <!-- Robots.txt -->
          <div class="col-md-6 mb-4">
            <div class="card">
              <div class="card-header bg-warning text-white">
                <h6 class="mb-0"><i class="fa fa-robot"></i> robots.txt Editor</h6>
              </div>
              <div class="card-body">
                <form method="post">
                  <input type="hidden" name="action" value="update_robots">
                  <textarea name="robots_content" class="form-control" rows="10" style="font-family: monospace;"><?php echo htmlspecialchars($robotsContent); ?></textarea>
                  <button type="submit" class="btn btn-warning btn-block mt-3">
                    <i class="fa fa-save"></i> Update robots.txt
                  </button>
                </form>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
